/*
 * e4jack.0.c
 * Copyright (C) 2010-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <stdlib.h>

#include <ctype.0.h>
#include <dt.h>
#include <e4.h>
#include <e4fine.h>
#include <e4jack-defs.h>
#include <e4jack-errors.h>
#include <e4jack-types.h>

typedef struct pick_type {
    struct pick_type *pick_data;
    unsigned bits, fast;
} pick_type;

extern int x1f4_lock_e4jack
    (const char *, unsigned, int *);
extern int x1f4_pick_e4jack
    (int, int *, unsigned *, unsigned *, const char **, const char **, int,
     int, void *, void (*) (const char **), const struct x1f4_datatype_type *,
     const struct x1f4_datatype_type *, struct ej_back_type *);
extern int x1f4_seek_e4jack
    (const struct x1f4_datatype_type *, const char *, unsigned, int *);

extern const unsigned _x1f4_c_type_0[], _x1f4_c_type_1[];

static int pick_jack(const struct x1f4_datatype_type *,
		     const struct x1f4_datatype_type *, unsigned *, unsigned *,
		     unsigned *, const char **, void (*) (const char **),
		     unsigned *, int **, int, void *, struct ej_back_type *);

static int
pick_jack(const struct x1f4_datatype_type *datatype_data,
	  const struct x1f4_datatype_type *sidetype_data, unsigned *jack,
	  unsigned *trap, unsigned *post, const char **slip,
	  void (*join) (const char **), unsigned *fast, int **list, int land,
	  void *e4fine, struct ej_back_type *back_data)
{
    int *args, status;
    unsigned flat;

    args = *list;
    flat = *fast;

    do {
	const char *mail;
	unsigned fold = 0, mile = 0, pick = 0;

	mail = *slip;

	if (land) {
	} else {
	    join(&mail);
	    if (*mail != ')') {
		status = PARSE_ERROR;

		if (back_data) {
		    back_data->code = MISSPAIR;
		}

		if (1) {
		    break;
		}
	    }

	    mail++;
	}

	join(&mail);
	if (*mail != '(') {
	    status = PARSE_ERROR;

	    if (back_data) {
		back_data->code = MISSLEAD;
	    }

	    if (1) {
		break;
	    }
	}

	mail++;

	join(&mail);
	do {
	    const char *text;
	    unsigned c;

	    c = *mail;

	    text = mail;
	    if (c == 'v') {
		text++;
		if (*text == 'o') {
		    text++;
		    if (*text == 'i') {
			text++;
			if (*text == 'd') {
			    text++;
			    join(&text);
			    if (*text != ')') {
				text = mail;
			    } else {
				mail = text;
				if (1) {
				    status = 0;
				    if (1) {
					break;
				    }
				}
			    }
			}
		    }
		}
	    }

	    if (0) {
	    } else {
		status = 0;

		while (1) {
		    if (C_TYPE_X(_x1f4_c_type_1, c)) {
			int type;
			unsigned bits = 0, near;

			mail++;
			c = *(const unsigned char *) mail;
			while (C_TYPE_X(_x1f4_c_type_0, c)) {
			    mail++;
			    c = *(const unsigned char *) mail;
			}

			near = mail - text;

			status = x1f4_lock_e4jack(text, near, &type);
			if (status) {
			    status = x1f4_seek_e4jack
				(datatype_data, text, near, &type);
			    if (status) {
				status = x1f4_seek_e4jack
				    (sidetype_data, text, near, &type);
				if (status) {
				    status = PARSE_ERROR;

				    if (back_data) {
					back_data->code = MISSTYPE;
					back_data->data.misstype.name = text;
					back_data->data.misstype.size = near;
				    }

				    if (1) {
					break;
				    }
				}
			    }
			}

			join(&mail);

			c = *(const unsigned char *) mail;
			if (c == '(') {
			    const char *name;
			    unsigned size;

			    status = x1f4_pick_e4jack
				(type, &type, &bits, &size, &name, &mail, 0, 0,
				 e4fine, join, datatype_data, sidetype_data,
				 back_data);
			    if (status) {
				break;
			    }
			} else {
			    if (type == X1f4_E4_VOID) {
				status = PARSE_ERROR;

				if (back_data) {
				    back_data->code = MISSTYPE;
				    back_data->data.misstype.name = text;
				    back_data->data.misstype.size = near;
				}

				if (1) {
				    break;
				}
			    }

			    if (c == '&') {
				bits = X1f4_E4_POST_XSET;

				mail++;

				join(&mail);

				c = *(const unsigned char *) mail;
			    }

			    if (C_TYPE_X(_x1f4_c_type_1, c)) {
				mail++;
				c = *(const unsigned char *) mail;
				while (C_TYPE_X(_x1f4_c_type_0, c)) {
				    mail++;
				    c = *(const unsigned char *) mail;
				}
			    }
			}

			if (pick ^ flat) {
			} else {
			    int *deck;

			    deck = realloc
				(args - flat, sizeof(int) * (flat << 1));
			    if (deck) {
				args = deck + flat;
				flat <<= 1;
			    } else {
				status = ALLOC_ERROR;
				if (1) {
				    break;
				}
			    }
			}

			*args++ = type;
			*args++ = bits;

			mile |= bits;

			pick += 2;

			join(&mail);

			c = *(const unsigned char *) mail;
			if (c == ',') {
			    mail++;
			    join(&mail);
			    c = *(const unsigned char *) mail;

			    text = mail;
			} else {
			    if (c == ')') {
				break;
			    }
			}
		    } else {
			int reference = 0;

			if (c == '&') {
			    mail++;
			    join(&mail);
			    c = *(const unsigned char *) mail;
			    reference = 1;
			}

			if (c == '.') {
			    if (mail[1] == '.') {
				if (mail[2] == '.') {
				    const char *hail;

				    hail = mail + 3;
				    join(&hail);
				    if (*hail == ')') {
					fold |= X1f4_E4_SIDE_LIST;
					mail = hail;
					if (1) {
					    status = 0;
					    if (reference) {
						fold |= X1f4_E4_LINK_PASS;
					    }
					}
				    }
				}
			    }

			    break;
			} else {
			    if (c == ',' || c == ')') {
				unsigned bits = 0;

				if (reference) {
				    bits = X1f4_E4_POST_XSET;
				}

				if (pick ^ flat) {
				} else {
				    int *deck;

				    deck = realloc
					(args - flat,
					 sizeof(int) * (flat << 1));
				    if (deck) {
					args = deck + flat;
					flat <<= 1;
				    } else {
					status = ALLOC_ERROR;
					if (1) {
					    break;
					}
				    }
				}

				*args++ = X1f4_E4_SLIP;
				*args++ = bits;

				mile |= bits;

				pick += 2;

				fold |= X1f4_E4_SLIP_LIST;

				if (c == ',') {
				    mail++;
				    join(&mail);
				    c = *(const unsigned char *) mail;

				    text = mail;
				} else {
				    break;
				}
			    } else {
				break;
			    }
			}
		    }
		}
	    }
	} while (0);

	if (*mail == ')') {
	} else {
	    if (status) {
	    } else {
		status = PARSE_ERROR;

		if (back_data) {
		    back_data->code = MISSLINK;
		}
	    }
	}

	if (status) {
	} else {
	    *jack = pick;
	    *post = mile;
	    *slip = mail + 1;
	    *trap = fold;
	}

	args -= pick;
    } while (0);

    *fast = flat;
    *list = args;

    return status;
}


int
x1f4_pick_e4jack(int type, int *jack, unsigned *bits, unsigned *size,
		 const char **name, const char **slip, int fail, int land,
		 void *e4fine, void (*join) (const char **),
		 const struct x1f4_datatype_type *datatype_data,
		 const struct x1f4_datatype_type *sidetype_data,
		 struct ej_back_type *back_data)
{
    const char *mail;
    int status = 0;
    unsigned c, call = 0;

    mail = *slip;

    while (1) {
	join(&mail);
	c = *(const unsigned char *) mail;
	if (c == '(') {
	    mail++;
	    join(&mail);
	    if (*mail == '*') {
		mail++;
		call++;
	    } else {
		call = 0;
		if (1) {
		    break;
		}
	    }
	} else {
	    break;
	}
    }

    if (call) {
	if (c == '&') {
	    if (fail) {
		call = 0;

		status = PARSE_ERROR;

		if (back_data) {
		    back_data->code = LINKNODE;
		}
	    }
	}
    }

    if (call) {
	int *args;
	const char *side;
	unsigned flat = 32, near, post;

	if (c == '&') {
	    post = X1f4_E4_POST_XSET;

	    mail++;

	    join(&mail);

	    c = *(const unsigned char *) mail;
	} else {
	    post = 0;
	}

	if (land) {
	    call++;
	}

	side = mail;

	if (C_TYPE_X(_x1f4_c_type_1, c)) {
	    mail++;
	    c = *(const unsigned char *) mail;
	    while (C_TYPE_X(_x1f4_c_type_0, c)) {
		mail++;
		c = *(const unsigned char *) mail;
	    }
	}

	near = mail - side;

	args = malloc(sizeof(int) * flat);
	if (args) {
	    int file, last = 0;
	    struct pick_type *pick_data = NULL;

	    file = land;

	    do {
		unsigned fast = 0, fold = 0, mile = 0;

		status = pick_jack
		    (datatype_data, sidetype_data, &fast, &fold, &mile, &mail,
		     join, &flat, &args, file, e4fine, back_data);
		if (status) {
		    break;
		} else {
		    struct pick_type *pick_long;

		    pick_long = malloc
			(sizeof(struct pick_type) + fast * sizeof(int));
		    if (pick_long) {
			int *dana;
			unsigned news;

			pick_long->pick_data = pick_data;

			pick_data = pick_long;

			dana = (void *) (pick_data + 1);

			news = fast >> 1;

			pick_data->fast = news;

			file = 0;

			if (mile) {
			    int *beta;

			    fold |= X1f4_E4_POST_TYPE;
			    beta = dana + news;
			    for (; news; news--) {
				*dana++ = *args++;
				*beta++ = *args++;
			    }
			} else {
			    for (; news; news--) {
				*dana++ = *args;
				args += 2;
			    }
			}

			pick_data->bits = fold;

			args -= fast;

			call--;
		    } else {
			status = ALLOC_ERROR;
			if (1) {
			    break;
			}
		    }
		}
	    } while (call);

	    if (call) {
	    } else {
		while (pick_data) {
		    struct x1f4_linetext_type linetext;

		    linetext.function.args = (void *) (pick_data + 1);

		    linetext.function.name = "jack";

		    linetext.function.type = type;

		    last = type;

		    linetext.function.count = pick_data->fast;
		    linetext.function.flags = pick_data->bits;

		    linetext.function.length = 4;

		    linetext.function.function = NULL;

		    status = x1f4_type_e4fine(e4fine, &type, &linetext);
		    if (status) {
			status = ALLOC_ERROR;
			if (1) {
			    break;
			}
		    } else {
			struct pick_type *pick_free;

			pick_free = pick_data;

			pick_data = pick_data->pick_data;

			free(pick_free);
		    }
		}
	    }

	    if (pick_data) {
		do {
		    struct pick_type *pick_free;

		    pick_free = pick_data;

		    pick_data = pick_data->pick_data;

		    free(pick_free);
		} while (pick_data);
	    } else {
		*name = side;
		*size = near;

		*bits = post;
		*jack = land ? last : type;

		*slip = mail;
	    }

	    free(args);
	} else {
	    status = ALLOC_ERROR;
	}
    } else {
	if (status) {
	} else {
	    status = PARSE_ERROR;

	    if (back_data) {
		back_data->code = MISSSTAR;
	    }
	}
    }

    return status;
}
