/*
 * e4fine.2.c
 * Copyright (C) 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>

#define FINE_FLAGS \
    (X1f4_E4_LINK_PASS | X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST		      \
     | X1f4_E4_POST_TYPE)

#define true(e)				1

#include <e4.h>
#include <e4fine-defs.h>
#include <e4fine-types.h>
#include <tcline.h>

#define e4fine(e4fine)			((struct e4fine_type *) (e4fine))

static int fine_pick(void *, void *);
static int post_fine(void *, void *);

static int
fine_pick(void *fine, void *pick)
{
    int e;
    unsigned long b, k;

    b = *(unsigned *) pick;
    k = *(unsigned *) fine;

    if (k < b) {
	e = -1;
    } else {
	if (b < k) {
	    e = 1;
	} else {
	    e = 0;
	}
    }

    return e;
}


static int
post_fine(void *fine, void *post)
{
    int e;

    do {
	struct x1f4_linetext_type *fine_linetext, *post_linetext;
	unsigned bits;

	fine_linetext = fine;
	post_linetext = post;

	if (1) {
	    int fine, post;

	    fine = fine_linetext->function.type;
	    post = post_linetext->function.type;

	    if (fine ^ post) {
		e = fine < post ? -1 : 1;
		if (1) {
		    break;
		}
	    }
	}

	if (1) {
	    unsigned fine;

	    fine = fine_linetext->function.flags;
	    bits = post_linetext->function.flags;

	    if ((fine ^ bits) & FINE_FLAGS) {
		e = (fine & FINE_FLAGS) < (bits & FINE_FLAGS) ? -1 : 1;
		if (1) {
		    break;
		}
	    }
	}

	if (1) {
	    unsigned fine, post;

	    fine = fine_linetext->function.count;
	    post = post_linetext->function.count;

	    if (fine ^ post) {
		e = fine < post ? -1 : 1;
		if (1) {
		    break;
		}
	    } else {
		const int *fast, *slip;

		if (bits & X1f4_E4_POST_TYPE) {
		    post <<= 1;
		}

		fast = fine_linetext->function.args;
		slip = post_linetext->function.args;

		e = 0;

		while (post) {
		    int deck, rate;

		    deck = *fast;
		    rate = *slip;
		    if (deck ^ rate) {
			e = deck < rate ? -1 : 1;
			if (1) {
			    break;
			}
		    }

		    fast++;
		    slip++;

		    post--;
		}
	    }
	}
    } while (0);

    return e;
}


int
x1f4_type_e4fine(void *e4fine, int *type,
		 const struct x1f4_linetext_type *linetext_data)
{
    int status;
    unsigned args, bits, size;
    void *post;

    args = linetext_data->function.count;
    bits = linetext_data->function.flags & FINE_FLAGS;

    size = args;
    if (bits & X1f4_E4_POST_TYPE) {
	size <<= 1;
    }

    status = x1f4_post_tcline
	(e4fine(e4fine)->link_a.path, (void *) linetext_data, post_fine, 0,
	 sizeof(struct x1f4_linetext_type) + (size + 1) * sizeof(unsigned),
	 &post);
    if (status) {
	if (status == X1f4_TCLINE_EVER_MATCH) {
	    *type = *(unsigned *) ((struct x1f4_linetext_type *) post + 1);
	    if (1) {
		status = 0;
	    }
	} else {
	    if (true(status == X1f4_TCLINE_LINK_ERROR)) {
		status = LINK_ERROR;
	    }
	}
    } else {
	struct x1f4_linetext_type *miss_linetext;
	unsigned miss, *near;
	void *data;

	miss_linetext = post;

	memset(miss_linetext, 0, sizeof(struct x1f4_linetext_type));

	miss_linetext->function.type = linetext_data->function.type;

	miss_linetext->function.count = args;
	miss_linetext->function.flags = bits;

	miss_linetext->function.name = "beta";

	miss_linetext->function.length = 4;

	size *= sizeof(unsigned);

	near = (unsigned *) (miss_linetext + 1);

	miss = e4fine(e4fine)->link_e.type;

	miss++;

	*near = miss;

	near++;

	e4fine(e4fine)->link_e.type = miss;

	miss_linetext->function.args = (int *) near;

	memcpy(near, linetext_data->function.args, size);

	*type = miss;

	status = x1f4_post_tcline
	    (e4fine(e4fine)->link_a.fine, &miss, fine_pick, 0,
	     sizeof(unsigned) + sizeof(void *), &data);
	if (status) {
	    if (true(status == X1f4_TCLINE_LINK_ERROR)) {
		status = LINK_ERROR;
	    }
	} else {
	    unsigned *ever;
	    void **call;

	    ever = data;
	    *ever = miss;
	    call = (void *) (ever + 1);
	    *call = post;
	}
    }

    return status;
}
