/*
 * e4fine.0.c
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-m.0.h>
#include <e4.h>
#include <e4fine-defs.h>
#include <e4fine-types.h>
#include <tcline.h>

static int free_path(struct e4fine_type *);
static int init_list(struct e4fine_type *, unsigned, struct screen_type *);
static int link_fine(struct e4fine_type *, unsigned, struct screen_type *);
static int link_path(struct e4fine_type *, unsigned, struct screen_type *);

static int
free_path(struct e4fine_type *e4fine_data)
{
    return x1f4_fini_tcline(&e4fine_data->link_a.path);
}


static int
init_list(struct e4fine_type *e4fine_data, unsigned bits,
	  struct screen_type *screen_data)
{
    int status;

    if (bits & RESOURCE_LINK) {
	e4fine_data->link_m.data = screen_data->link_m.data;
	e4fine_data->link_m.free = screen_data->link_m.free;
	e4fine_data->link_m.link = screen_data->link_m.link;
	e4fine_data->link_m.mode = screen_data->link_m.mode;
    } else {
	e4fine_data->link_m.data = NULL;
	e4fine_data->link_m.free = _x1f4_e4_free_data;
	e4fine_data->link_m.link = _x1f4_e4_link_data;
	e4fine_data->link_m.mode = _x1f4_e4_mode_data;
    }

    status = link_path(e4fine_data, bits, screen_data);
    if (status) {
    } else {
	status = link_fine(e4fine_data, bits, screen_data);
	if (status) {
	    free_path(e4fine_data);
	}
    }

    return status;
}


static int
link_fine(struct e4fine_type *e4fine_data, unsigned bits,
	  struct screen_type *screen_data)
{
    int status;

    if (bits & RESOURCE_LINK) {
	struct x1f4_tcline_type tcline;
	struct x1f4_trans_type trans;

	trans.free = screen_data->link_m.free;
	trans.link = screen_data->link_m.link;
	trans.mode = screen_data->link_m.mode;

	tcline.trans = &trans;

	trans.context = screen_data->link_m.data;

	status = x1f4_init_tcline
	    (&e4fine_data->link_a.fine, X1f4_TCLINE_TRANS_MASK, &tcline);
    } else {
	status = x1f4_init_tcline(&e4fine_data->link_a.fine, 0, NULL);
    }
    if (status) {
	status = LINK_ERROR;
    }

    return status;
}


static int
link_path(struct e4fine_type *e4fine_data, unsigned bits,
	  struct screen_type *screen_data)
{
    int status;

    if (bits & RESOURCE_LINK) {
	struct x1f4_tcline_type tcline;
	struct x1f4_trans_type trans;

	trans.free = screen_data->link_m.free;
	trans.link = screen_data->link_m.link;
	trans.mode = screen_data->link_m.mode;

	tcline.trans = &trans;

	trans.context = screen_data->link_m.data;

	status = x1f4_init_tcline
	    (&e4fine_data->link_a.path, X1f4_TCLINE_TRANS_MASK, &tcline);
    } else {
	status = x1f4_init_tcline(&e4fine_data->link_a.path, 0, NULL);
    }
    if (status) {
	status = LINK_ERROR;
    } else {
	e4fine_data->link_e.type = X1f4_E4_CALL;
    }

    return status;
}


int
x1f4_init_e4fine(void **e4fine, unsigned bits, struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *list, *text;

    if (bits & RESOURCE_LINK) {
	link = screen_data->link_m.link;
	text = screen_data->link_m.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &list, sizeof(struct e4fine_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_list(list, bits, screen_data);
	if (status) {
	    if (bits & RESOURCE_LINK) {
		screen_data->link_m.free(text, list);
	    } else {
		_x1f4_e4_free_data(text, list);
	    }
	} else {
	    *e4fine = list;
	}
    }

    return status;
}
