/*
 * e4.u.c
 * Copyright (C) 2007-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
# include <cardinal.v-f.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4-defs.h>
#include <e4-errors.h>
#include <e4-inter.h>
#include <e4-types.h>
#if !defined HAVE_LIBx1f4i0
# include <ordinal.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define dump_abcdef_error_i_ARGS_0 \
    void *, int (*) (void *, const char *, unsigned), struct e4_back_type *,  \
    struct e4_long_type *
#define dump_abcdef_error_i_ARGS_1 \
    void *data, int (*this) (void *, const char *, unsigned),		      \
    struct e4_back_type *back_data, struct e4_long_type *long_data
#define dump_abcdef_error_i_ARGS_2 \
    data, this, back_data, long_data

#define dump_abcdef_error_l_ARGS_0 \
    void *, int (*) (void *, const char *, unsigned), struct e4_back_type *
#define dump_abcdef_error_l_ARGS_1 \
    void *data, int (*this) (void *, const char *, unsigned),		      \
    struct e4_back_type *back_data
#define dump_abcdef_error_l_ARGS_2 \
    data, this, back_data

#define dump_type(data, type, this, back_data, long_data) \
    x1f4_dump_type((data), (type), (this), (long_data))

static int dump_080704_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_1(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_2(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_3(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_4(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_5(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_6(dump_abcdef_error_i_ARGS_0);
static int dump_080704_error_7(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_8(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_9(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_b(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_d(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_e(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_f(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_g(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_h(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_i(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_j(dump_abcdef_error_l_ARGS_0);
static int dump_080704_error_k(dump_abcdef_error_i_ARGS_0);
static int dump_081014_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_081014_error_1(dump_abcdef_error_i_ARGS_0);
static int dump_081014_error_2(dump_abcdef_error_l_ARGS_0);
static int dump_081019_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_110605_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_110605_error_1(dump_abcdef_error_l_ARGS_0);
static int dump_110608_error_1(dump_abcdef_error_l_ARGS_0);
static int dump_110608_error_2(dump_abcdef_error_l_ARGS_0);
static int dump_110608_error_3(dump_abcdef_error_l_ARGS_0);
static int dump_110608_error_4(dump_abcdef_error_l_ARGS_0);
static int dump_110608_error_5(dump_abcdef_error_l_ARGS_0);
static int dump_110608_error_6(dump_abcdef_error_l_ARGS_0);
static int dump_110608_error_7(dump_abcdef_error_l_ARGS_0);
static int dump_110608_error_9(dump_abcdef_error_l_ARGS_0);
static int dump_110817_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_120712_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_130607_error_0(dump_abcdef_error_i_ARGS_0);
static int dump_130704_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_mind(void *, int (*) (void *, const char *, unsigned),
		     struct e4_mind_type *);

static int
dump_080704_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, "undefined `", 11);
    if (status) {
    } else {
	status = this
	    (data, back_data->data.l_lookup.name,
	     back_data->data.l_lookup.size);
	if (status) {
	} else {
	    status = this(data, "' function", 10);
	}
    }

    return status;
}


static int
dump_080704_error_1(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, "undefined `", 11);
    if (status) {
    } else {
	status = this
	    (data, back_data->data.e_lookup.name,
	     back_data->data.e_lookup.size);
	if (status) {
	} else {
	    status = this(data, "' variable", 10);
	}
    }

    return status;
}


static int
dump_080704_error_2(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, "used void `", 11);
    if (status) {
    } else {
	status = this
	    (data, back_data->data.usedvoid.name,
	     back_data->data.usedvoid.size);
	if (status) {
	} else {
	    status = this(data, "' function value", 16);
	}
    }

    return status;
}


static int
dump_080704_error_3(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, "bad `", 5);
    if (status) {
    } else {
	const char *byte;

	byte = back_data->data.bytemiss.byte;

	status = this(data, byte, 1);
	if (status) {
	} else {
	    status = this(data, "' (", 3);
	    if (status) {
	    } else {
		status = x1f4_vprint_fcardinal
		    (data, this, 0, 4, 8, *(unsigned char *) byte);
		if (status) {
		} else {
		    status = this(data, ") character", 11);
		}
	    }
	}
    }

    return status;
}


static int
dump_080704_error_4(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "syntax error", 12);
}


static int
dump_080704_error_5(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "unexpected expression completion", 32);
}


static int
dump_080704_error_6(dump_abcdef_error_i_ARGS_1)
{
    int status;

    status = this(data, "undefined ", 10);
    if (status) {
    } else {
	status = dump_type
	    (data, this, back_data->data.binary_r.f1st, back_data, long_data);
	if (status) {
	} else {
	    status = this(data, " ", 1);
	    if (status) {
	    } else {
		status = dump_type
		    (data, this, back_data->data.binary_r.f2nd, back_data,
		     long_data);
		if (status) {
		} else {
		    status = this(data, " `", 2);
		    if (status) {
		    } else {
			status = this
			    (data, back_data->data.binary_r.name,
			     back_data->data.binary_r.size);
			if (status) {
			} else {
			    status = this(data, "' infix binary operator", 23);
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
dump_080704_error_7(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, "assignment of read-only variable `", 34);
    if (status) {
    } else {
	status = this
	    (data, back_data->data.c_lvalue.name,
	     back_data->data.c_lvalue.size);
	if (status) {
	} else {
	    status = this(data, "'", 1);
	}
    }

    return status;
}


static int
dump_080704_error_8(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, "context type mismatched `", 25);
    if (status) {
    } else {
	status = this
	    (data, back_data->data.l_syntax.name,
	     back_data->data.l_syntax.size);
	if (status) {
	} else {
	    status = this(data, "' function", 10);
	}
    }

    return status;
}


static int
dump_080704_error_9(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, "context type mismatched `", 25);
    if (status) {
    } else {
	status = this
	    (data, back_data->data.e_syntax.name,
	     back_data->data.e_syntax.size);
	if (status) {
	} else {
	    status = this(data, "' variable", 10);
	}
    }

    return status;
}


static int
dump_080704_error_b(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "invalid lvalue in assignment", 28);
}


static int
dump_080704_error_d(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "invalid real scalar syntax", 26);
}


static int
dump_080704_error_e(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "invalid scalar syntax", 23);
}


static int
dump_080704_error_f(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "invalid constant string syntax", 30);
}


static int
dump_080704_error_g(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "unexpected prefix unary operator", 32);
}


static int
dump_080704_error_h(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "unexpected infix binary operator", 32);
}


static int
dump_080704_error_i(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "undefined prefix unary operator", 31);
}


static int
dump_080704_error_j(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "undefined infix binary operator", 31);
}


static int
dump_080704_error_k(dump_abcdef_error_i_ARGS_1)
{
    int status;

    status = this(data, "incompatible type for the ", 26);
    if (status) {
    } else {
	unsigned rank;

	rank = back_data->data.misstype.rank;
	status = x1f4_vprint_dcardinal(data, this, rank);
	if (status) {
	} else {
	    char suffix[2];

	    x1f4_extend_ordinal(suffix, rank - 1);
	    status = this(data, suffix, 2);
	    if (status) {
	    } else {
		status = this(data, " argument of function ", 22);
		if (status) {
		} else {
		    status = dump_mind
			(data, this, &back_data->data.misstype.mind);
		    if (status) {
		    } else {
			status = this(data, " (expected ", 11);
			if (status) {
			} else {
			    status = dump_type
				(data, this, back_data->data.misstype.f1st,
				 back_data, long_data);
			    if (status) {
			    } else {
				status = this(data, ", got ", 6);
				if (status) {
				} else {
				    status = dump_type
					(data, this,
					 back_data->data.misstype.f2nd,
					 back_data, long_data);
				    if (status) {
				    } else {
					status = this(data, ")", 1);
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
dump_081014_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, "invalid reference value for ", 28);
    if (status) {
    } else {
	unsigned rank;

	rank = back_data->data.i_svalue.rank;
	status = x1f4_vprint_dcardinal(data, this, rank);
	if (status) {
	} else {
	    char suffix[2];

	    x1f4_extend_ordinal(suffix, rank - 1);
	    status = this(data, suffix, 2);
	    if (status) {
	    } else {
		status = this(data, " argument of function ", 22);
		if (status) {
		} else {
		    status = dump_mind
			(data, this, &back_data->data.i_svalue.mind);
		}
	    }
	}
    }

    return status;
}


static int
dump_081014_error_1(dump_abcdef_error_i_ARGS_1)
{
    int status;

    status = this(data, "invalid type of reference value for ", 36);
    if (status) {
    } else {
	unsigned rank;

	rank = back_data->data.t_svalue.rank;
	status = x1f4_vprint_dcardinal(data, this, rank);
	if (status) {
	} else {
	    char suffix[2];

	    x1f4_extend_ordinal(suffix, rank - 1);
	    status = this(data, suffix, 2);
	    if (status) {
	    } else {
		status = this(data, " argument of function ", 22);
		if (status) {
		} else {
		    status = dump_mind
			(data, this, &back_data->data.t_svalue.mind);
		    if (status) {
		    } else {
			status = this(data, " (expected ", 11);
			if (status) {
			} else {
			    status = dump_type
				(data, this, back_data->data.t_svalue.f1st,
				 back_data, long_data);
			    if (status) {
			    } else {
				status = this(data, ", got ", 6);
				if (status) {
				} else {
				    status = dump_type
					(data, this,
					 back_data->data.t_svalue.f2nd,
					 back_data, long_data);
				    if (status) {
				    } else {
					status = this(data, ")", 1);
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
dump_081014_error_2(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, "read-only reference value for ", 30);
    if (status) {
    } else {
	unsigned rank;

	rank = back_data->data.c_svalue.rank;
	status = x1f4_vprint_dcardinal(data, this, rank);
	if (status) {
	} else {
	    char suffix[2];

	    x1f4_extend_ordinal(suffix, rank - 1);
	    status = this(data, suffix, 2);
	    if (status) {
	    } else {
		status = this(data, " argument of function ", 22);
		if (status) {
		} else {
		    status = dump_mind
			(data, this, &back_data->data.c_svalue.mind);
		}
	    }
	}
    }

    return status;
}


static int
dump_081019_error_0(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "character constant syntax error", 31);
}


static int
dump_110605_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this
	(data, "comma (`,') found where closing parenthesis (`)') would have"
	 " been in order", 74);
    if (status) {
    } else {
	if (back_data->data.surestep.mind.type ^ VOID) {
	    status = this(data, " (extra arguments for function ", 31);
	    if (status) {
	    } else {
		status = dump_mind(data, this, &back_data->data.surestep.mind);
		if (status) {
		} else {
		    status = this(data, ", maybe?)", 9);
		}
	    }
	}
    }

    return status;
}


static int
dump_110605_error_1(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this
	(data, "closing parenthesis (`)') found where comma (`,') would have"
	 " been in order", 74);
    if (status) {
    } else {
	if (back_data->data.surelose.mind.type ^ VOID) {
	    status = this
		(data, " (too few function arguments for function ", 42);
	    if (status) {
	    } else {
		status = dump_mind(data, this, &back_data->data.surelose.mind);
		if (status) {
		} else {
		    status = this(data, ", maybe?)", 9);
		}
	    }
	}
    }

    return status;
}


static int
dump_110608_error_1(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "unexpected identifier", 21);
}


static int
dump_110608_error_2(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "unexpected dot or digit", 23);
}


static int
dump_110608_error_3(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "stray double quote (`\"')", 24);
}


static int
dump_110608_error_4(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "stray closing parenthesis (`)')", 31);
}


static int
dump_110608_error_5(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "stray comma (`,')", 17);
}


static int
dump_110608_error_6(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "stray opening parenthesis (`(')", 31);
}


static int
dump_110608_error_7(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, "stray `", 7);
    if (status) {
    } else {
	char c;

	c = back_data->data.nearjoin.join;
	status = this(data, &c, 1);
	if (status) {
	} else {
	    status = this(data, "'", 1);
	}
    }

    return status;
}


static int
dump_110608_error_9(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "stray apostrophe (`'')", 22);
}


static int
dump_110817_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, "called `", 8);
    if (status) {
    } else {
	status = this
	    (data, back_data->data.l_lookup.name,
	     back_data->data.l_lookup.size);
	if (status) {
	} else {
	    status = this(data, "' object is not function", 24);
	}
    }

    return status;
}


static int
dump_120712_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this
	(data, "missed closing parenthesis (`)') for zero arguments function ",
	 61);
    if (status) {
    } else {
	status = dump_mind(data, this, &back_data->data.nearvoid.mind);
    }

    return status;
}


static int
dump_130607_error_0(dump_abcdef_error_i_ARGS_1)
{
    int status;

    status = this(data, "expression type (", 17);
    if (status) {
    } else {
	status = dump_type
	    (data, this, back_data->data.missturn.f1st, back_data, long_data);
	if (status) {
	} else {
	    status = this(data, ") not convertible to target type (", 34);
	    if (status) {
	    } else {
		status = dump_type
		    (data, this, back_data->data.missturn.f2nd, back_data,
		     long_data);
		if (status) {
		} else {
		    status = this(data, ")", 1);
		}
	    }
	}
    }

    return status;
}


static int
dump_130704_error_0(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "used void value", 15);
}


static int
dump_mind(void *data, int (*this) (void *, const char *, unsigned),
	  struct e4_mind_type *mind_data)
{
    int status = 0;

    do {
	int type;

	type = mind_data->type;
	if (type ^ LAST) {
	    status = this(data, "called via", 10);
	    if (status) {
		break;
	    }
	}
	if (type ^ LOCK) {
	} else {
	    status = this(data, " ", 1);
	    if (status) {
		break;
	    }
	}
	if (type ^ PICK) {
	    status = this(data, "`", 1);
	    if (status) {
	    } else {
		status = this(data, mind_data->name, mind_data->length);
		if (status) {
		} else {
		    status = this(data, "'", 1);
		}
	    }
	}
	if (type ^ LAST) {
	    status = this(data, " pointer", 8);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return status;
}


int
x1f4_stat_expression(void *data, int (*this) (void *, const char *, unsigned),
		     struct e4_back_type *back_data,
		     struct e4_long_type *long_data)
{
    int status;

    switch (back_data->code) {
    case BINARY_R:
	status = dump_080704_error_6(data, this, back_data, long_data);
	break;
    case BYTEMISS:
	status = dump_080704_error_3(data, this, back_data);
	break;
    case B_LOOKUP:
	status = dump_080704_error_j(data, this, back_data);
	break;
    case B_SCALAR:
	status = dump_080704_error_e(data, this, back_data);
	break;
    case C_LVALUE:
	status = dump_080704_error_7(data, this, back_data);
	break;
    case C_STRING:
	status = dump_080704_error_f(data, this, back_data);
	break;
    case C_SVALUE:
	status = dump_081014_error_2(data, this, back_data);
	break;
    case C_SYNTAX:
	status = dump_081019_error_0(data, this, back_data);
	break;
    case EXPECTED:
	status = dump_080704_error_5(data, this, back_data);
	break;
    case E_LOOKUP:
	status = dump_080704_error_1(data, this, back_data);
	break;
    case E_SYNTAX:
	status = dump_080704_error_9(data, this, back_data);
	break;
    case F_SYNTAX:
	status = dump_080704_error_4(data, this, back_data);
	break;
    case I_LVALUE:
	status = dump_080704_error_b(data, this, back_data);
	break;
    case I_SVALUE:
	status = dump_081014_error_0(data, this, back_data);
	break;
    case LONGVOID:
	status = dump_130704_error_0(data, this, back_data);
	break;
    case L_LOOKUP:
	status = dump_080704_error_0(data, this, back_data);
	break;
    case L_SYNTAX:
	status = dump_080704_error_8(data, this, back_data);
	break;
    case MISSCALL:
	status = dump_110817_error_0(data, this, back_data);
	break;
    case MISSTURN:
	status = dump_130607_error_0(data, this, back_data, long_data);
	break;
    case MISSTYPE:
	status = dump_080704_error_k(data, this, back_data, long_data);
	break;
    case NEARCITE:
	status = dump_110608_error_9(data, this, back_data);
	break;
    case NEARJOIN:
	status = dump_110608_error_7(data, this, back_data);
	break;
    case NEARLOSE:
	status = dump_110608_error_4(data, this, back_data);
	break;
    case NEARNAME:
	status = dump_110608_error_1(data, this, back_data);
	break;
    case NEAROPEN:
	status = dump_110608_error_6(data, this, back_data);
	break;
    case NEARREAL:
	status = dump_110608_error_2(data, this, back_data);
	break;
    case NEARSTEP:
	status = dump_110608_error_5(data, this, back_data);
	break;
    case NEARTEXT:
	status = dump_110608_error_3(data, this, back_data);
	break;
    case NEARVOID:
	status = dump_120712_error_0(data, this, back_data);
	break;
    case P_LOOKUP:
	status = dump_080704_error_i(data, this, back_data);
	break;
    case R_SCALAR:
	status = dump_080704_error_d(data, this, back_data);
	break;
    case SURELOSE:
	status = dump_110605_error_1(data, this, back_data);
	break;
    case SURESTEP:
	status = dump_110605_error_0(data, this, back_data);
	break;
    case T_SVALUE:
	status = dump_081014_error_1(data, this, back_data, long_data);
	break;
    case USEDVOID:
	status = dump_080704_error_2(data, this, back_data);
	break;
    case U_BINARY:
	status = dump_080704_error_h(data, this, back_data);
	break;
    case U_PREFIX:
	status = dump_080704_error_g(data, this, back_data);
	break;
    default:
	status = this(data, "no description available", 24);
    }

    return status;
}
