/*
 * e4.s.c
 * Copyright (C) 2008-2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * RATIONALE
 *
 * the subexpression loaders as set by some routines may be inappropriate for
 * single atom subexpressions, when the atom is a variable one.  The here
 * routine sets the subexpression loaders to proper loaders.
 */

#include <e4-config.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-line.h>
#include <e4-types.h>

#if __DIRECT_FAST_MISS_LOAD__
# define _x1f4_e4_fast_miss		_x1f4_e4_fast_miss__
#endif				/* __DIRECT_FAST_MISS_LOAD__ */

static int ever_last(struct e4_atom_type *);
static int load_bill(x1f4_e4_LOAD_ARGS_0);
static int load_ever(x1f4_e4_LOAD_ARGS_0);
static int load_mode(x1f4_e4_LOAD_ARGS_0);
static int load_real(x1f4_e4_LOAD_ARGS_0);
static int load_text(x1f4_e4_LOAD_ARGS_0);
static int load_user(x1f4_e4_LOAD_ARGS_0);

static int
ever_last(struct e4_atom_type *atom_data)
{
    int delete;

    while (1) {
	int type;

	type = atom_data->type;
	if (type == EVER) {
	    delete = 1;
	    if (1) {
		break;
	    }
	} else {
	    if (type == THIS) {
		struct e4_hack_type *hack_data;

		hack_data = atom_data->data.hack.data;
		if (hack_data->count != 1) {
		    delete = 0;
		    if (1) {
			break;
		    }
		} else {
		    atom_data = hack_data->atoms;
		}
	    } else {
		delete = 0;
		if (1) {
		    break;
		}
	    }
	}
    }

    return delete;
}


static int
load_bill(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	if (high_record(post_data)) {
	    C_BILL *state;

	    state = (void *) &post_data->data;
	    *state = *(C_BILL *) line_record(post_data);
	}
    }

    return status;
}


static int
load_ever(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	list[-1] = line_record(post_data);
    }

    return status;
}


static int
load_mode(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	if (high_record(post_data)) {
	    C_MODE *state;

	    state = (void *) &post_data->data;
	    *state = *(C_MODE *) line_record(post_data);
	}
    }

    return status;
}


static int
load_real(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	if (high_record(post_data)) {
	    C_REAL *state;

	    state = (void *) &post_data->data;
	    *state = *(C_REAL *) line_record(post_data);
	}
    }

    return status;
}


static int
load_text(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	if (high_record(post_data)) {
	    C_TEXT *state;

	    state = (void *) &post_data->data;
	    *state = *(C_TEXT *) line_record(post_data);
	}
    }

    return status;
}


static int
load_user(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	if (high_record(post_data)) {
	    C_USER *state;

	    state = (void *) &post_data->data;
	    *state = *(C_USER *) line_record(post_data);
	}
    }

    return status;
}


void
_x1f4_e4_fast_miss(struct e4_hack_type *hack_data, unsigned post,
		   int (**load) (x1f4_e4_LOAD_ARGS_0))
{
    if (hack_data->count == 1) {
	struct e4_atom_type *atom_data;

	atom_data = hack_data->atoms;

	if (atom_data->odb1) {
	    *load = _x1f4_e4_load_THIS;
	} else {
	    if (1) {
		if (post & HERE_XSET) {
		    *load = load_ever;
		} else {
		    if (ever_last(atom_data)) {
			int type;

			type = atom_data->data.ever.ever_data->type;
			if (type == BILL) {
			    *load = load_bill;
			} else {
			    if (type == MODE) {
				*load = load_mode;
			    } else {
				if (type == REAL) {
				    *load = load_real;
				} else {
				    if (type == TEXT) {
					*load = load_text;
				    } else {
					*load = load_user;
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
}
