/*
 * e4.o.c
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-defs.h>
#include <e4-line.h>
#include <e4-types.h>
#include <exerrors.h>

int
_x1f4_e4_load_Bill(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    const struct e4_sset_type *sset_data;
    void *address;

    sset_data = ((struct e4_atom_type *) level)->data.ever.state;

    status = sset_data->get
	(sset_data->context,
	 ((struct e4_atom_type *) level)->data.ever.ever_data, &address);
    if (status) {
	status = X1f4_EX_CANNOT_CONTINUE;
    } else {
	C_BILL *state;

	state = (C_BILL *) &post_data->data;
	*state = *(C_BILL *) address;
	flat_record(post_data);
    }

    return status;
}


int
_x1f4_e4_load_Mode(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    const struct e4_sset_type *sset_data;
    void *address;

    sset_data = ((struct e4_atom_type *) level)->data.ever.state;

    status = sset_data->get
	(sset_data->context,
	 ((struct e4_atom_type *) level)->data.ever.ever_data, &address);
    if (status) {
	status = X1f4_EX_CANNOT_CONTINUE;
    } else {
	C_MODE *state;

	state = (C_MODE *) &post_data->data;
	*state = *(C_MODE *) address;
	flat_record(post_data);
    }

    return status;
}


int
_x1f4_e4_load_Real(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    const struct e4_sset_type *sset_data;
    void *address;

    sset_data = ((struct e4_atom_type *) level)->data.ever.state;

    status = sset_data->get
	(sset_data->context,
	 ((struct e4_atom_type *) level)->data.ever.ever_data, &address);
    if (status) {
	status = X1f4_EX_CANNOT_CONTINUE;
    } else {
	C_REAL *state;

	state = (C_REAL *) &post_data->data;
	*state = *(C_REAL *) address;
	flat_record(post_data);
    }

    return status;
}


int
_x1f4_e4_load_Text(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    const struct e4_sset_type *sset_data;
    void *address;

    sset_data = ((struct e4_atom_type *) level)->data.ever.state;

    status = sset_data->get
	(sset_data->context,
	 ((struct e4_atom_type *) level)->data.ever.ever_data, &address);
    if (status) {
	status = X1f4_EX_CANNOT_CONTINUE;
    } else {
	C_TEXT *state;

	state = (C_TEXT *) &post_data->data;
	*state = *(C_TEXT *) address;
	flat_record(post_data);
    }

    return status;
}


int
_x1f4_e4_load_User(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    const struct e4_sset_type *sset_data;
    void *address;

    sset_data = ((struct e4_atom_type *) level)->data.ever.state;

    status = sset_data->get
	(sset_data->context,
	 ((struct e4_atom_type *) level)->data.ever.ever_data, &address);
    if (status) {
	status = X1f4_EX_CANNOT_CONTINUE;
    } else {
	C_USER *state;

	state = (C_USER *) &post_data->data;
	*state = *(C_USER *) address;
	flat_record(post_data);
    }

    return status;
}
