/*
 * e4.l.c
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-line.h>
#include <e4-types.h>

int
x1f4_deck_expression(struct e4_expression_type *expression_data, void **deck)
{
    struct e4_lead_type *lead_data;
    struct e4_post_type *post_data;

    post_data = expression_data->post_data;

    lead_data = (void *) &post_data->data;

    if (high_record(post_data)) {
	struct e4_lead_type lead;

	lead = *(struct e4_lead_type *) line_record(post_data);
	flat_record(post_data);
	*lead_data = lead;
    }

    *deck = lead_data;

    return 0;
}
