/*
 * e4.k.c
 * Copyright (C) 2007-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>
#include <e4fine-e4.h>

typedef struct line_type {
    int (*call) (void *, const char *, unsigned);
    void *back;
} line_type;

extern const char *_x1f4_e4_type_names[];
extern const unsigned _x1f4_e4_type_sizes[];

static int type_pass(void *, const char *, unsigned);
static int type_star(void *, const char *, unsigned);

static int
type_pass(void *text, const char *name, unsigned size)
{
    struct line_type *line_data;

    line_data = text;

    return line_data->call(line_data->back, "(*&)", 4);
}


static int
type_star(void *text, const char *name, unsigned size)
{
    struct line_type *line_data;

    line_data = text;

    return line_data->call(line_data->back, "(*)", 3);
}


int
x1f4_miss_type(void *data, int (*this) (void *, const char *, unsigned),
	       int type, unsigned bits, struct e4_long_type *long_data)
{
    int status;

    if (type < VOID) {
	if (type ^ SIDE) {
	    status = this
		(data, _x1f4_e4_type_names[type], _x1f4_e4_type_sizes[type]);
	} else {
	    status = 0;
	}
    } else {
	if (type == VOID) {
	    status = this(data, "void", 4);
	} else {
	    status = 0;
	    if (long_data) {
		int (*fix) (const void *, int, const char **,
			    unsigned *);

		fix = long_data->type_l.fix;
		if (fix) {
		    const char *name;
		    unsigned size;
		    const void *context;

		    context = long_data->type_l.context;

		    if (fix(context, type, &name, &size)) {
			const void *e4fine;

			e4fine = long_data->type_q.e4fine;
			if (e4fine) {
			    const void *down;

			    status = x1f4_pick_e4fine
				(e4fine, type, &down);
			    if (status) {
				struct line_type blue;

				blue.back = data;
				blue.call = this;

				status = x1f4_vprint_xtfunction
				    (data, this, &blue,
				     bits & HERE_XSET ? type_pass : type_star,
				     &((struct e4_line_type *) down)->last,
				     long_data);
			    } else {
				status = this(data, "<user>", 6);
			    }
			} else {
			    status = this(data, "<user>", 6);
			}
		    } else {
			status = this(data, name, size);
		    }
		}
	    }
	}
    }

    return status;
}
