/*
 * e4.j.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TODO
 *
 * scan_hack happily disallows allowable cases - may rewrite more carefully
 */

/*
 * NOTES, #1
 *
 * decide whether the value of variables may change in unpredictable fashion.
 * For if it is does, the direct access method of computing the value of
 * subexpression will not do.  And it will not do for it does not save the
 * evaluated value of variables and instead records only the address where it
 * is stored.
 *
 * Consider:
 *
 *     a * f(a)
 *
 * where _a_ is first 8 and _f_ sets _a_ to 7.  The direct access method may
 * well evaluate expression 49.
 *
 * For such reason, the argument subexpressions are to be descended.  The side
 * effect KEEP_CALL functions are candidates for variable value modifiers (it
 * may be that there should be another, more specific flag to indicate whether
 * a function modifies variable values).
 *
 *
 */

#include <e4-config.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>

#if __RECORD_POST__
# define XSET_HACK			(1 << 0)
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
static int scan_hack(struct e4_hack_type *, int, unsigned *);
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
static int
scan_hack(struct e4_hack_type *hack_data, int side, unsigned *slip)
{
    struct e4_atom_type *atom_data;
    unsigned bits = 0, count;

    count = hack_data->count;
    atom_data = hack_data->atoms;

    for (; count; count--) {
	struct e4_odb1_type *odb1_data;

	odb1_data = atom_data->odb1;
	if (odb1_data) {
	    if (0) {
		if (1) {
		    do {
			const struct e4_odbx_type *odbx_data;

			odbx_data = odb1_data->odbx_data;
			odb1_data = odb1_data->odb1_data;
			if (odbx_data->flags & KEEP_CALL) {
			    bits |= XSET_HACK;
			    if (1) {
				break;
			    }
			}
		    } while (odb1_data);
		    if (bits) {
			break;
		    }
		}
	    }

	    break;
	} else {
	    int type;

	    type = atom_data->type;

	    /*
	     * See NOTES, #1
	     */
	    if (type == LAST) {
		struct e4_hack_type *this_hack;
		const struct e4_last_type *last_data;

		this_hack = atom_data->data.last.base;

		last_data = hack_base(this_hack)->last_data;
		if (last_data->flags & (KEEP_CALL | POST_TYPE)) {
		    bits |= XSET_HACK;
		    if (1) {
			break;
		    }
		}
		{
		    unsigned count;

		    count = last_data->count;
		    for (; count; count--) {
			unsigned miss;

			scan_hack(this_hack, 1, &miss);
			if (miss) {
			    bits |= miss;
			    if (1) {
				break;
			    }
			}

			this_hack++;
		    }

		    if (bits) {
			break;
		    }
		}
	    } else {
		if (type == LOCK || type == PICK) {
		    bits |= XSET_HACK;
		    if (1) {
			break;
		    }
		} else {
		    if (type == THIS) {
			unsigned miss;

			scan_hack(atom_data->data.hack.data, 1, &miss);
			if (miss) {
			    bits |= miss;
			    if (1) {
				break;
			    }
			}
		    }
		}
	    }

	    {
		struct e4_odb2_type *odb2_data;

		odb2_data = atom_data->odb2._2nd;
		if (odb2_data) {
		    do {
			const struct e4_odbx_type *odbx_data;

			odbx_data = odb2_data->odbx_data;
			odb2_data = odb2_data->odb2_data;
			if (odbx_data->flags & KEEP_CALL) {
			    bits |= XSET_HACK;
			    if (1) {
				break;
			    }
			}
			if (odbx_data->flags & LEFT_XSET) {
			    if (count != 1) {
				bits |= XSET_HACK;
				if (1) {
				    break;
				}
			    } else {
				if (odb2_data) {
				    bits |= XSET_HACK;
				    if (1) {
					break;
				    }
				} else {
				    if (side) {
					bits |= XSET_HACK;
					if (1) {
					    break;
					}
				    }
				}
			    }
			}
		    } while (odb2_data);
		    if (bits) {
			break;
		    }
		}
	    }

	    atom_data++;
	}
    }

    *slip = bits;

    return (int) count;
}
#endif				/* __RECORD_POST__ */


void
_x1f4_e4_fast_hack(struct e4_hack_type *hack_data, unsigned bits,
		   int (**load) (x1f4_e4_LOAD_ARGS_0))
{
#if __RECORD_POST__
    unsigned miss;
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
    if (scan_hack(hack_data, 0, &miss)) {
#endif				/* __RECORD_POST__ */
	*load = _x1f4_e4_load_THIS;
#if __RECORD_POST__
    } else {
	if (miss) {
	    _x1f4_e4_bxxx_hack(hack_data, bits, load);
	} else {
	    if (bits & DIRECT_DATA_ACCESS) {
		_x1f4_e4_bcxx_hack(hack_data, bits, load);
	    } else {
		_x1f4_e4_bxxx_hack(hack_data, bits, load);
	    }
	}
    }
#endif				/* __RECORD_POST__ */
}
