/*
 * e4.h
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_H__
#define __LIBx1f4_e4_H__

#include <stdio.h>

/*
 * C type definitions
 */
#define X1f4_E4_C_BILL			unsigned long
#define X1f4_E4_C_MODE			long
#define X1f4_E4_C_REAL			double
#define X1f4_E4_C_TEXT			char *
#define X1f4_E4_C_USER			void *

/*
 * completion definitions
 */
#define X1f4_E4_BACK_COMPLETION		0
#define X1f4_E4_BYTE_COMPLETION		1

/*
 * error definitions
 */
#define X1f4_E4_ALLOC_ERROR		1
#define X1f4_E4_PARSE_ERROR		2

/*
 * function flag definitions
 */
#define X1f4_E4_LINK_PASS		(1L << 0x02)
#define X1f4_E4_POST_TYPE		(1L << 0x03)
#define X1f4_E4_SIDE_LIST		(1L << 0x04)
#define X1f4_E4_SLIP_LIST		(1L << 0x05)
#define X1f4_E4_TEXT_LINK		(1L << 0x06)
#define X1f4_E4_WALK_LINK		(1L << 0x07)

/*
 * function argument flag definition
 */
#define X1f4_E4_POST_XSET		(1 << 0x00)

/*
 * generation flag definitions
 */
#define X1f4_E4_BCOLLECT		(1L << 0x00)
#define X1f4_E4_COMPOSER		(1L << 0x01)
#define X1f4_E4_DDACCESS		(1L << 0x02)
#define X1f4_E4_ESTORAGE		(1L << 0x03)
#define X1f4_E4_IMPLICIT		(1L << 0x04)
#define X1f4_E4_MAXSTACK		(1L << 0x05)
#define X1f4_E4_RESOURCE		(1L << 0x06)
#define X1f4_E4_SCOMMENT		(1L << 0x07)
#define X1f4_E4_SEQUENCE		(1L << 0x08)
#define X1f4_E4_SLIPTEST		(1L << 0x09)
#define X1f4_E4_TRANSFER		(1L << 0x0a)

/*
 * infix bynary operator flag definitions
 */
#define X1f4_E4_BACK_LINK		(1L << 0x03)
#define X1f4_E4_CALL_XSET		(1L << 0x04 | X1f4_E4_LEFT_XSET)
#define X1f4_E4_LEFT_LAST		(1L << 0x05)
#define X1f4_E4_LEFT_XSET		(1L << 0x06)

/*
 * operator 2nd entension flag definitions
 */
#define X1f4_E4_CALL_LINK		(1L << 0x00)
#define X1f4_E4_RANK_LIST		(1L << 0x01)
#define X1f4_E4_RANK_NONE		(1L << 0x02)

/*
 * operator and function flag definitions
 */
#define X1f4_E4_KEEP_CALL		(1L << 0x00)

/*
 * operator flag definitions
 */
#define X1f4_E4_E1ST_LINK		(1L << 0x01)
#define X1f4_E4_E2ND_LINK		(1L << 0x02)

/*
 * parse error definitions
 */
#define X1f4_E4_MISSTURN		-143

/*
 * type definitions
 */
#define X1f4_E4_BILL			0
#define X1f4_E4_MODE			1
#define X1f4_E4_REAL			2
#define X1f4_E4_TEXT			3

/*
 * type definitions (continued)
 */
#define X1f4_E4_SLIP			4095

/*
 * type definitions (continued)
 */
#define X1f4_E4_VOID			4096

/*
 * type definitions (continued)
 */
#define X1f4_E4_LAST			8192

/*
 * type definitions (concluded)
 */
#define X1f4_E4_CALL			131072

/*
 * variable flag definitions
 */
#define X1f4_E4_READ_ONLY		(1L << 0x00)
#define X1f4_E4_REFERENCE		(1L << 0x01)

typedef struct x1f4_2ndscope_type {
    unsigned bits;
    const void *line, *rank;
} x1f4_2ndscope_type;

typedef struct x1f4_eelookup_type {
    struct {
	int (*fix) (const void *, int, const char **, unsigned *);
	const void *context;
    } type_l;
    struct {
	const void *e4fine;
    } type_q;
} x1f4_eelookup_type;

typedef struct x1f4_fxrecord_type {
    int type;
    const char *name;
    unsigned length;
} x1f4_fxrecord_type;

typedef struct x1f4_eerecord_type {
    union {
	struct {
	    const char *name;
	    int f1st, f2nd;
	    unsigned size;
	} binary_r;
	struct {
	    const char *byte;
	} bytemiss;
	struct {
	    const char *name;
	    unsigned size;
	} c_lvalue;
	struct {
	    struct x1f4_fxrecord_type fxrecord;
	    unsigned rank;
	} c_svalue;
	struct {
	    struct x1f4_fxrecord_type fxrecord;
	    unsigned rank;
	} i_svalue;
	struct {
	    const char *name;
	    unsigned size;
	} v_lookup;
	struct {
	    const char *name;
	    unsigned size;
	} v_syntax;
	struct {
	    const char *name;
	    unsigned size;
	} f_lookup;
	struct {
	    const char *name;
	    unsigned size;
	} f_syntax;
	struct {
	    int f1st, f2nd;
	} missturn;
	struct {
	    int f1st, f2nd;
	    struct x1f4_fxrecord_type fxrecord;
	    unsigned rank;
	} misstype;
	struct {
	    int join;
	} nearjoin;
	struct {
	    struct x1f4_fxrecord_type fxrecord;
	} surelose;
	struct {
	    struct x1f4_fxrecord_type fxrecord;
	} surestep;
	struct {
	    int f1st, f2nd;
	    struct x1f4_fxrecord_type fxrecord;
	    unsigned rank;
	} t_svalue;
	struct {
	    const char *name;
	    unsigned size;
	} usedvoid;
    } data;
    unsigned code;
} x1f4_eerecord_type;

#if !defined __x1f4_function_type_defined__
typedef struct x1f4_function_type {
    const char *name;
    int (*function) (void *, void *, void **), type;
    const int *args;
    unsigned count, flags, length;
} x1f4_function_type;
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_function_type_defined__
# define __x1f4_function_type_defined__
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
typedef struct x1f4_linetext_type {
    struct x1f4_function_type function;
    const void *context;
} x1f4_linetext_type;
#endif				/* !__x1f4_linetext_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
# define __x1f4_linetext_type_defined__
#endif				/* !__x1f4_linetext_type_defined__ */

#if !defined __x1f4_operator_type_defined__
typedef struct x1f4_operator_type {
    const char *name;
    int (*operator) (void *, void **), priority, type;
    const int *args;
    unsigned flags, length;
    const void *extension1, *extension2;
} x1f4_operator_type;
#endif				/* !__x1f4_operator_type_defined__ */

#if !defined __x1f4_operator_type_defined__
# define __x1f4_operator_type_defined__
#endif				/* !__x1f4_operator_type_defined__ */

typedef struct x1f4_transfer_type {
    const struct x1f4_function_type *function_data;
    void *context, **input, *output;
} x1f4_transfer_type;

typedef struct x1f4_dispatch_type {
    int (*call) (void *, int, void *, struct x1f4_dispatch_type **);
    struct x1f4_transfer_type transfer;
    void *back;
} x1f4_dispatch_type;

typedef struct x1f4_variable_type {
    const char *name;
    int type;
    unsigned flags, length;
} x1f4_variable_type;

typedef struct x1f4_stateset_type {
    int (*get) (const void *, const struct x1f4_variable_type *, void **);
    const void *context;
} x1f4_stateset_type;

typedef struct x1f4_attributes_type {
    int completion, terminator;
    struct {
	int (*fix) (const void *, const struct x1f4_function_type *, void **),
	    (*get) (const char *, unsigned, const void *,
		    const struct x1f4_function_type **);
	const void *context;
    } function_set;
    struct {
	int (*get) (const char *, unsigned, const void *,
		    const struct x1f4_variable_type **, void **);
	const void *context;
    } variable_set;
    struct {
	int (*get) (const void *, int, int,
		    const struct x1f4_operator_type **);
	const void *context;
    } implicit_set;
    struct {
	int (*get) (const void *, int, int,
		    const struct x1f4_linetext_type **);
	const void *context;
    } composer_set;
    struct {
	struct x1f4_eerecord_type *eerecord_data;
    } bcollect_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *context;
    } resource_set;
    struct {
	unsigned *s1st, *s2nd;
    } internal_set;
    struct {
	void *v1st, *v2nd;
    } datalink_set;
    struct {
	int type;
    } sequence_set;
    const struct x1f4_operator_type *const *operator1s, *const *operator2s;
} x1f4_attributes_type;

extern int x1f4_case_expression
    (void *, int *);
extern int x1f4_clip_expression
    (void *, void *, unsigned);
extern int x1f4_deck_expression
    (void *, void **);
extern int x1f4_dump_type
    (void *, int (*) (void *, const char *, unsigned), int,
     const struct x1f4_eelookup_type *);
extern int x1f4_fini_expression
    (void *);
extern int x1f4_head_expression
    (void *, void **);
extern int x1f4_iNIt_expression
    (void **, const char **, unsigned, const struct x1f4_attributes_type *);
extern int x1f4_iNit_expression
    (void **, const char *, unsigned, const struct x1f4_attributes_type *);
extern int x1f4_inIt_expression
    (void **, const char **, unsigned, const struct x1f4_attributes_type *);
extern int x1f4_lead_expression
    (void *);
extern int x1f4_line_expression
    (void *);
extern int x1f4_link_expression
    (void *, void *);
extern int x1f4_miss_expression
    (void *, void *, void *);
extern int x1f4_peek_expression
    (void *, void *, int (*) (void *, const struct x1f4_function_type *));
extern int x1f4_post_expression
    (void *, void *);
extern int x1f4_rate_expression
    (void *);
extern int x1f4_slip_expression
    (void *, void *, unsigned, int *, void *, struct x1f4_transfer_type *);
extern int x1f4_stat_expression
    (void *, int (*) (void *, const char *, unsigned),
     struct x1f4_eerecord_type *, struct x1f4_eelookup_type *);
extern int x1f4_tail_expression
    (void *, void **);
extern int x1f4_type_expression
    (void *);
extern int x1f4_vprint_expression
    (void *, int (*) (void *, const char *, unsigned), void *, unsigned);

extern void x1f4_hook_expression
    (void *, unsigned *);
extern void x1f4_ilink_operator2s
    (const struct x1f4_operator_type *const **);
extern void x1f4_list_expression
    (void *, void *, void (*) (void *, const struct x1f4_variable_type *));
extern void x1f4_llink_operator1s
    (const struct x1f4_operator_type *const **);
extern void x1f4_llink_operator2s
    (const struct x1f4_operator_type *const **);
extern void x1f4_print_expression
    (FILE *, void *, unsigned);

#endif				/* __LIBx1f4_e4_H__ */
