/*
 * e4.8.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-defs.h>
#include <e4-types.h>

int
x1f4_size_expression(struct e4_expression_type *expression_data,
		     unsigned *s1st, unsigned *s2nd)
{
    if (expression_data->flags & EXTERN_STACKS_MESS) {
	unsigned svth;

	svth = sizeof(struct e4_post_type) * expression_data->post_size;
	if (*s1st < svth) {
	    *s1st = svth;
	}
	svth = sizeof(void *) * expression_data->list_size;
	if (*s2nd < svth) {
	    *s2nd = svth;
	}
    }

    return 0;
}
