/*
 * e4.7.2.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <e4-config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stddef.h>
#include <string.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-parse.h>
#include <e4-types.h>

#define M_FREE(mcontext, mdata) \
    (mcontext)->m.free((mcontext)->m.data, (mdata))
#define M_LINK(mcontext, mdata, size) \
    (mcontext)->m.link((mcontext)->m.data, (void *) (mdata), (size))
#define M_MODE(mcontext, mdata, size) \
    (mcontext)->m.mode((mcontext)->m.data, (void *) (mdata), (size))

#if __ALLOW_FUNCTION_POINTERS__
# define case_odb2(lock_data, lock_type, call, parser_data) \
    ((lock_data)->odbx_data == _x1f4_e4_pick				      \
     ? 0 : fix_odb2((lock_data), (lock_type), (call), (parser_data)))
#else
# define case_odb2(lock_data, lock_type, call, parser_data) \
    fix_odb2((lock_data), (lock_type), (call), (parser_data))
#endif				/* __ALLOW_FUNCTION_POINTERS__ */

typedef struct half_type {
    int *none;
} half_type;

typedef struct lock_type {
    int type;
    struct lock_type *lock_data;
    const struct e4_odbx_type *odbx_data;
} lock_type;

extern const struct e4_odbx_type _x1f4_e4_pick[];

static int case_atom(struct e4_atom_type *, int *, struct parser_type *);
static int fix_odb2(struct lock_type *, int *, int *, struct parser_type *);
static int near_ever(struct e4_atom_type *, struct half_type *,
		     struct parser_type *);
static int near_last(struct e4_atom_type *, struct half_type *,
		     struct parser_type *);
static int near_none(struct e4_atom_type *, struct half_type *,
		     struct parser_type *);
static int near_this(struct e4_atom_type *, struct half_type *,
		     struct parser_type *);

static int (*const near_atom[]) (struct e4_atom_type *, struct half_type *,
				 struct parser_type *) = {
/* *INDENT-OFF* */
    near_none,
    near_none,
    near_none,
    near_none,
    near_ever,
    near_last,
    near_last,
    near_last,
    near_this
/* *INDENT-ON* */
};

static int
case_atom(struct e4_atom_type *atom_data, int *atom_type,
	  struct parser_type *parser_data)
{
    int status = 0;
    const struct e4_odbx_type *const *list;

    list = parser_data->attributes_data->odb1_data;
    if (!list) {
	status = _x1f4_e4_080704_error_g(parser_data->back_data);
    } else {
	int type;
	struct e4_odb1_type *odb1_data;

	type = *atom_type;

	odb1_data = atom_data->odb1;
	while (odb1_data) {
	    const char *e;
	    struct text_type *text_data;
	    unsigned length;

	    text_data = (struct text_type *) (odb1_data + 1);

	    e = text_data->data;
	    length = text_data->size;
	    while (length) {
		const struct e4_odbx_type *const *odbx, *odbx_data,
		    *odbx_text = NULL;
		unsigned toxic = 0;

		odbx = list;

		odbx_data = *odbx;
		while (odbx_data) {
		    unsigned shift;

		    shift = odbx_data->length;
		    if (toxic < shift) {
			if (shift < length + 1) {
			    if (*odbx_data->args == type) {
				const char *name;

				name = odbx_data->name;
				if (memcmp
				    ((void *) (e - shift), name, shift)) {
				} else {
				    odbx_text = odbx_data;
				    toxic = shift;
				}
			    }
			}
		    }

		    odbx++;
		    odbx_data = *odbx;
		}
		if (!odbx_text) {
		    status = _x1f4_e4_080704_error_i(parser_data->back_data);
		    break;
		} else {
		    e -= toxic;
		    length -= toxic;

		    if (0) {
		    } else {
			type = odbx_text->type;
		    }
		}
	    }
	    if (status) {
		break;
	    }

	    odb1_data = odb1_data->odb1_data;
	}

	if (status) {
	} else {
	    *atom_type = type;
	}
    }

    return status;
}


static int
fix_odb2(struct lock_type *lock_data, int *lock_type, int *call,
	 struct parser_type *parser_data)
{
    int major, minor, status = 0;

    major = lock_data->type;
    minor = *lock_type;

    do {
	int miss_type;
	const int *args;
	const struct e4_odbx_type *odbx_data;

	odbx_data = lock_data->odbx_data;
	args = odbx_data->args;
	if (major != args[0] || minor != args[1]) {
	    if (0) {
	    } else {
		const char *name;
		const struct e4_odbx_type *const *list;
		unsigned length;

		length = odbx_data->length;
		name = odbx_data->name;
		list = parser_data->attributes_data->odb2_data;
		odbx_data = *list;
		while (odbx_data) {
		    const char *text;

		    text = odbx_data->name;
		    if (odbx_data->length == length) {
			args = odbx_data->args;
			if (args[0] == major) {
			    if (args[1] == minor) {
				if (memcmp(odbx_data->name, name, length)) {
				} else {
				    miss_type = odbx_data->type;
				    break;
				}
			    }
			}
			if ((odbx_data->flags & (CALL_LOCK | LEFT_XSET))
			    == (CALL_LOCK | LEFT_XSET) && BASE_LOCK < major) {
			    if (major == minor) {
				if (memcmp(odbx_data->name, name, length)) {
				} else {
				    miss_type = major;
				    break;
				}
			    } else {
			    }
			}
		    }

		    list++;
		    odbx_data = *list;
		}

		if (odbx_data) {
		} else {
		    status = _x1f4_e4_080704_error_6
			(parser_data->back_data, name, length, major, minor);
		    if (1) {
			break;
		    }
		}
	    }
	} else {
	    miss_type = odbx_data->type;
	}

	*lock_type = miss_type;
    } while (0);

    return status;
}


static int
near_ever(struct e4_atom_type *atom_data, struct half_type *half_data,
	  struct parser_type *parser_data)
{
    *half_data->none = atom_data->data.ever.ever_data->type;

    return 0;
}


static int
near_last(struct e4_atom_type *atom_data, struct half_type *half_data,
	  struct parser_type *parser_data)
{
    *half_data->none = hack_base(atom_data->data.last.base)->last_data->type;

    return 0;
}


static int
near_none(struct e4_atom_type *atom_data, struct half_type *half_data,
	  struct parser_type *parser_data)
{
    return 0;
}


static int
near_this(struct e4_atom_type *atom_data, struct half_type *half_data,
	  struct parser_type *parser_data)
{
    return _x1f4_e4_type_hack
	(atom_data->data.hack.data, half_data->none, parser_data);
}


int
_x1f4_e4_type_hack(struct e4_hack_type *hack_data, int *type, void *parser)
{
    int call = 0, hack_type = 0, none, status = 0;
    struct e4_atom_type *atom_data;
    struct half_type half;
    struct lock_type *lock_data = NULL;
    struct parser_type *parser_data;
    unsigned count, i;

    parser_data = parser;

    count = hack_data->count;

    half.none = &none;

    atom_data = hack_data->atoms;
    for (i = count; i; i--) {
	none = atom_data->type;

	status = near_atom[none](atom_data, &half, parser_data);
	if (status) {
	    break;
	}

	if (1) {
	    const struct e4_odbx_type *odbx_data;

	    odbx_data = atom_data->odb2._1st;

	    if (atom_data->odb1) {
		status = case_atom(atom_data, &none, parser_data);
		if (status) {
		    break;
		}
	    }

	    if (count == 1) {
		hack_type = none;
	    } else if (i == 1) {
		do {
		    struct lock_type *free_lock;

		    status = case_odb2(lock_data, &none, &call, parser_data);
		    if (status) {
			break;
		    }

		    free_lock = lock_data;
		    lock_data = lock_data->lock_data;
		    M_FREE(parser_data, free_lock);
		} while (lock_data);
		if (status) {
		    break;
		}

		hack_type = none;
	    } else {
		if (!lock_data) {
		    status = M_LINK
			(parser_data, &lock_data, sizeof(struct lock_type));
		    if (status) {
			status = ALLOC_ERROR;
			atom_data++;
			break;
		    }

		    lock_data->lock_data = NULL;
		    lock_data->odbx_data = odbx_data;
		    lock_data->type = none;
		} else {
		    int priority;
		    const struct e4_odbx_type *odbx_text;

		    odbx_text = lock_data->odbx_data;
		    priority = odbx_data->priority;
		    if (priority < odbx_text->priority
			|| (priority == odbx_text->priority
			    && (odbx_data->flags & odbx_text->flags
				& BACK_LINK))) {
			struct lock_type *next_lock;

			status = M_LINK
			    (parser_data, &next_lock,
			     sizeof(struct lock_type));
			if (status) {
			    status = ALLOC_ERROR;
			    atom_data++;
			    break;
			}

			next_lock->lock_data = lock_data;
			lock_data = next_lock;

			lock_data->odbx_data = odbx_data;
			lock_data->type = none;
		    } else {
			struct lock_type *free_lock = NULL;

			do {
			    status = case_odb2
				(lock_data, &none, &call, parser_data);
			    if (status) {
				break;
			    }

			    if (free_lock) {
				M_FREE(parser_data, free_lock);
			    }
			    free_lock = lock_data;
			    lock_data = lock_data->lock_data;

			    if (lock_data) {
			    } else {
				break;
			    }
			    if (priority < lock_data->odbx_data->priority) {
				break;
			    }
			} while (1);
			if (status) {
			    atom_data++;
			    break;
			}

			free_lock->lock_data = lock_data;
			lock_data = free_lock;

			lock_data->odbx_data = odbx_data;
			lock_data->type = none;
		    }
		}
	    }
	}

	atom_data++;
    }

    while (lock_data) {
	struct lock_type *free_lock;

	free_lock = lock_data;
	lock_data = lock_data->lock_data;
	M_FREE(parser_data, free_lock);
    }

    if (status) {
    } else {
	*type = hack_type;
    }

    return status;
}
