/*
 * e4.6.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-defs.h>
#include <e4-types.h>

int
x1f4_test_expression(struct e4_expression_type *expression_data)
{
#define CLASS_0				((1 << BILL))
#define CLASS_1				(CLASS_0 | (1 << MODE))
#define CLASS_2				(CLASS_1 | (1 << REAL))
#define CLASS_3				(CLASS_2 | (1 << TEXT))

    int status = 1;

    if (expression_data->hack_data.count == 1) {
	struct e4_atom_type *atom_data;

	atom_data = expression_data->hack_data.atoms;
	if ((1 << atom_data->type) & CLASS_3) {
	    status = 0;
	}
    }

    return status;

#undef CLASS_3
#undef CLASS_2
#undef CLASS_1
#undef CLASS_0
}
