/*
 * e4.4.c
 * Copyright (C) 2010-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-line.h>
#include <e4-types.h>

static int load_pick(x1f4_e4_LOAD_ARGS_0, const struct e4_line_type *);
static int pick_node(void *, void **);

static const int c_____m_m[] = {
/* *INDENT-OFF* */
    MODE,
    MODE
/* *INDENT-ON* */
};
const struct e4_odbx_type _x1f4_e4_pick[] = {
/* *INDENT-OFF* */
    {	"(%>",			pick_node,	0,
	MODE,			c_____m_m,
	0,					3,
	NULL,			NULL				}
/* *INDENT-ON* */
};

static int
load_pick(x1f4_e4_LOAD_ARGS_1, const struct e4_line_type *line_data)
{
    int status = 0;

    do {
	struct e4_atom_type *atom_data;
	struct e4_hack_type *hack_data;
	const struct e4_last_type *last_data;
	unsigned count;
	void *text;

	atom_data = level;

	last_data = &line_data->last;

	text = (void *) line_data->text;

	hack_data = ((struct e4_atom_type *) level)->data.last.base;

	if (last_data->flags & (SIDE_LIST | SLIP_LIST)) {
	    struct e4_last_type *last_text;

	    last_text = (void *) hack_base(hack_data)->last_data;

	    status = last_data->last(text, last_text, &text);
	    if (status) {
		break;
	    } else {
#if 0
		last_text->flags &= ~TEXT_LINK;
		last_text->flags |= last_data->flags & TEXT_LINK;
#endif				/* 0 */
		last_data = last_text;
	    }
	}

	{
	    int (**post) (x1f4_e4_LOAD_ARGS_0);
	    struct e4_post_type *state_clip;
	    unsigned j;

	    count = last_data->count;
	    post = (int (**) (x1f4_e4_LOAD_ARGS_0)) (hack_data + count);
	    state_clip = post_data + 1;
	    for (j = count; j; j--) {
		*list++ = &state_clip->data;
		status = post[0](hack_data, state_clip, list);
		if (status) {
		    break;
		} else {
		    state_clip++;
		    hack_data++;
		    post++;
		}
	    }
	}
	if (status) {
	} else {
	    list -= count;
	    status = last_data->last(text, &post_data->data, list);
	    if (status) {
	    } else {
		flat_record(post_data);
	    }
	}
    } while (0);

    return status;
}


static int
pick_node(void *output, void **input)
{
    int status;
    struct e4_atom_type *atom_data;
    struct e4_near_type *near_data;

    atom_data = *(void **) input[1];

    near_data = pick_near(atom_data);

    status = load_pick
	(atom_data, near_data->slip.post_data, near_data->slip.list,
	 *(void **) input[0]);
    if (status) {
    } else {
	struct e4_post_type *fast_post, *slip_post;

	fast_post = output;
	slip_post = input[1];
	fast_post->data = slip_post->data;
    }

    return status;
}
