/*
 * e4.1b.c
 * Copyright (C) 2006-2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-config.h>

#include <stddef.h>

#include <e4-defs.h>
#include <e4-ever.h>
#include <e4-slip.h>
#include <e4-types.h>

static int load_aaad(x1f4_e4_LOAD_ARGS_0);
static int load_aadn(x1f4_e4_LOAD_ARGS_0);
static int load_addq(x1f4_e4_LOAD_ARGS_0);
static int load_adnn(x1f4_e4_LOAD_ARGS_0);
static int load_dddv(x1f4_e4_LOAD_ARGS_0);
static int load_ddnq(x1f4_e4_LOAD_ARGS_0);
static int load_ddqn(x1f4_e4_LOAD_ARGS_0);
static int load_dndq(x1f4_e4_LOAD_ARGS_0);
static int load_dnnn(x1f4_e4_LOAD_ARGS_0);
static int load_hack(x1f4_e4_LOAD_ARGS_0);

static int
load_aaad(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);

    return status;
}


static int
load_aadn(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	atom_data++;

	post_data++;

	status = atom_data->load(atom_data, post_data, list);
	if (status) {
	} else {
	    break_e1(atom_data, post_data, status, context);
	}
    }

    return status;
}


static int
load_addq(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	atom_data++;

	post_data++;

	status = atom_data->load(atom_data, post_data, list);
	if (status) {
	} else {
	    atom_data++;

	    post_data++;

	    status = atom_data->load(atom_data, post_data, list);
	    if (status) {
	    } else {
		break_e2(atom_data, post_data, status, context);
	    }
	}
    }

    return status;
}


static int
load_adnn(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	atom_data++;

	post_data++;

	status = atom_data->load(atom_data, post_data, list);
	if (status) {
	} else {
	    break_decls;

	    break_ea(atom_data, post_data, status, context);
	    if (status) {
	    } else {
		atom_data++;

		post_data++;

		status = atom_data->load(atom_data, post_data, list);
		if (status) {
		} else {
		    break_eb(atom_data, post_data, status, context);
		}
	    }
	}
    }

    return status;
}


static int
load_dddv(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	atom_data++;

	post_data++;

	status = atom_data->load(atom_data, post_data, list);
	if (status) {
	} else {
	    atom_data++;

	    post_data++;

	    status = atom_data->load(atom_data, post_data, list);
	    if (status) {
	    } else {
		atom_data++;

		post_data++;

		status = atom_data->load(atom_data, post_data, list);
		if (status) {
		} else {
		    break_e3(atom_data, post_data, status, context);
		}
	    }
	}
    }

    return status;
}


static int
load_ddnq(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	atom_data++;

	post_data++;

	status = atom_data->load(atom_data, post_data, list);
	if (status) {
	} else {
	    atom_data++;

	    post_data++;

	    status = atom_data->load(atom_data, post_data, list);
	    if (status) {
	    } else {
		break_decls;

		break_ec(atom_data, post_data, status, context);
		if (status) {
		} else {
		    atom_data++;

		    post_data++;

		    status = atom_data->load
			(atom_data, post_data, list);
		    if (status) {
		    } else {
			break_ed(atom_data, post_data, status, context);
		    }
		}
	    }
	}
    }

    return status;
}


static int
load_ddqn(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	atom_data++;

	post_data++;

	status = atom_data->load(atom_data, post_data, list);
	if (status) {
	} else {
	    atom_data++;

	    post_data++;

	    status = atom_data->load(atom_data, post_data, list);
	    if (status) {
	    } else {
		break_decls;

		break_ee(atom_data, post_data, status, context);
		if (status) {
		} else {
		    atom_data++;

		    post_data++;

		    status = atom_data->load(atom_data, post_data, list);
		    if (status) {
		    } else {
			break_ef(atom_data, post_data, status, context);
		    }
		}
	    }
	}
    }

    return status;
}


static int
load_dndq(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	atom_data++;

	post_data++;

	status = atom_data->load(atom_data, post_data, list);
	if (status) {
	} else {
	    break_decls;

	    break_eg(atom_data, post_data, status, context);
	    if (status) {
	    } else {
		atom_data++;

		post_data++;

		status = atom_data->load(atom_data, post_data, list);
		if (status) {
		} else {
		    atom_data++;

		    post_data++;

		    status = atom_data->load(atom_data, post_data, list);
		    if (status) {
		    } else {
			break_eh(atom_data, post_data, status, context);
		    }
		}
	    }
	}
    }

    return status;
}


static int
load_dnnn(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;

    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	atom_data++;

	post_data++;

	status = atom_data->load(atom_data, post_data, list);
	if (status) {
	} else {
	    class_decls;

	    break_ei(atom_data, post_data, status, context);
	    if (status) {
	    } else {
		atom_data++;

		post_data++;

		status = atom_data->load(atom_data, post_data, list);
		if (status) {
		} else {
		    break_ej(atom_data, post_data, status, context);
		    if (status) {
		    } else {
			atom_data++;

			post_data++;

			status = atom_data->load(atom_data, post_data, list);
			if (status) {
			} else {
			    break_ek(atom_data, post_data, status, context);
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
load_hack(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    struct e4_atom_type *atom_data;
    unsigned count;

    count = ((struct e4_hack_type *) level)->count;
    atom_data = ((struct e4_hack_type *) level)->atoms;

    status = atom_data->load(atom_data, post_data, list);
    if (status) {
    } else {
	count--;
	for (; count; count--) {
	    atom_data++;

	    post_data++;

	    status = atom_data->load(atom_data, post_data, list);
	    if (status) {
		break;
	    } else {
		break_a2(atom_data, post_data, count, status, context);
	    }
	}
    }

    return status;
}


void
_x1f4_e4_bxxx_hack(struct e4_hack_type *hack_data, unsigned bits,
		   int (**load) (x1f4_e4_LOAD_ARGS_0))
{
    unsigned count;

    count = hack_data->count;
    if (count == 1) {
	*load = load_aaad;
    } else {
	if (count == 2) {
	    *load = load_aadn;
	} else {
	    if (count == 3) {
		struct e4_atom_type *atom_data;

		atom_data = hack_data->atoms;
		if ((atom_data + 1)->odb2._2nd) {
		    *load = load_adnn;
		} else {
		    *load = load_addq;
		}
	    } else {
		if (count == 4) {
		    struct e4_atom_type *atom_data;

		    atom_data = hack_data->atoms;
		    if ((atom_data + 1)->odb2._2nd) {
			if ((atom_data + 2)->odb2._2nd) {
			    *load = load_dnnn;
			} else {
			    *load = load_dndq;
			}
		    } else {
			struct e4_odb2_type *odb2_data;

			odb2_data = (atom_data + 2)->odb2._2nd;
			if (odb2_data) {
			    if (odb2_data->odb2_data) {
				*load = load_ddqn;
			    } else {
				*load = load_ddnq;
			    }
			} else {
			    *load = load_dddv;
			}
		    }
		} else {
		    *load = load_hack;
		}
	    }
	}
    }
}
