/*
 * e4.0.c
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-line.h>
#include <e4-types.h>
#include <exerrors.h>

int
_x1f4_e4_load_BILL(x1f4_e4_LOAD_ARGS_1)
{
    C_BILL *state;

    state = (C_BILL *) &post_data->data;
    *state = *(C_BILL *) ((struct e4_atom_type *) level)->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_MODE(x1f4_e4_LOAD_ARGS_1)
{
    C_MODE *state;

    state = (C_MODE *) &post_data->data;
    *state = *(C_MODE *) ((struct e4_atom_type *) level)->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_REAL(x1f4_e4_LOAD_ARGS_1)
{
    C_REAL *state;

    state = (C_REAL *) &post_data->data;
    *state = *(C_REAL *) ((struct e4_atom_type *) level)->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_TEXT(x1f4_e4_LOAD_ARGS_1)
{
    C_TEXT *state;

    state = (C_TEXT *) &post_data->data;
    *state = *(C_TEXT *) ((struct e4_atom_type *) level)->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_USER(x1f4_e4_LOAD_ARGS_1)
{
    C_USER *state;

    state = (C_USER *) &post_data->data;
    *state = *(C_USER *) ((struct e4_atom_type *) level)->data.ever.state;
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_bill(x1f4_e4_LOAD_ARGS_1)
{
    C_BILL *state;

    state = (C_BILL *) &post_data->data;
    *state = *(C_BILL *) &((struct e4_atom_type *) level)->data.lead.data;
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_clip(x1f4_e4_LOAD_ARGS_1)
{
    int status;
    const struct e4_sset_type *sset_data;

    sset_data = ((struct e4_atom_type *) level)->data.ever.state;

    miss_record(post_data);

    status = sset_data->get
	(sset_data->context,
	 ((struct e4_atom_type *) level)->data.ever.ever_data,
	 &line_record(post_data));
    if (status) {
	status = X1f4_EX_CANNOT_CONTINUE;
    }

    return status;
}


int
_x1f4_e4_load_ever(x1f4_e4_LOAD_ARGS_1)
{
    fast_record(post_data, ((struct e4_atom_type *) level)->data.ever.state);
    miss_record(post_data);

    return 0;
}


int
_x1f4_e4_load_mode(x1f4_e4_LOAD_ARGS_1)
{
    C_MODE *state;

    state = (C_MODE *) &post_data->data;
    *state = *(C_MODE *) &((struct e4_atom_type *) level)->data.lead.data;
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_real(x1f4_e4_LOAD_ARGS_1)
{
    C_REAL *state;

    state = (C_REAL *) &post_data->data;
    *state = *(C_REAL *) &((struct e4_atom_type *) level)->data.lead.data;
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_text(x1f4_e4_LOAD_ARGS_1)
{
    C_TEXT *state;

    state = (C_TEXT *) &post_data->data;
    *state = *(C_TEXT *) &((struct e4_atom_type *) level)->data.lead.data;
    flat_record(post_data);

    return 0;
}


int
_x1f4_e4_load_this(x1f4_e4_LOAD_ARGS_1)
{
    return ((struct e4_atom_type *) level)->data.hack.load
	(((struct e4_atom_type *) level)->data.hack.data, post_data, list);
}
