/*
 * e4-xls.h
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_XLS_H__
#define __LIBx1f4_e4_XLS_H__

#include <config.h>

#if !defined BITS_MODE
# if SIZEOF_LONG == 4
#  define BITS_MODE			unsigned
# else
#  define BITS_MODE			unsigned long
# endif				/* SIZEOF_LONG == 4 */
#endif				/* !BITS_MODE */

#if SIZEOF_LONG == 4
# if defined x1f4_xls_32
# else
#  undef e4_xls
#  define e4_xls(l4f1_xxls, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c, l4f1_e, l4f1_i, l4f1_n;			      \
									      \
	l4f1_i = (l4f1_mode);						      \
									      \
	l4f1_c = -(l4f1_i >> 16);					      \
	l4f1_e = (l4f1_c >> 16) & 16;					      \
	l4f1_n = 16 - l4f1_e;						      \
	l4f1_i >>= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x100;					      \
	l4f1_e = (l4f1_c >> 16) & 8;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x1000;					      \
	l4f1_e = (l4f1_c >> 16) & 4;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x4000;					      \
	l4f1_e = (l4f1_c >> 16) & 2;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i >> 14;						      \
	l4f1_e = l4f1_c & ~(l4f1_c >> 1);				      \
									      \
	(l4f1_xxls) = l4f1_n + 2 - l4f1_e;				      \
    }
# endif				/* x1f4_xls_32 */
#else
# if defined x1f4_xls_64
# else
#  undef e4_xls
#  define e4_xls(l4f1_xxls, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c, l4f1_e, l4f1_i, l4f1_n;			      \
									      \
	l4f1_i = (l4f1_mode);						      \
									      \
	l4f1_c = -(l4f1_i >> 32);					      \
	l4f1_e = (l4f1_c >> 32) & 32;					      \
	l4f1_n = 32 - l4f1_e;						      \
	l4f1_i >>= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x10000;					      \
	l4f1_e = (l4f1_c >> 32) & 16;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x1000000;					      \
	l4f1_e = (l4f1_c >> 32) & 8;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x10000000;					      \
	l4f1_e = (l4f1_c >> 32) & 4;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x40000000;					      \
	l4f1_e = (l4f1_c >> 32) & 2;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i >> 30;						      \
	l4f1_e = l4f1_c & ~(l4f1_c >> 1);				      \
									      \
	(l4f1_xxls) = l4f1_n + 2 - l4f1_e;				      \
    }
# endif				/* x1f4_xls_64 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_xls_32
# else
#  undef e4_xls_n_club
#  define e4_xls_n_club(___S) \
    unsigned char __e4_xls_n_club##___S[] = {				      \
	32, 20, 19, 96, 96, 18, 96,  7,					      \
	10, 17, 96, 96, 14, 96,  6, 96,					      \
	96,  9, 96, 16, 96, 96,  1, 26,					      \
	96, 13, 96, 96, 24,  5, 96, 96,					      \
	96, 21, 96,  8, 11, 96, 15, 96,					      \
	96, 96, 96,  2, 27,  0, 25, 96,					      \
	22, 96, 12, 96, 96,  3, 28, 96,					      \
	23, 96,  4, 29, 96, 96, 30, 31					      \
    }
# endif				/* x1f4_xls_32 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_xls_32
# else
#  undef e4_xls_n_near
#  define e4_xls_n_near(l4f1_xxls, l4f1_mode, ___S) \
    {									      \
	BITS_MODE l4f1_n;						      \
									      \
	l4f1_n = (l4f1_mode);						      \
									      \
	l4f1_n = l4f1_n | (l4f1_n >> 001);				      \
	l4f1_n = l4f1_n | (l4f1_n >> 002);				      \
	l4f1_n = l4f1_n | (l4f1_n >> 004);				      \
	l4f1_n = l4f1_n | (l4f1_n >> 010);				      \
	l4f1_n = l4f1_n & ~(l4f1_n >> 16);				      \
									      \
	l4f1_n = l4f1_n * 0xFD7049FF;					      \
									      \
	(l4f1_xxls) = __e4_xls_n_club##___S[l4f1_n >> 26];		      \
    }
# endif				/* x1f4_xls_32 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_xls_32
# else
#  undef e4_xls_n_club
#  define e4_xls_n_club(___S) \
    unsigned char __e4_xls_n_club##___S[] = {				      \
	32, 31, 88, 16, 88, 30,  3, 88,					      \
	15, 88, 88, 88, 29, 10,  2, 88,					      \
	88, 88, 12, 14, 21, 88, 19, 88,					      \
	88, 28, 88, 25, 88,  9,  1, 88,					      \
	17, 88,  4, 88, 88, 88, 11, 88,					      \
	13, 22, 20, 88, 26, 88, 88, 18,					      \
	 5, 88, 88, 23, 88, 27, 88,  6,					      \
	88, 24,  7, 88,  8, 88,  0, 88					      \
    }
# endif				/* x1f4_xls_32 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_xls_32
# else
#  undef e4_xls_n_near
#  define e4_xls_n_near(l4f1_xxls, l4f1_mode, ___S) \
    {									      \
	BITS_MODE l4f1_n;						      \
									      \
	l4f1_n = (l4f1_mode);						      \
									      \
	l4f1_n = l4f1_n | (l4f1_n >> 001);				      \
	l4f1_n = l4f1_n | (l4f1_n >> 002);				      \
	l4f1_n = l4f1_n | (l4f1_n >> 004);				      \
	l4f1_n = l4f1_n | (l4f1_n >> 010);				      \
	l4f1_n = l4f1_n | (l4f1_n >> 020);				      \
									      \
	l4f1_n = l4f1_n * 0x06EB14F9;					      \
									      \
	(l4f1_xxls) = __e4_xls_n_club##___S[l4f1_n >> 26];		      \
    }
# endif				/* x1f4_xls_32 */
#endif				/* SIZEOF_LONG == 4 */

#endif				/* __LIBx1f4_e4_XLS_H__ */
