/*
 * e4-types.h
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_TYPES_H__
#define __LIBx1f4_e4_TYPES_H__

#include <e4-config.h>

#include <e4-byte.h>
#include <e4-defs.h>

#define x1f4_e4_LINE_ARGS_0 \
    void *, void **
#define x1f4_e4_LINE_ARGS_1 \
    void *output, void **input
#define x1f4_e4_LINE_ARGS_2 \
    output, input

#define x1f4_e4_LINK_ARGS_0 \
    void *, void *, void **
#define x1f4_e4_LINK_ARGS_1 \
    void *context, void *output, void **input
#define x1f4_e4_LINK_ARGS_2 \
    context, output, input

#define x1f4_e4_LOAD_ARGS_0 \
    void *, struct e4_post_type *, void **
#define x1f4_e4_LOAD_ARGS_1 \
    void *level, struct e4_post_type *post_data, void **list
#define x1f4_e4_LOAD_ARGS_2 \
    level, post_data, list

#define x1f4_e4_POST_ARGS_0 \
    void *, struct e4_post_type *
#define x1f4_e4_POST_ARGS_1 \
    void *post, struct e4_post_type *post_data
#define x1f4_e4_POST_ARGS_2 \
    post, post_data

#define hack_base(hack_slip) \
    ((struct e4_base_type *) ((void *) (hack_slip)) - 1)

#define hack_fine(hack_slip) \
    ((struct e4_fine_type *) hack_base(hack_slip) - 1)

#define hack_near(hack_slip) \
    ((struct e4_near_type *) hack_base(hack_slip) - 1)

#define last_base(atom_slip) \
    ((struct e4_base_type *)						      \
     ((struct e4_atom_type *) (atom_slip))->data.last.base - 1)

#define lock_fine(atom_slip) \
    ((struct e4_fine_type *) last_base(atom_slip) - 1)

#define pick_near(atom_slip) \
    ((struct e4_near_type *) last_base(atom_slip) - 1)

typedef C_TEXT e4_text_type;

typedef struct e4_2nde_type {
    unsigned bits;
    const void *line, *rank;
} e4_2nde_type;

typedef struct e4_lead_type {
    union {
	C_BILL bill;
	C_MODE mode;
	C_REAL real;
	C_TEXT text;
	C_USER user;
    } data;
} e4_lead_type;

typedef struct e4_post_type {
    union {
	C_BILL bill;
	C_MODE mode;
	C_REAL real;
	C_TEXT text;
	C_USER user;
#if __RECORD_POST__
#else
	void *address;
#endif				/* __RECORD_POST__ */
    } data;
    union {
#if __RECORD_POST__
#else
	int reference;
#endif				/* __RECORD_POST__ */
#if __RECORD_POST__
	void *address;
#endif				/* __RECORD_POST__ */
    } flat;
} e4_post_type;

struct e4_last_type;

/*
 * the structure can (should?) be made be more compact.
 * _type_ should not be needed for fast operation and can be derived from
 * _load_.
 * _data.ever.ever_data_ should not be needed for fast operation and can be
 * stored in an associative array extension to the expression type.
 * _data.hack_ can be collapsed into one pointer field.
 *
 */
typedef struct e4_atom_type {
    int (*load) (x1f4_e4_LOAD_ARGS_0), type;
    union {
	void *_2nd;
	const void *_1st;
    } odb2;
    union {
	struct {
	    const struct e4_ever_type *ever_data;
	    void *state;
	} ever;
	struct {
	    int (*load) (x1f4_e4_LOAD_ARGS_0);
	    void *data;
	} hack;
	struct {
	    void *base;
	} last;
	struct e4_lead_type lead;
    } data;
    void *odb1;
} e4_atom_type;

typedef struct e4_last_type {
    const char *name;
    int (*last) (x1f4_e4_LINK_ARGS_0), type;
    const int *args;
    unsigned count, flags, length;
} e4_last_type;

typedef struct e4_line_type {
    struct e4_last_type last;
    const void *text;
} e4_line_type;

typedef struct e4_odbx_type {
    const char *name;
    int (*odbx) (x1f4_e4_LINE_ARGS_0), priority, type;
    const int *args;
    unsigned flags, length;
    const void *extension1, *extension2;
} e4_odbx_type;

typedef struct e4_attributes_type {
    int completion, terminator;
    struct {
	int (*fix) (const void *, const struct e4_last_type *, void **),
	    (*get) (const char *, unsigned, const void *,
		    const struct e4_last_type **);
	const void *context;
    } last_0;
    struct {
	int (*get) (const char *, unsigned, const void *,
		    const struct e4_ever_type **, void **);
	const void *context;
    } ever_0;
    struct {
	int (*get) (const void *, int, int, const struct e4_odbx_type **);
	const void *context;
    } trap_0;
    struct {
	int (*get) (const void *, int, int, const struct e4_line_type **);
	const void *context;
    } turn_0;
    struct {
	void *back;
    } link_e;
    struct {
	void *fine;
    } link_i;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
    struct {
	unsigned *s1st, *s2nd;
    } link_s;
    struct {
	void *v1st, *v2nd;
    } link_v;
    struct {
	int type;
    } link_z;
    const struct e4_odbx_type *const *odb1_data, *const *odb2_data;
} e4_attributes_type;

typedef struct e4_mind_type {
    int type;
    const char *name;
    unsigned length;
} e4_mind_type;

typedef struct e4_back_type {
    union {
	struct {
	    const char *name;
	    int f1st, f2nd;
	    unsigned size;
	} binary_r;
	struct {
	    const char *byte;
	} bytemiss;
	struct {
	    const char *name;
	    unsigned size;
	} c_lvalue;
	struct {
	    struct e4_mind_type mind;
	    unsigned rank;
	} c_svalue;
	struct {
	    const char *name;
	    unsigned size;
	} e_lookup;
	struct {
	    const char *name;
	    unsigned size;
	} e_syntax;
	struct {
	    struct e4_mind_type mind;
	    unsigned rank;
	} i_svalue;
	struct {
	    const char *name;
	    unsigned size;
	} l_lookup;
	struct {
	    const char *name;
	    unsigned size;
	} l_syntax;
	struct {
	    const char *name;
	    unsigned size;
	} misscall;
	struct {
	    int f1st, f2nd;
	} missturn;
	struct {
	    int f1st, f2nd;
	    struct e4_mind_type mind;
	    unsigned rank;
	} misstype;
	struct {
	    int join;
	} nearjoin;
	struct {
	    struct e4_mind_type mind;
	} nearvoid;
	struct {
	    struct e4_mind_type mind;
	} surelose;
	struct {
	    struct e4_mind_type mind;
	} surestep;
	struct {
	    int f1st, f2nd;
	    struct e4_mind_type mind;
	    unsigned rank;
	} t_svalue;
	struct {
	    const char *name;
	    unsigned size;
	} usedvoid;
    } data;
    unsigned code;
} e4_back_type;

typedef struct e4_base_type {
    const struct e4_last_type *last_data;
    void *text;
} e4_base_type;

typedef struct e4_call_type {
    const struct e4_last_type *last_data;
    void *context, **input, *output;
} e4_call_type;

typedef struct e4_ever_type {
    const char *name;
    int type;
    unsigned flags, length;
} e4_ever_type;

typedef struct e4_fine_type {
    const struct e4_ever_type *ever_data;
    const struct e4_line_type **line;
} e4_fine_type;

typedef struct e4_flat_type {
    struct e4_flat_type *flat_data;
} e4_flat_type;

typedef struct e4_hack_type {
    unsigned count, flags;
    void *atoms;
} e4_hack_type;

typedef struct e4_deck_type {
    int fine;
    const int *miss;
    struct e4_atom_type *atom_data;
    struct e4_deck_type *deck_data;
    struct e4_hack_type *hack_data;
    struct e4_post_type *deck_post, *post_data;
    unsigned class, count;
    void **list;
} e4_deck_type;

typedef struct e4_long_type {
    struct {
	int (*fix) (const void *, int, const char **, unsigned *);
	const void *context;
    } type_l;
    struct {
	const void *e4fine;
    } type_q;
} e4_long_type;

typedef struct e4_odb1_type {
    const struct e4_odbx_type *odbx_data;
    struct e4_odb1_type *odb1_data;
} e4_odb1_type;

typedef struct e4_odb2_type {
    const struct e4_odbx_type *odbx_data;
    struct e4_odb2_type *odb2_data;
} e4_odb2_type;

typedef struct e4_odbl_type {
    unsigned flags;
    const struct e4_odbx_type *odbx_data, *odbx_miss;
    const void *oddl, *oddp;
} e4_odbl_type;

typedef struct e4_ndbl_type {
    const struct e4_odbx_type *odbx_data;
} e4_ndbl_type;

typedef struct e4_ndbv_type {
    const struct e4_ndbl_type *ndbl_data;
    const struct e4_odbx_type *odbx_data;
} e4_ndbv_type;

typedef struct e4_ndbA_type {
    const struct e4_ndbv_type *ndbv_data;
} e4_ndbA_type;

typedef struct e4_ndbC_type {
    const struct e4_ndbv_type *ndbv_data;
} e4_ndbC_type;

typedef struct e4_ndba_type {
    const struct e4_ndbv_type *ndbv_data;
} e4_ndba_type;

typedef struct e4_ndbc_type {
    const struct e4_ndbv_type *ndbv_data;
} e4_ndbc_type;

typedef struct e4_near_type {
    struct {
	struct e4_post_type *post_data;
	void **list;
    } slip;
} e4_near_type;

typedef struct e4_odbv_type {
    int shift;
    const struct e4_odbx_type *odbx_data;
} e4_odbv_type;

typedef struct e4_odbt_type {
    const struct e4_odbl_type *odbl_data;
    const struct e4_odbv_type *odbv_data;
    const struct e4_odbx_type *odbx_data;
} e4_odbt_type;

typedef struct e4_odbz_type {
    const struct e4_odbt_type *odbt_data;
} e4_odbz_type;

typedef struct e4_odbA_type {
    const struct e4_odbl_type *odbl_data, *odbl_miss;
    const struct e4_odbz_type *odbz_data;
    const void *oddp;
    unsigned flags;
} e4_odbA_type;

typedef struct e4_odbC_type {
    const struct e4_odbl_type *odbl_data, *odbl_miss;
    const struct e4_odbz_type *odbz_data;
    const void *oddp;
    unsigned flags;
} e4_odbC_type;

typedef struct e4_odbS_type {
    const struct e4_odbl_type *odbl_data, *odbl_miss;
} e4_odbS_type;

typedef struct e4_odba_type {
    const struct e4_odbl_type *odbl_data, *odbl_miss;
    const struct e4_odbz_type *odbz_data;
    const void *oddp;
    unsigned flags;
} e4_odba_type;

typedef struct e4_odbc_type {
    const struct e4_odbl_type *odbl_data, *odbl_miss;
    const struct e4_odbz_type *odbz_data;
    const void *oddp;
    unsigned flags;
} e4_odbc_type;

typedef struct e4_odbs_type {
    const struct e4_odbl_type *odbl_data, *odbl_miss;
} e4_odbs_type;

typedef struct e4_cdbl_type {
    const struct e4_odbx_type *odbx_data, *odbx_miss;
} e4_cdbl_type;

typedef struct e4_cdbp_type {
    const struct e4_cdbl_type *cdbp_data, *cdbs_data;
} e4_cdbp_type;

typedef struct e4_cdbx_type {
    int type;
    const void *transform;
} e4_cdbx_type;

typedef struct e4_edbl_type {
    const struct e4_odbx_type *odbx_data, *odbx_miss;
} e4_edbl_type;

typedef struct e4_edbp_type {
    const struct e4_edbl_type *edbl_data;
} e4_edbp_type;

typedef struct e4_edbx_type {
    int type;
    const void *transform;
} e4_edbx_type;

typedef struct e4_rdbl_type {
    int type;
    unsigned flags;
    const void *data, *miss;
} e4_rdbl_type;

typedef struct e4_rdbo_type {
    int type;
    unsigned flags;
    const void *data, *miss;
} e4_rdbo_type;

typedef struct e4_sdbl_type {
    int type;
    unsigned flags;
    const void *data, *edbx;
} e4_sdbl_type;

typedef struct e4_sdbo_type {
    int type;
    unsigned flags;
    const void *data;
} e4_sdbo_type;

typedef struct e4_tdbe_type {
    const struct e4_odbx_type *odbx_data, *odbx_miss;
} e4_tdbe_type;

typedef struct e4_tdbl_type {
    const struct e4_tdbe_type *tdbe_data, *tdbe_miss;
} e4_tdbl_type;

typedef struct e4_tdbo_type {
    const struct e4_tdbe_type *tdbe_data, *tdbe_miss;
} e4_tdbo_type;

typedef struct e4_odbf_type {
    const struct e4_ndbA_type *ndbA_data;
    const struct e4_ndbC_type *ndbC_data;
    const struct e4_ndba_type *ndba_data;
    const struct e4_ndbc_type *ndbc_data;
    const struct e4_odbA_type *odbA_data;
    const struct e4_odbC_type *odbC_data;
    const struct e4_odbS_type *odbS_data;
    const struct e4_odba_type *odba_data;
    const struct e4_odbc_type *odbc_data;
    const struct e4_odbs_type *odbs_data;
    const struct e4_rdbl_type *rdbl_data;
    const struct e4_rdbo_type *rdbo_data;
    const struct e4_sdbl_type *sdbl_data;
    const struct e4_sdbo_type *sdbo_data;
    const struct e4_tdbl_type *tdbl_data;
    const struct e4_tdbo_type *tdbo_data;
    unsigned bits1;
} e4_odbf_type;

typedef struct e4_sset_type {
    int (*get) (const void *, const struct e4_ever_type *, void **);
    const void *context;
} e4_sset_type;

typedef struct e4_slip_type {
    int fast;
    struct e4_atom_type *atom_data;
    struct e4_deck_type *deck_data;
    struct e4_post_type *post_data;
    unsigned count;
    void **list;
} e4_slip_type;

typedef struct e4_expression_type {
    int flags, (*load) (x1f4_e4_LOAD_ARGS_0), state, type;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } m;
    struct e4_flat_type *flat_data;
    struct e4_hack_type hack_data;
    struct e4_post_type *post_data;
#if __COPY_E4_POST__
    unsigned fast;
#endif				/* __COPY_E4_POST__ */
    unsigned list_size, post_size;
    void **list;
#if __LINE_E4_POST__
    void (*post) (x1f4_e4_POST_ARGS_0);
#endif				/* __LINE_E4_POST__ */
} e4_expression_type;

#endif				/* __LIBx1f4_e4_TYPES_H__ */
