/*
 * e4-tcstring.c
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

extern const char _x1f4_e4_tc_reflex[];

void
x1f4_copy_tcstring(char **class, const char **error)
{
    char *string;
    const char *tcstring;

    tcstring = *error;

    string = *class;

    while (1) {
	int c;

	c = *(const unsigned char *) tcstring;
	if (c == '"') {
	    break;
	} else if (c != '\\') {
	    *string++ = c;
	} else {
	    tcstring++;
	    c = *(const unsigned char *) tcstring;
	    if (c < '0' || '7' < c) {
		*string++ = _x1f4_e4_tc_reflex[c];
	    } else {
		unsigned byte;

		byte = c - '0';
		c = tcstring[1];
		{
		    if (c < '0' || '7' < c) {
		    } else {
			byte <<= 3;
			byte |= c - '0';
			tcstring++;
			c = tcstring[1];
			{
			    if (c < '0' || '7' < c) {
			    } else {
				byte <<= 3;
				byte |= c - '0';
				tcstring++;
			    }
			}
		    }
		}

		*string++ = byte;
	    }
	}

	tcstring++;
    }

    *class = string;

    tcstring++;
    *error = tcstring;

    *string = 0;
}


int
x1f4_size_tcstring(const char *string, const char **error, unsigned *size)
{
    const char *tcstring;
    int escaped = 0, status = 1;
    unsigned length = 0;

    tcstring = string;

    while (1) {
	int c;

	c = *tcstring;
	if (!c) {
	    break;
	}
	if (!escaped) {
	    if (c == '"') {
		status = 0;
		break;
	    } else if (c == '\\') {
		escaped = 1;
	    } else {
		length++;
	    }
	} else {
	    escaped = 0;
	    length++;
	    if (c < '0' || '7' < c) {
	    } else {
		c = tcstring[1];
		if (!c) {
		    break;
		} else {
		    if (c < '0' || '7' < c) {
		    } else {
			tcstring++;
			c = tcstring[1];
			if (!c) {
			    break;
			} else {
			    if (c < '0' || '7' < c) {
			    } else {
				tcstring++;
			    }
			}
		    }
		}
	    }
	}

	tcstring++;
    }

    if (!status) {
	if (error) {
	    *error = tcstring;
	}
	if (size) {
	    *size += length;
	}

	status = 0;
    }

    return status;
}
