/*
 * e4-slip.h
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_SLIP_H__
#define __LIBx1f4_e4_SLIP_H__

#include <e4-config.h>

#include <e4-types.h>

#if __RECORD_POST__
#else
# define class_e1(target, post_data) \
    {									      \
	if ((post_data)->flat.reference) {				      \
	    (target) = (post_data)->data.address;			      \
	} else {							      \
	    (target) = &(post_data)->data;				      \
	}								      \
    }
#endif				/* __RECORD_POST__ */

#if __RECORD_POST__
#else
# define class_v1(target, post_data) \
    {									      \
	{								      \
	    (target) = &(post_data)->data;				      \
	}								      \
    }
#endif				/* __RECORD_POST__ */

#define __call_break__(i) \
    (i) = 1;								      \
    if (1) {								      \
	break;								      \
    }

#define __slip_break__(i) \
    if (1) {								      \
	break;								      \
    }

#if __RECORD_POST__
# define break_a1(atom_data, post_data, status, context) \
    {									      \
	struct e4_odb1_type *odb1_data;					      \
									      \
	odb1_data = (atom_data)->odb1;					      \
	if (odb1_data) {						      \
	    {								      \
		const struct e4_odbx_type *odbx_data;			      \
		struct e4_post_type swap_state;				      \
									      \
		odbx_data = odb1_data->odbx_data;			      \
		(status) = odbx_data->odbx				      \
		    (&swap_state.data, &(post_data)->flat.address);	      \
		if ((status)) {						      \
		    break;						      \
		} else {						      \
		    (post_data)->data = swap_state.data;		      \
		    (post_data)->flat.address = &(post_data)->data;	      \
		}							      \
									      \
		odb1_data = odb1_data->odb1_data;			      \
	    }								      \
	    while (odb1_data) {						      \
		const struct e4_odbx_type *odbx_data;			      \
		struct e4_post_type swap_state;				      \
									      \
		odbx_data = odb1_data->odbx_data;			      \
		(status) = odbx_data->odbx				      \
		    (&swap_state.data, &(post_data)->flat.address);	      \
		if ((status)) {						      \
		    break;						      \
		} else {						      \
		    (post_data)->data = swap_state.data;		      \
		}							      \
									      \
		odb1_data = odb1_data->odb1_data;			      \
	    }								      \
	    if ((status)) {						      \
		break;							      \
	    }								      \
	}								      \
    }
#else
# define break_a1(atom_data, post_data, status, context) \
    {									      \
	struct e4_odb1_type *odb1_data;					      \
									      \
	odb1_data = (atom_data)->odb1;					      \
	if (odb1_data) {						      \
	    {								      \
		const struct e4_odbx_type *odbx_data;			      \
		struct e4_post_type swap_state;				      \
		void *input[1];						      \
									      \
		class_e1(input[0], post_data);				      \
		odbx_data = odb1_data->odbx_data;			      \
		(status) = odbx_data->odbx(&swap_state.data, input);	      \
		if ((status)) {						      \
		    break;						      \
		} else {						      \
		    (post_data)->data = swap_state.data;		      \
		}							      \
									      \
		odb1_data = odb1_data->odb1_data;			      \
	    }								      \
	    while (odb1_data) {						      \
		const struct e4_odbx_type *odbx_data;			      \
		struct e4_post_type swap_state;				      \
		void *input[1];						      \
									      \
		class_v1(input[0], post_data);				      \
		odbx_data = odb1_data->odbx_data;			      \
		(status) = odbx_data->odbx(&swap_state.data, input);	      \
		if ((status)) {						      \
		    break;						      \
		} else {						      \
		    (post_data)->data = swap_state.data;		      \
		}							      \
									      \
		odb1_data = odb1_data->odb1_data;			      \
	    }								      \
	    if ((status)) {						      \
		break;							      \
	    } else {							      \
		{							      \
		    (post_data)->flat.reference = 0;			      \
		}							      \
	    }								      \
	}								      \
    }
#endif				/* __RECORD_POST__ */

#define break_a2_near(odbx_data, context, output, input, status, i, \
		      __this_break__)					      \
    {									      \
	(status) = (odbx_data)->odbx((output), (input));		      \
	if ((status)) {							      \
	    __this_break__(i);						      \
	}								      \
    }

#define break_a2_call(odbx_data, context, output, input, status, i, \
		      __this_break__)					      \
    break_a2_near((odbx_data), (context), (output), (input), (status), (i),   \
		  __this_break__);

#if __RECORD_POST__
# define break_a2(atom_data, post_data, i, status, context) \
    {									      \
	struct e4_odb2_type *odb2_data;					      \
									      \
	odb2_data = (atom_data)->odb2._2nd;				      \
	if (odb2_data) {						      \
	    {								      \
		const struct e4_odbx_type *odbx_data;			      \
		struct e4_post_type swap_state;				      \
		void *input[2];						      \
									      \
		input[1] = (post_data)->flat.address;			      \
		(post_data)--;						      \
		input[0] = (post_data)->flat.address;			      \
		odbx_data = odb2_data->odbx_data;			      \
		break_a2_call						      \
		    (odbx_data, (context), &swap_state.data, input, status,   \
		     i, __slip_break__);				      \
		(post_data)->data = swap_state.data;			      \
									      \
		odb2_data = odb2_data->odb2_data;			      \
	    }								      \
	    while (odb2_data) {						      \
		const struct e4_odbx_type *odbx_data;			      \
		struct e4_post_type swap_state;				      \
		void *input[2];						      \
									      \
		input[1] = &(post_data)->data;				      \
		(post_data)--;						      \
		input[0] = (post_data)->flat.address;			      \
		odbx_data = odb2_data->odbx_data;			      \
		break_a2_call						      \
		    (odbx_data, (context), &swap_state.data, input, status,   \
		     i, __call_break__);				      \
		(post_data)->data = swap_state.data;			      \
									      \
		odb2_data = odb2_data->odb2_data;			      \
	    }								      \
	    {								      \
		{							      \
		    (post_data)->flat.address = &(post_data)->data;	      \
		}							      \
	    }								      \
	}								      \
    }
#else
# define break_a2(atom_data, post_data, i, status, context) \
    {									      \
	struct e4_odb2_type *odb2_data;					      \
									      \
	odb2_data = (atom_data)->odb2._2nd;				      \
	if (odb2_data) {						      \
	    {								      \
		const struct e4_odbx_type *odbx_data;			      \
		struct e4_post_type swap_state;				      \
		void *input[2];						      \
									      \
		class_e1(input[1], post_data);				      \
		(post_data)--;						      \
		class_e1(input[0], post_data);				      \
		odbx_data = odb2_data->odbx_data;			      \
		break_a2_call						      \
		    (odbx_data, (context), &swap_state.data, input, status,   \
		     i, __slip_break__);				      \
		(post_data)->data = swap_state.data;			      \
									      \
		odb2_data = odb2_data->odb2_data;			      \
	    }								      \
	    while (odb2_data) {						      \
		const struct e4_odbx_type *odbx_data;			      \
		struct e4_post_type swap_state;				      \
		void *input[2];						      \
									      \
		class_v1(input[1], post_data);				      \
		(post_data)--;						      \
		class_e1(input[0], post_data);				      \
		odbx_data = odb2_data->odbx_data;			      \
		break_a2_call						      \
		    (odbx_data, (context), &swap_state.data, input, status,   \
		     i, __call_break__);				      \
		(post_data)->data = swap_state.data;			      \
									      \
		odb2_data = odb2_data->odb2_data;			      \
	    }								      \
	    {								      \
		{							      \
		    (post_data)->flat.reference = 0;			      \
		}							      \
	    }								      \
	}								      \
    }
#endif				/* __RECORD_POST__ */

#endif				/* __LIBx1f4_e4_SLIP_H__ */
