/*
 * e4-o.3.c
 * Copyright (C) 2007-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>

#include <e4-types.h>

extern const char *_x1f4_e4_type_names[];
extern const unsigned _x1f4_e4_type_sizes[];

static void print_type(void *, int, unsigned, const void *,
		       int (*) (const void *, int, const char **, unsigned *));

static const char space[] = "              ";

static void
print_type(void *file, int type, unsigned span, const void *context,
	   int (*fix) (const void *, int, const char **, unsigned *))
{
    if (type < USER) {
	fputs(_x1f4_e4_type_names[type], file);
	span -= _x1f4_e4_type_sizes[type];
    } else {
	if (fix) {
	    const char *name;
	    unsigned size;

	    if (fix(context, type, &name, &size)) {
		if (BASE_LOCK == type) {
		    fputs("<function>", file);
		    span -= 10;
		} else {
		    fputs("<user>", file);
		    span -= 6;
		}
	    } else {
		fwrite(name, size, 1, file);
		if (size < span) {
		    span -= size;
		} else {
		    span = 0;
		}
	    }
	} else {
	    fputs("<user>", file);
	    span -= 6;
	}
    }

    fwrite(space, span, 1, file);
}


void
x1f4_print_tboperators(FILE *file, const struct e4_odbx_type *const *list,
		       int head, const void *context,
		       int (*fix) (const void *, int, const char **,
				   unsigned *))
{
    const struct e4_odbx_type *odbx_data;

    if (head) {
	fputs("    Type    Left Operand Type    Symbol    Right Operand Type"
	      "    Precedence\n", file);
    }

    odbx_data = *list;
    while (odbx_data) {
	const int *args;
	unsigned i, j;

	fputs("    ", file);
	print_type(file, odbx_data->type, 14, context, fix);
	args = odbx_data->args;
	print_type(file, *args, 15, context, fix);
	j = 6 - odbx_data->length;
	i = j >> 1;
	j -= i;
	for (; i; i--) {
	    fputc(' ', file);
	}
	fputs(odbx_data->name, file);
	for (; j; j--) {
	    fputc(' ', file);
	}
	fputs("           ", file);
	args++;
	print_type(file, *args, 18, context, fix);
	fprintf(file, "%#4o", odbx_data->priority);
	fputc('\n', file);
	list++;
	odbx_data = *list;
    }
}
