/*
 * e4-fls.h
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_FLS_H__
#define __LIBx1f4_e4_FLS_H__

#include <config.h>

#if !defined BITS_MODE
# if SIZEOF_LONG == 4
#  define BITS_MODE			unsigned
# else
#  define BITS_MODE			unsigned long
# endif				/* SIZEOF_LONG == 4 */
#endif				/* !BITS_MODE */

#if SIZEOF_LONG == 4
# if defined x1f4_fls_32
# else
#  undef e4_fls
#  define e4_fls(l4f1_xfls, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c, l4f1_e, l4f1_i, l4f1_n;			      \
									      \
	l4f1_i = (l4f1_mode);						      \
									      \
	l4f1_c = -(l4f1_i >> 16);					      \
	l4f1_e = (l4f1_c >> 16) & 16;					      \
	l4f1_n = 16 - l4f1_e;						      \
	l4f1_i >>= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x100;					      \
	l4f1_e = (l4f1_c >> 16) & 8;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x1000;					      \
	l4f1_e = (l4f1_c >> 16) & 4;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i - 0x4000;					      \
	l4f1_e = (l4f1_c >> 16) & 2;					      \
	l4f1_n += l4f1_e;						      \
	l4f1_i <<= l4f1_e;						      \
									      \
	l4f1_c = l4f1_i >> 14;						      \
	l4f1_e = l4f1_c & ~(l4f1_c >> 1);				      \
	l4f1_c = l4f1_n + 2 - l4f1_e;					      \
									      \
	l4f1_e = l4f1_c >> 5;						      \
	l4f1_c = l4f1_c & 31;						      \
	l4f1_c = l4f1_c + 1;						      \
	l4f1_c = l4f1_c ^ l4f1_e;					      \
									      \
	(l4f1_xfls) = l4f1_c;						      \
    }
# endif				/* x1f4_fls_32 */
#endif				/* SIZEOF_LONG == 4 */

#endif				/* __LIBx1f4_e4_FLS_H__ */
