/*
 * e4-f.c.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>
#include <e4fine-e4.h>

extern const char *_x1f4_e4_type_names[];
extern const unsigned _x1f4_e4_type_sizes[];

static int type_type(void *, int (*) (void *, const char *, unsigned), int,
		     const void *,
		     int (*) (const void *, int, const char **, unsigned *));

static int
type_type(void *back, int (*call) (void *, const char *, unsigned), int type,
	  const void *context,
	  int (*fix) (const void *, int, const char **, unsigned *))
{
    int status;

    if (type < USER) {
	if (type < VOID) {
	    if (type ^ SIDE) {
		status = call
		    (back, _x1f4_e4_type_names[type],
		     _x1f4_e4_type_sizes[type]);
	    } else {
		status = 0;
	    }
	} else {
	    if (type == VOID) {
		status = call(back, "void", 4);
	    } else {
		status = call(back, "<unknown>", 9);
	    }
	}
    } else {
	if (fix) {
	    const char *name;
	    unsigned size;

	    if (fix(context, type, &name, &size)) {
		status = call(back, "<user>", 6);
	    } else {
		status = call(back, name, size);
	    }
	} else {
	    status = call(back, "<user>", 6);
	}
    }

    return status;
}


int
x1f4_vprint_xtfunction(void *back,
		       int (*call) (void *, const char *, unsigned),
		       void *line,
		       int (*type_name) (void *, const char *, unsigned),
		       const struct e4_last_type *last_data,
		       const struct e4_long_type *long_data)
{
    int status = 1, type;

    type = last_data->type;

    while (BASE_LOCK < type) {
	const void *down;

	status = x1f4_pick_e4fine(long_data->type_q.e4fine, type, &down);
	if (status) {
	    type = ((struct e4_line_type *) down)->last.type;
	} else {
	    break;
	}
    }
    if (status) {
	int (*fix) (const void *, int, const char **, unsigned *);
	const void *context;

	context = long_data->type_l.context;
	fix = long_data->type_l.fix;

	status = type_type(back, call, type, context, fix);
	if (status) {
	} else {
	    status = call(back, " ", 1);
	    if (status) {
	    } else {
		status = x1f4_vprint_stfunction
		    (back, call, line, type_name, last_data,
		     long_data->type_q.e4fine, context, fix);
	    }
	}
    } else {
	status = 1;
    }

    return status;
}
