/*
 * e4-f.2.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-inter.h>

extern const char *_x1f4_e4_type_names[];
extern const unsigned _x1f4_e4_type_sizes[];

static int
print_type(const void *text, int type, const char **name, unsigned *size)
{
    if (type < USER) {
	*name = _x1f4_e4_type_names[type];
	*size = _x1f4_e4_type_sizes[type];
    } else {
	*name = "<user>";
	*size = 6;
    }

    return 0;
}


void
x1f4_print_hfunction(void *file, const struct e4_last_type *last_data,
		     const char *header)
{
    x1f4_print_htfunction(file, last_data, header, (void *) 0, print_type);
}
