/*
 * e4-e.g.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stdlib.h>
#include <string.h>

#if !defined HAVE_LIBx1f4i0
# include <cstring.n.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>
#if !defined HAVE_LIBx1f4i0
# include <float1.h>
# include <float.n.h>
# include <lcardinal.n.h>
# include <lintegral.n.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define P_ARGS_0 \
    unsigned *
#define P_ARGS_1 \
    unsigned *put
#define P_ARGS_2 \
    put

extern const struct e4_odbx_type _x1f4_e4_implicit[], _x1f4_e4_pick[];

static void print_Atom(P_ARGS_0, struct e4_atom_type *, unsigned, unsigned *);
static void print_atom(P_ARGS_0, struct e4_atom_type *, unsigned);
static void print_bill(P_ARGS_0, struct e4_atom_type *, unsigned);
static void print_ever(P_ARGS_0, struct e4_atom_type *, unsigned);
static void print_hack(P_ARGS_0, struct e4_hack_type *, unsigned);
static void print_last(P_ARGS_0, struct e4_atom_type *, unsigned);
static void print_lock(P_ARGS_0, struct e4_atom_type *, unsigned);
static void print_mode(P_ARGS_0, struct e4_atom_type *, unsigned);
static void print_odb1(P_ARGS_0, struct e4_odb1_type *, unsigned);
static void print_odb2(P_ARGS_0, const struct e4_odbx_type *, unsigned);
static void print_pick(P_ARGS_0, struct e4_atom_type *, unsigned);
static void print_real(P_ARGS_0, struct e4_atom_type *, unsigned);
static void print_text(P_ARGS_0, struct e4_atom_type *, unsigned);
static void print_this(P_ARGS_0, struct e4_atom_type *, unsigned);

static void (*print_type[]) (P_ARGS_0, struct e4_atom_type *, unsigned) = {
/* *INDENT-OFF* */
    print_bill,
    print_mode,
    print_real,
    print_text,
    print_ever,
    print_last,
    print_lock,
    print_pick,
    print_this
/* *INDENT-ON* */
};

static void
print_Atom(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags,
	   unsigned *state)
{
    *put += *state;
    print_atom(P_ARGS_2, atom_data, flags);
    state++;
    *put += *state;
}


static void
print_atom(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    struct e4_odb1_type *odb1_data;

    odb1_data = atom_data->odb1;
    if (odb1_data) {
	print_odb1(P_ARGS_2, odb1_data, flags);
    }

    print_type[atom_data->type](P_ARGS_2, atom_data, flags);
}


static void
print_bill(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    x1f4_nprint_lcardinal
	(P_ARGS_2, 10, *(C_BILL *) &atom_data->data.lead.data);
    if (flags & DETAIL_CONSTANTS) {
	*put += 1;
    }
}


static void
print_ever(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    *put += atom_data->data.ever.ever_data->length;
}


static void
print_hack(P_ARGS_1, struct e4_hack_type *hack_data, unsigned flags)
{
    unsigned class;

    class = hack_data->count;
    if (class == 1) {
	print_atom(P_ARGS_2, hack_data->atoms, flags);
    } else {
	struct e4_odb2_type **odb2_data;
	unsigned count, miss;

	miss = class
	    * (sizeof(struct e4_atom_type *) + (sizeof(unsigned) << 2));
	count = class - 1;
	miss += count * sizeof(struct e4_odb2_type *);
	odb2_data = (struct e4_odb2_type **) malloc(miss);
	if (odb2_data) {
	    struct e4_atom_type **atom_slip;
	    unsigned *atoms;

	    atom_slip = (void *) (odb2_data + count);
	    atoms = (unsigned *) (atom_slip + count + 1);

	    memset(odb2_data, 0, count * sizeof(struct e4_odb2_type *));
	    memset(atoms, 0, class * sizeof(unsigned) << 2);

	    {
		struct e4_atom_type *atom_data;
		unsigned i = 0;

		atom_data = hack_data->atoms;
		_x1f4_e4_rule_list
		    (atom_data, count, atoms, odb2_data, atom_slip);
		atoms += class << 1;
		print_Atom(P_ARGS_2, *atom_slip, flags, atoms);
		{
		    atom_slip++;
		    atoms += 2;
		    for (; i < count; i++) {
			const struct e4_odbx_type *odbx_data;

			odbx_data = (*odb2_data)->odbx_data;
			if (odbx_data != _x1f4_e4_pick) {
			    print_odb2(P_ARGS_2, odbx_data, flags);
			}
			print_Atom(P_ARGS_2, *atom_slip, flags, atoms);
			atom_slip++;
			atoms += 2;
			odb2_data++;
		    }

		    odb2_data -= i;
		}
	    }

	    free(odb2_data);
	}
    }
}


static void
print_last(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    struct e4_hack_type *hack_data;
    const struct e4_last_type *last_data;
    unsigned count;

    hack_data = atom_data->data.last.base;
    last_data = hack_base(hack_data)->last_data;
    *put += last_data->length;
    *put += 1;
    count = last_data->count;
    if (count) {
	print_hack(P_ARGS_2, hack_data, flags);
	count--;
	while (count) {
	    hack_data++;
	    count--;
	    *put += 2;
	    print_hack(P_ARGS_2, hack_data, flags);
	}

	*put += 1;
    } else {
	*put += 1;
    }
}


static void
print_lock(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    struct e4_fine_type *fine_data;
    struct e4_hack_type *hack_data;
    const struct e4_last_type *last_data;
    unsigned count;

    fine_data = lock_fine(atom_data);

    hack_data = atom_data->data.last.base;
    last_data = hack_base(hack_data)->last_data;
    *put += fine_data->ever_data->length;
    *put += 1;
    count = last_data->count;
    if (count) {
	print_hack(P_ARGS_2, hack_data, flags);
	count--;
	while (count) {
	    hack_data++;
	    count--;
	    *put += 2;
	    print_hack(P_ARGS_2, hack_data, flags);
	}

	*put += 1;
    } else {
	*put += 1;
    }
}


static void
print_mode(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    x1f4_nprint_lintegral
	(P_ARGS_2, 10, *(C_MODE *) &atom_data->data.lead.data);
    if (flags & DETAIL_CONSTANTS) {
	*put += 1;
    }
}


static void
print_odb1(P_ARGS_1, struct e4_odb1_type *odb1_data, unsigned flags)
{
    const char *name;
    const struct e4_odbx_type *odbx_data;

    odbx_data = odb1_data->odbx_data;
    name = odbx_data->name;
    odb1_data = odb1_data->odb1_data;
    if (odb1_data) {
	print_odb1(P_ARGS_2, odb1_data, flags);
    }
    do {
	if (flags & DETAIL_IMPLICITS) {
	} else {
	    const struct e4_odbx_type *implicit;
	    unsigned i = 6;

	    implicit = _x1f4_e4_implicit;
	    for (; i; i--) {
		if (odbx_data == implicit) {
		    break;
		} else {
		    implicit++;
		}
	    }
	    if (i) {
		break;
	    }
	}

	*put += odbx_data->length;
	if (flags & DETAIL_OPERATORS) {
	    *put += 1;
	}
    } while (0);
}


static void
print_odb2(P_ARGS_1, const struct e4_odbx_type *odbx_data, unsigned flags)
{
    *put += 1;
    if (flags & DETAIL_OPERATORS) {
	*put += 2;
    }
    *put += odbx_data->length;
    *put += 1;
}


static void
print_pick(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    struct e4_hack_type *hack_data;
    const struct e4_last_type *last_data;
    unsigned count;

    hack_data = atom_data->data.last.base;
    last_data = hack_base(hack_data)->last_data;
    *put += 1;
    count = last_data->count;
    if (count) {
	print_hack(P_ARGS_2, hack_data, flags);
	count--;
	while (count) {
	    hack_data++;
	    count--;
	    *put += 2;
	    print_hack(P_ARGS_2, hack_data, flags);
	}

	*put += 1;
    } else {
	*put += 1;
    }
}


static void
print_real(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    x1f4_nprint_float(P_ARGS_2, 6, *(C_REAL *) &atom_data->data.lead.data);
    if (flags & DETAIL_CONSTANTS) {
	*put += 1;
    }
}


static void
print_text(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    *put += 2;
    x1f4_nprint_cstring(P_ARGS_2, *(C_TEXT *) &atom_data->data.lead.data);
}


static void
print_this(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    *put += 2;
    print_hack(P_ARGS_2, atom_data->data.hack.data, flags);
}


void
x1f4_nprint_expression(unsigned *put,
		       struct e4_expression_type *expression_data,
		       unsigned flags)
{
    print_hack(put, &expression_data->hack_data, flags);
}
