/*
 * e4-e.c.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-config.h>

#include <e4-defs.h>
#include <e4-types.h>

static void break_list(int *, const struct e4_odbx_type *,
		       const struct e4_odbx_type *);
#if __ALLOW_RIGHT_FIRST__
static void swap_case(struct e4_odb2_type **, unsigned);
static void swap_lead(struct e4_odb2_type **, unsigned, unsigned);
static void swap_miss(struct e4_atom_type **, unsigned *, unsigned);
static void swap_slip(struct e4_atom_type **, unsigned *, unsigned, unsigned);
#endif				/* __ALLOW_RIGHT_FIRST__ */

static void
break_list(int *close, const struct e4_odbx_type *odbx_data,
	   const struct e4_odbx_type *odbx_miss)
{
    const struct e4_2nde_type *e2nd_data;
    unsigned flags;

    e2nd_data = odbx_data->extension2;

    if (odbx_data->flags & E2ND_LINK) {
	flags = e2nd_data->bits;
    } else {
	flags = 0;
    }

    if (odbx_miss == odbx_data) {
	if (flags & RANK_NONE) {
	    *close = 0;
	} else {
	    if (odbx_data->flags & BACK_LINK) {
		*close = 0;
	    } else {
		*close = 1;
	    }
	}
    } else {
	do {
	    int delete;

	    if (flags & RANK_LIST) {
		const struct e4_odbx_type *const *list, *odbx_link;

		list = e2nd_data->rank;
		odbx_link = *list;
		while (odbx_link) {
		    if (odbx_miss == odbx_link) {
			break;
		    }
		    list++;
		    odbx_link = *list;
		}
		if (odbx_link) {
		    *close = 0;
		    break;
		}
	    }

	    delete = odbx_data->priority < odbx_miss->priority;
	    if (delete) {
	    } else {
		delete = odbx_data->priority == odbx_miss->priority
		    && odbx_data->flags & BACK_LINK
		    && odbx_miss->flags & BACK_LINK;
	    }

	    *close = !delete;
	} while (0);
    }
}


#if __ALLOW_RIGHT_FIRST__
static void
swap_case(struct e4_odb2_type **odb2_call, unsigned swap)
{
    struct e4_odb2_type **odb2_slip;

    odb2_slip = odb2_call + swap;
    swap >>= 1;
    for (; swap; swap--) {
	struct e4_odb2_type *odb2_class;

	odb2_slip--;

	odb2_class = *odb2_call;
	*odb2_call = *odb2_slip;
	*odb2_slip = odb2_class;

	odb2_call++;
    }
}
#endif				/* __ALLOW_RIGHT_FIRST__ */


#if __ALLOW_RIGHT_FIRST__
static void
swap_lead(struct e4_odb2_type **odb2_slip, unsigned left, unsigned last)
{
    struct e4_odb2_type **odb2_call;
    unsigned swap;

    swap = left + last;
    swap >>= 1;
    swap--;
    odb2_call = odb2_slip - (left >> 1) + 1;

    swap_case(odb2_call, (left >> 1) - 1);

    swap_case(odb2_slip + 1, (last >> 1) - 1);

    swap >>= 1;
    odb2_slip = odb2_slip + (last >> 1) - 0;

    for (; swap; swap--) {
	struct e4_odb2_type *odb2_class;

	odb2_slip--;

	odb2_class = *odb2_call;
	*odb2_call = *odb2_slip;
	*odb2_slip = odb2_class;

	odb2_call++;
    }
}
#endif				/* __ALLOW_RIGHT_FIRST__ */


#if __ALLOW_RIGHT_FIRST__
static void
swap_miss(struct e4_atom_type **atom_call, unsigned *call, unsigned swap)
{
    struct e4_atom_type **atom_slip;
    unsigned miss, *slip;

    slip = call + swap;
    swap >>= 1;
    atom_slip = atom_call + swap;
    miss = swap & 1;
    swap >>= 1;
    for (; swap; swap--) {
	struct e4_atom_type *atom_class;
	unsigned class;

	atom_slip--;

	atom_class = *atom_call;
	*atom_call = *atom_slip;
	*atom_slip = atom_class;

	atom_call++;

	slip--;

	class = *call;
	*call = *slip;
	*slip = class;

	call++;
	slip--;

	class = *call;
	*call = *slip;
	*slip = class;

	call++;
    }
    if (miss) {
	unsigned class;

	slip--;

	class = *call;
	*call = *slip;
	*slip = class;
    }
}
#endif				/* __ALLOW_RIGHT_FIRST__ */


#if __ALLOW_RIGHT_FIRST__
static void
swap_slip(struct e4_atom_type **atom_slip, unsigned *call, unsigned left,
	  unsigned last)
{
    struct e4_atom_type **atom_call;
    unsigned miss, swap, *slip;

    swap = left + last;
    slip = call + swap;
    swap >>= 1;
    atom_call = atom_slip - swap;
    miss = swap & 1;
    swap >>= 1;
    for (; swap; swap--) {
	struct e4_atom_type *atom_class;
	unsigned class;

	atom_slip--;

	atom_class = *atom_call;
	*atom_call = *atom_slip;
	*atom_slip = atom_class;

	atom_call++;

	slip--;

	class = *call;
	*call = *slip;
	*slip = class;

	call++;
	slip--;

	class = *call;
	*call = *slip;
	*slip = class;

	call++;
    }
    if (miss) {
	unsigned class;

	slip--;

	class = *call;
	*call = *slip;
	*slip = class;
    }

    swap = left + last;
    swap >>= 2;
    call -= swap << 1;
    atom_call -= swap;

    swap_miss(atom_call, call, last);

    swap_miss(atom_call + (last >> 1), call + last, left);
}
#endif				/* __ALLOW_RIGHT_FIRST__ */


void
_x1f4_e4_rule_list(struct e4_atom_type *atom_data, unsigned frame,
		   unsigned *atoms, struct e4_odb2_type **odb2_data,
		   struct e4_atom_type **atom_slip)
{
    unsigned i = 0, track;

    track = (frame + 1) << 1;

    *atom_slip++ = atom_data;
    atom_data++;
    for (; i < frame; i++) {
	struct e4_odb2_type *odb2_atom;

	odb2_atom = atom_data->odb2._2nd;
	*atom_slip++ = atom_data;
	atom_data++;
	if (odb2_atom) {
	    struct e4_odb2_type **odb2_text;
	    unsigned *limits;

	    odb2_text = odb2_data + i;
	    limits = atoms + ((i + 2) << 1);
	    limits--;
	    while (1) {
		int enclose;
		unsigned *advance, count, left, right;
		struct e4_odb2_type *odb2_post;
		const struct e4_odbx_type *odbx_data;

		odbx_data = odb2_atom->odbx_data;
		odb2_post = odb2_atom->odb2_data;
		if (odb2_post) {
		    break_list(&enclose, odbx_data, odb2_post->odbx_data);
		} else {
		    if (i == frame - 1) {
			enclose = 0;
		    } else {
			struct e4_atom_type *next_atom;
			unsigned count = 1;

			next_atom = atom_data;
			while (1) {
			    struct e4_odb2_type *odb2_atom;

			    odb2_atom = next_atom->odb2._2nd;
			    while (odb2_atom) {
				count--;
				if (count) {
				} else {
				    break_list
					(&enclose, odbx_data,
					 odb2_atom->odbx_data);
				    break;
				}
				odb2_atom = odb2_atom->odb2_data;
			    }
			    if (odb2_atom) {
				break;
			    } else {
				count++;
				next_atom++;
			    }
			}
		    }
		}

		*odb2_text = odb2_atom;
		advance = limits;
		count = *advance;
		if (count) {
		    while (1) {
			advance--;
			count -= *advance;
			if (count) {
			    advance--;
			    count += *advance;
			} else {
			    break;
			}
		    }
		    advance -= 1;
		} else {
		    advance -= 2;
		}
		right = limits - advance;
		count = *advance;
		if (count) {
		    while (1) {
			advance--;
			count -= *advance;
			if (count) {
			    advance--;
			    count += *advance;
			} else {
			    break;
			}
		    }
		} else {
		    advance--;
		}
		left = limits - advance + 1 - right;
#if __ALLOW_RIGHT_FIRST__
		if (odb2_atom->odbx_data->flags & LEFT_LAST) {
		    swap_lead(odb2_text, left, right);
		    swap_slip(atom_slip, advance + track, left, right);
		}
#endif				/* __ALLOW_RIGHT_FIRST__ */
		(*advance)++;
		(*limits)++;
		if (enclose) {
		    advance[track]++;
		    limits[track]++;
		}
		odb2_atom = odb2_atom->odb2_data;
		if (odb2_atom) {
		    /*
		     * NOTES
		     *
		     * there should be a better way to compute the skip.
		     * likely it is the next computed left operand (expressed
		     * in atoms) size. the array 0 memset would become
		     * unnecessary.
		     */
		    odb2_text--;
		    while (*odb2_text) {
			odb2_text--;
		    }
		} else {
		    break;
		}
	    }
	}
    }
}
