/*
 * e4-e.8.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stdlib.h>
#include <string.h>

#if !defined HAVE_LIBx1f4i0
# include <cstring.v.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>
#if !defined HAVE_LIBx1f4i0
# include <float1.h>
# include <float.v.h>
# include <lcardinal.v.h>
# include <lintegral.v.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define P_ARGS_0 \
    void *, int (*) (void *, const char *, unsigned)
#define P_ARGS_1 \
    void *data, int (*this) (void *, const char *, unsigned)
#define P_ARGS_2 \
    data, this

extern const struct e4_odbx_type _x1f4_e4_implicit[], _x1f4_e4_pick[];

static int print_Atom(P_ARGS_0, struct e4_atom_type *, unsigned, unsigned *);
static int print_atom(P_ARGS_0, struct e4_atom_type *, unsigned);
static int print_bill(P_ARGS_0, struct e4_atom_type *, unsigned);
static int print_ever(P_ARGS_0, struct e4_atom_type *, unsigned);
static int print_hack(P_ARGS_0, struct e4_hack_type *, unsigned);
static int print_last(P_ARGS_0, struct e4_atom_type *, unsigned);
static int print_lock(P_ARGS_0, struct e4_atom_type *, unsigned);
static int print_mode(P_ARGS_0, struct e4_atom_type *, unsigned);
static int print_ocb1(P_ARGS_0, struct e4_odbx_type *, unsigned);
static int print_odb1(P_ARGS_0, struct e4_odb1_type *, unsigned);
static int print_odb2(P_ARGS_0, const struct e4_odbx_type *, unsigned);
static int print_pick(P_ARGS_0, struct e4_atom_type *, unsigned);
static int print_real(P_ARGS_0, struct e4_atom_type *, unsigned);
static int print_text(P_ARGS_0, struct e4_atom_type *, unsigned);
static int print_this(P_ARGS_0, struct e4_atom_type *, unsigned);

static int (*print_type[]) (P_ARGS_0, struct e4_atom_type *, unsigned) = {
/* *INDENT-OFF* */
    print_bill,
    print_mode,
    print_real,
    print_text,
    print_ever,
    print_last,
    print_lock,
    print_pick,
    print_this
/* *INDENT-ON* */
};

static int
print_Atom(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags,
	   unsigned *state)
{
    int status = 0;
    unsigned c;

    c = *state;
    for (; c; c--) {
	status = this(data, "(", 1);
	if (status) {
	    break;
	}
    }
    if (!status) {
	status = print_atom(P_ARGS_2, atom_data, flags);
	if (!status) {
	    state++;
	    c = *state;
	    for (; c; c--) {
		status = this(data, ")", 1);
		if (status) {
		    break;
		}
	    }
	}
    }

    return status;
}


static int
print_atom(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    int status;
    struct e4_odb1_type *odb1_data;

    odb1_data = atom_data->odb1;
    if (odb1_data) {
	status = print_odb1(P_ARGS_2, odb1_data, flags);
	if (status) {
	} else {
	    status = print_type[atom_data->type](P_ARGS_2, atom_data, flags);
	}
    } else {
	status = print_type[atom_data->type](P_ARGS_2, atom_data, flags);
    }

    return status;
}


static int
print_bill(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    int status;

    status = x1f4_vprint_lcardinal
	(P_ARGS_2, 0, 10, *(C_BILL *) &atom_data->data.lead.data);
    if (!status) {
	if (flags & DETAIL_CONSTANTS) {
	    status = this(data, "z", 1);
	}
    }

    return status;
}


static int
print_ever(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    return this(data, atom_data->data.ever.ever_data->name,
	 atom_data->data.ever.ever_data->length);
}


static int
print_hack(P_ARGS_1, struct e4_hack_type *hack_data, unsigned flags)
{
    int status;
    unsigned class;

    class = hack_data->count;
    if (class == 1) {
	status = print_atom(P_ARGS_2, hack_data->atoms, flags);
    } else {
	struct e4_odb2_type **odb2_data;
	unsigned count, miss;

	miss = class
	    * (sizeof(struct e4_atom_type *) + (sizeof(unsigned) << 2));
	count = class - 1;
	miss += count * sizeof(struct e4_odb2_type *);
	odb2_data = (struct e4_odb2_type **) malloc(miss);
	if (!odb2_data) {
	    status = -1;
	} else {
	    struct e4_atom_type **atom_slip;
	    unsigned *atoms;

	    atom_slip = (void *) (odb2_data + count);
	    atoms = (unsigned *) (atom_slip + count + 1);

	    memset(odb2_data, 0, count * sizeof(struct e4_odb2_type *));
	    memset(atoms, 0, class * sizeof(unsigned) << 2);

	    {
		struct e4_atom_type *atom_data;
		unsigned i = 0;

		atom_data = hack_data->atoms;
		_x1f4_e4_rule_list
		    (atom_data, count, atoms, odb2_data, atom_slip);
		atoms += class << 1;
		status = print_Atom(P_ARGS_2, *atom_slip, flags, atoms);
		if (status) {
		} else {
		    atom_slip++;
		    atoms += 2;
		    for (; i < count; i++) {
			const struct e4_odbx_type *odbx_data;

			odbx_data = (*odb2_data)->odbx_data;
			if (odbx_data != _x1f4_e4_pick) {
			    status = print_odb2(P_ARGS_2, odbx_data, flags);
			    if (status) {
				break;
			    }
			}
			status =
			    print_Atom(P_ARGS_2, *atom_slip, flags, atoms);
			if (status) {
			    break;
			}
			atom_slip++;
			atoms += 2;
			odb2_data++;
		    }

		    odb2_data -= i;
		}
	    }

	    free(odb2_data);
	}
    }

    return status;
}


static int
print_last(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    int status;
    struct e4_hack_type *hack_data;
    const struct e4_last_type *last_data;
    unsigned count;

    hack_data = atom_data->data.last.base;
    last_data = hack_base(hack_data)->last_data;
    status = this(data, last_data->name, last_data->length);
    if (status) {
    } else {
	status = this(data, "(", 1);
	if (status) {
	} else {
	    count = last_data->count;
	    if (!count) {
		status = this(data, ")", 1);
	    } else {
		status = print_hack(P_ARGS_2, hack_data, flags);
		if (status) {
		} else {
		    count--;
		    while (count) {
			hack_data++;
			count--;
			status = this(data, ", ", 2);
			if (status) {
			    break;
			} else {
			    status = print_hack(P_ARGS_2, hack_data, flags);
			    if (status) {
				break;
			    }
			}
		    }
		    if (status) {
		    } else {
			status = this(data, ")", 1);
		    }
		}
	    }
	}
    }

    return status;
}


static int
print_lock(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    int status;
    const struct e4_ever_type *ever_data;
    struct e4_fine_type *fine_data;
    struct e4_hack_type *hack_data;
    const struct e4_last_type *last_data;
    unsigned count;

    fine_data = lock_fine(atom_data);

    hack_data = atom_data->data.last.base;
    last_data = hack_base(hack_data)->last_data;
    ever_data = fine_data->ever_data;
    status = this(data, ever_data->name, ever_data->length);
    if (status) {
    } else {
	status = this(data, "(", 1);
	if (status) {
	} else {
	    count = last_data->count;
	    if (!count) {
		status = this(data, ")", 1);
	    } else {
		status = print_hack(P_ARGS_2, hack_data, flags);
		if (status) {
		} else {
		    count--;
		    while (count) {
			hack_data++;
			count--;
			status = this(data, ", ", 2);
			if (status) {
			    break;
			} else {
			    status = print_hack(P_ARGS_2, hack_data, flags);
			    if (status) {
				break;
			    }
			}
		    }
		    if (status) {
		    } else {
			status = this(data, ")", 1);
		    }
		}
	    }
	}
    }

    return status;
}


static int
print_mode(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    int status;

    status = x1f4_vprint_lintegral
	(P_ARGS_2, 0, 10, *(C_MODE *) &atom_data->data.lead.data);
    if (!status) {
	if (flags & DETAIL_CONSTANTS) {
	    status = this(data, "i", 1);
	}
    }

    return status;
}


static int
print_ocb1(P_ARGS_1, struct e4_odbx_type *odbx_data, unsigned flags)
{
    int status;

    do {
	if (!(flags & DETAIL_IMPLICITS)) {
	    const struct e4_odbx_type *implicit;
	    unsigned i = 6;

	    implicit = _x1f4_e4_implicit;
	    for (; i; i--) {
		if (odbx_data == implicit) {
		    break;
		} else {
		    implicit++;
		}
	    }
	    if (i) {
		status = 0;
		break;
	    }
	}

	status = this(data, odbx_data->name, odbx_data->length);
	if (!status) {
	    if (flags & DETAIL_OPERATORS) {
		int type_f;
		const int *args;

		args = odbx_data->args;
		type_f = *args;
		if (type_f == BILL) {
		    status = this(data, ",", 1);
		} else if (type_f == MODE) {
		    status = this(data, ".", 1);
		} else if (type_f == REAL) {
		    status = this(data, "*", 1);
		} else if (type_f == TEXT) {
		    status = this(data, "o", 1);
		} else {
		    status = this(data, "x", 1);
		}
	    }
	}
    } while (0);

    return status;
}


static int
print_odb1(P_ARGS_1, struct e4_odb1_type *odb1_data, unsigned flags)
{
    int status;
    struct e4_odbx_type *odbx_data;

    odbx_data = (struct e4_odbx_type *) odb1_data->odbx_data;
    odb1_data = odb1_data->odb1_data;
    if (!odb1_data) {
	status = print_ocb1(P_ARGS_2, odbx_data, flags);
    } else {
	status = print_odb1(P_ARGS_2, odb1_data, flags);
	if (!status) {
	    status = print_ocb1(P_ARGS_2, odbx_data, flags);
	}
    }

    return status;
}


static int
print_odb2(P_ARGS_1, const struct e4_odbx_type *odbx_data, unsigned flags)
{
    int status;

    do {
	status = this(data, " ", 1);
	if (status) {
	    break;
	}
	if (flags & DETAIL_OPERATORS) {
	    int type_f;
	    const int *args;

	    args = odbx_data->args;
	    type_f = *args;
	    if (type_f == BILL) {
		status = this(data, ",", 1);
		if (status) {
		    break;
		}
	    } else if (type_f == MODE) {
		status = this(data, ".", 1);
		if (status) {
		    break;
		}
	    } else if (type_f == REAL) {
		status = this(data, "*", 1);
		if (status) {
		    break;
		}
	    } else if (type_f == TEXT) {
		status = this(data, "o", 1);
		if (status) {
		    break;
		}
	    } else {
		status = this(data, "x", 1);
		if (status) {
		    break;
		}
	    }
	    status =
		this(data, odbx_data->name, odbx_data->length);
	    if (status) {
		break;
	    }
	    args++;
	    type_f = *args;
	    if (type_f == BILL) {
		status = this(data, ",", 1);
		if (status) {
		    break;
		}
	    } else if (type_f == MODE) {
		status = this(data, ".", 1);
		if (status) {
		    break;
		}
	    } else if (type_f == REAL) {
		status = this(data, "*", 1);
		if (status) {
		    break;
		}
	    } else if (type_f == TEXT) {
		status = this(data, "o", 1);
		if (status) {
		    break;
		}
	    } else {
		status = this(data, "x", 1);
		if (status) {
		    break;
		}
	    }
	} else {
	    status = this(data, odbx_data->name, odbx_data->length);
	    if (status) {
		break;
	    }
	}

	status = this(data, " ", 1);
	if (status) {
	    break;
	}
    } while (0);

    return status;
}


static int
print_pick(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    int status;
    struct e4_hack_type *hack_data;
    const struct e4_last_type *last_data;
    unsigned count;

    hack_data = atom_data->data.last.base;
    last_data = hack_base(hack_data)->last_data;
    if (0) {
    } else {
	status = this(data, "(", 1);
	if (status) {
	} else {
	    count = last_data->count;
	    if (!count) {
		status = this(data, ")", 1);
	    } else {
		status = print_hack(P_ARGS_2, hack_data, flags);
		if (status) {
		} else {
		    count--;
		    while (count) {
			hack_data++;
			count--;
			status = this(data, ", ", 2);
			if (status) {
			    break;
			} else {
			    status = print_hack(P_ARGS_2, hack_data, flags);
			    if (status) {
				break;
			    }
			}
		    }
		    if (status) {
		    } else {
			status = this(data, ")", 1);
		    }
		}
	    }
	}
    }

    return status;
}


static int
print_real(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    int status;

    status = x1f4_vprint_float
	(P_ARGS_2, 6, *(C_REAL *) &atom_data->data.lead.data);
    if (!status) {
	if (flags & DETAIL_CONSTANTS) {
	    status = this(data, "r", 1);
	}
    }

    return status;
}


static int
print_text(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    int status;

    status = this(data, "\"", 1);
    if (!status) {
	x1f4_vprint_cstring(P_ARGS_2, *(C_TEXT *) &atom_data->data.lead.data);
	if (!status) {
	    this(data, "\"", 1);
	}
    }

    return status;
}


static int
print_this(P_ARGS_1, struct e4_atom_type *atom_data, unsigned flags)
{
    int status;

    status = this(data, "(", 1);
    if (!status) {
	status = print_hack(P_ARGS_2, atom_data->data.hack.data, flags);
	if (!status) {
	    status = this(data, ")", 1);
	}
    }

    return status;
}


int
x1f4_vprint_expression(void *data,
		       int (*this) (void *, const char *, unsigned),
		       struct e4_expression_type *expression_data,
		       unsigned flags)
{
    return print_hack(data, this, &expression_data->hack_data, flags);
}
