/*
 * e4-e.7.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-inter.h>
#include <e4-types.h>

#define LOGIC_BITS \
    ((1 << LAST) | (1 << LOCK) | (1 << PICK))

static void fast_hack(struct e4_hack_type *, unsigned,
		      int (**) (x1f4_e4_LOAD_ARGS_0));

static void
fast_hack(struct e4_hack_type *hack_data, unsigned bits,
	  int (**load) (x1f4_e4_LOAD_ARGS_0))
{
    struct e4_atom_type *atom_data;
    unsigned count;

    _x1f4_e4_fast_hack(hack_data, bits, load);

    atom_data = hack_data->atoms;

    count = hack_data->count;
    for (; count; count--) {
	int type;

	type = atom_data->type;
	if (1 << type & LOGIC_BITS) {
	    int (**post) (x1f4_e4_LOAD_ARGS_0);
	    const int *args;
	    struct e4_hack_type *this_hack;
	    const struct e4_last_type *last_data;
	    unsigned count, flags;

	    this_hack = atom_data->data.last.base;
	    last_data = hack_base(this_hack)->last_data;
	    flags = last_data->flags;
	    count = last_data->count;
	    if (0) {
	    } else {
		args = last_data->args;
	    }
	    args += count;
	    post = (int (**) (x1f4_e4_LOAD_ARGS_0)) (this_hack + count);
	    for (; count; count--) {
		unsigned class;

		fast_hack(this_hack, bits, post);
		if (flags & POST_TYPE) {
		    class = *args++;
		} else {
		    class = 0;
		}
		_x1f4_e4_fast_miss(this_hack, class, post);
		this_hack++;
		post++;
	    }
	} else {
	    if (type == THIS) {
		fast_hack(atom_data->data.hack.data, bits,
			  &atom_data->data.hack.load);
	    }
	}

	atom_data++;
    }
}


void
_x1f4_e4_fare_expression(struct e4_expression_type *expression_data)
{
    fast_hack
	(&expression_data->hack_data, expression_data->flags,
	 &expression_data->load);
}
