/*
 * e4-e.1.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TODO
 *
 *.optimize `c <- c and e' as `c and<- e'
 */

/*
 * FEATURES
 *
 *.it is not clear whether the odb{A,C,a,c}_type->odbl_miss (and perhaps
 * odb{S,s}_type->odbl_miss) are ever used
 */

#include <e4-config.h>

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>

#define CONSTANT_0			(1 << BILL)
#define CONSTANT_1			(CONSTANT_0 | (1 << MODE))
#define CONSTANT_2			(CONSTANT_1 | (1 << REAL))
#define CONSTANT_3			(CONSTANT_2 | (1 << TEXT))

#define CONSTANT			CONSTANT_3

#define STAGE_0				(1 << 0)
#define STAGE_1				(1 << 1)

#define LINE______ARGS_0 \
    struct e4_hack_type *, void *, unsigned *
#define LINE______ARGS_1 \
    struct e4_hack_type *hack_data, void *aile, unsigned *progress
#define LINE______ARGS_2 \
    hack_data, aile, progress

#define FIX_TEXT(___aile, ___atom_data) \
    E_FREE((___aile), *(C_TEXT *) &(___atom_data)->data.lead.data)

#define LOGIC_BITS \
    ((1 << LAST) | (1 << LOCK) | (1 << PICK))

#define SET_ATOM(atom_data, type_1, transfer) \
    {									      \
	if ((type_1) == BILL) {						      \
	    C_BILL *slip;						      \
									      \
	    (atom_data)->load = _x1f4_e4_load_mode;			      \
	    (atom_data)->type = BILL;					      \
	    slip = (C_BILL *) &(atom_data)->data.lead.data;		      \
	    *slip = *(C_BILL *) (transfer);				      \
	} else if ((type_1) == MODE) {					      \
	    C_MODE *slip;						      \
									      \
	    (atom_data)->load = _x1f4_e4_load_mode;			      \
	    (atom_data)->type = MODE;					      \
	    slip = (C_MODE *) &(atom_data)->data.lead.data;		      \
	    *slip = *(C_MODE *) (transfer);				      \
	} else if ((type_1) == REAL) {					      \
	    C_REAL *slip;						      \
									      \
	    (atom_data)->load = _x1f4_e4_load_real;			      \
	    (atom_data)->type = REAL;					      \
	    slip = (C_REAL *) &(atom_data)->data.lead.data;		      \
	    *slip = *(C_REAL *) (transfer);				      \
	} else {							      \
	    C_TEXT *slip;						      \
									      \
	    (atom_data)->load = _x1f4_e4_load_text;			      \
	    (atom_data)->type = TEXT;					      \
	    slip = (C_TEXT *) &(atom_data)->data.lead.data;		      \
	    *slip = *(C_TEXT *) (transfer);				      \
	}								      \
    }

#define Set_atom(atom_data, type_1, transfer) \
    {									      \
	if ((type_1) == BILL) {						      \
	    C_BILL *slip;						      \
									      \
	    (atom_data)->load = _x1f4_e4_load_mode;			      \
	    (atom_data)->type = BILL;					      \
	    slip = (C_BILL *) &(atom_data)->data.lead.data;		      \
	    *slip = *(C_BILL *) (transfer);				      \
	} else if ((type_1) == MODE) {					      \
	    C_MODE *slip;						      \
									      \
	    (atom_data)->load = _x1f4_e4_load_mode;			      \
	    (atom_data)->type = MODE;					      \
	    slip = (C_MODE *) &(atom_data)->data.lead.data;		      \
	    *slip = *(C_MODE *) (transfer);				      \
	} else if ((type_1) == REAL) {					      \
	    C_REAL *slip;						      \
									      \
	    (atom_data)->load = _x1f4_e4_load_real;			      \
	    (atom_data)->type = REAL;					      \
	    slip = (C_REAL *) &(atom_data)->data.lead.data;		      \
	    *slip = *(C_REAL *) (transfer);				      \
	} else if ((type_1) == TEXT) {					      \
	    C_TEXT *slip;						      \
									      \
	    (atom_data)->load = _x1f4_e4_load_text;			      \
	    (atom_data)->type = TEXT;					      \
	    slip = (C_TEXT *) &(atom_data)->data.lead.data;		      \
	    *slip = *(C_TEXT *) (transfer);				      \
	} else {							      \
	    C_USER *slip;						      \
									      \
	    (atom_data)->load = _x1f4_e4_load_user;			      \
	    (atom_data)->type = (type_1);				      \
	    slip = (C_USER *) &(atom_data)->data.lead.data;		      \
	    *slip = *(C_USER *) (transfer);				      \
	}								      \
    }

#define EXPRESSION(expression) \
    ((e4_expression_type *) expression)

#define E_FREE(mcontext, mdata) \
    (EXPRESSION(mcontext)->m.free(EXPRESSION(mcontext)->m.data, (mdata)))
#define E_LINK(mcontext, mdata, size) \
    (EXPRESSION(mcontext)->m.link					      \
	(EXPRESSION(mcontext)->m.data, (void *) (mdata), (size)))
#define E_MODE(mcontext, mdata, size) \
    (EXPRESSION(mcontext)->m.mode					      \
	(EXPRESSION(mcontext)->m.data, (void *) (mdata), (size)))

static int find_ci_1(struct e4_atom_type *, unsigned,
		     const struct e4_ndbl_type *, struct e4_odb2_type *,
		     struct e4_atom_type **);
static int find_ci_3(struct e4_atom_type *, unsigned,
		     const struct e4_ndbl_type *, struct e4_odb2_type *,
		     struct e4_atom_type **);
static int find_cl_1(struct e4_atom_type *, unsigned,
		     const struct e4_ndbl_type *, const struct e4_odbx_type *,
		     struct e4_odb2_type *, struct e4_odb1_type **,
		     struct e4_odb1_type **, struct e4_atom_type **);
static int find_cl_3(struct e4_atom_type *, unsigned,
		     const struct e4_ndbl_type *, const struct e4_odbx_type *,
		     struct e4_odb2_type *, struct e4_odb1_type **,
		     struct e4_odb1_type **, struct e4_atom_type **);
static int line_ce_0(struct e4_atom_type *, void *, void *, unsigned *);
static int line_ce_1(struct e4_atom_type *, void *,
		     struct e4_expression_type *, unsigned *);
static int line_cf_0(LINE______ARGS_0);
static int line_cf_1(LINE______ARGS_0);
static int line_cf_2(LINE______ARGS_0);
static int line_cf_3(LINE______ARGS_0);
static int line_cf_4(LINE______ARGS_0);
static int line_cf_5(LINE______ARGS_0);
static int line_cf_6(LINE______ARGS_0);
static int line_cf_7(LINE______ARGS_0);
static int line_cf_8(LINE______ARGS_0);
static int line_cf_9(LINE______ARGS_0);
static int line_list(struct e4_hack_type *, unsigned, void *,
		     unsigned *, int (*const *) (LINE______ARGS_0));
static int line_this(struct e4_hack_type *, void *, unsigned *,
		     int (*const *) (LINE______ARGS_0));
static int make_this(struct e4_hack_type *, void *, unsigned *, unsigned *);
static int miss_cf_0(struct e4_odb2_type *, const struct e4_odbl_type *,
		     const struct e4_cdbx_type *);
static int miss_cf_1(struct e4_odb2_type *, struct e4_atom_type *,
		     const struct e4_odbl_type *);
static int miss_cf_2(struct e4_atom_type *, struct e4_atom_type *,
		     const struct e4_odbl_type *, void *);
static int miss_lock(struct e4_atom_type *, struct e4_odb1_type *,
		     struct e4_odb1_type *, struct e4_atom_type *);
static int pick_lock(struct e4_atom_type *, struct e4_odb1_type **,
		     struct e4_odb1_type **);
static int post_this(struct e4_hack_type *, void *, struct e4_atom_type **);
static int sign_cf_1(struct e4_atom_type *, struct e4_odb2_type *,
		     const struct e4_odbt_type *, const struct e4_odbz_type *,
		     const struct e4_odbl_type **,
		     const struct e4_odbl_type **);
static int sign_cf_2(struct e4_atom_type *, struct e4_odb2_type *,
		     const struct e4_odbt_type *,
		     const struct e4_odbl_type **);
static int sign_head(struct e4_odb2_type *, struct e4_atom_type *,
		     const struct e4_edbx_type *, struct e4_odb2_type *);
static int sign_list(struct e4_hack_type *, unsigned, void *, unsigned *);
static int sign_this(struct e4_hack_type *, void *, unsigned *);
static int test_atom(struct e4_atom_type *, int, const void *);
static int test_head(struct e4_atom_type *, const void *,
		     struct e4_odb2_type *, unsigned, struct e4_odb2_type **);
static int type_atom(struct e4_atom_type *, int, const void *);

static int (*const line_0[]) (LINE______ARGS_0) = {
/* *INDENT-OFF* */
    line_cf_6,
    line_cf_1,
    NULL
/* *INDENT-ON* */
}, (*const line_1[]) (LINE______ARGS_0) = {
/* *INDENT-OFF* */
    line_cf_5,
    line_cf_4,
    line_cf_3,
    line_cf_2,
    line_cf_7,
    line_cf_8,
    line_cf_9,
    NULL
/* *INDENT-ON* */
};

static int
find_ci_1(struct e4_atom_type *atom_data, unsigned atom_advance,
	  const struct e4_ndbl_type *ndbl_data, struct e4_odb2_type *odb2_seek,
	  struct e4_atom_type **atom)
{
    int false = 1;

    atom_advance--;
    while (atom_advance) {
	int type_1;

	atom_data++;
	type_1 = atom_data->type;
	if ((1 << type_1) & CONSTANT) {
	    struct e4_odb2_type *odb2_data;

	    odb2_data = atom_data->odb2._2nd;
	    if (odb2_data) {
		while (odb2_data) {
		    if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
			break;
		    } else {
			odb2_data = odb2_data->odb2_data;
		    }
		}
		if (odb2_data) {
		} else {
		    unsigned count = ~0, limit;

		    limit = atom_advance;
		    while (limit) {
			struct e4_odb2_type *odb2_data;

			limit--;
			count++;
			atom_data++;
			odb2_data = atom_data->odb2._2nd;
			if (odb2_data) {
			    while (odb2_data) {
				if (count) {
				    count--;
				    odb2_data = odb2_data->odb2_data;
				} else {
				    break;
				}
			    }
			    if (odb2_data) {
				while (odb2_data) {
				    if (odb2_data == odb2_seek) {
					*atom =
					    atom_data - (atom_advance - limit);
					false = 0;
					break;
				    } else {
					if (_x1f4_e4_find_ce_8
					    (ndbl_data, odb2_data)) {
					    break;
					} else {
					    odb2_data = odb2_data->odb2_data;
					}
				    }
				}
				if (odb2_data) {
				    break;
				}
				count = ~0;
			    }
			}
		    }
		    if (limit) {
		    }
		    if (false) {
			atom_data -= atom_advance - limit;
		    } else {
			break;
		    }
		}
	    }
	}

	atom_advance--;
    }
    if (!false) {
    } else if (!atom_advance) {
	int type_1;

	atom_data++;
	type_1 = atom_data->type;
	if ((1 << type_1) & CONSTANT) {
	    struct e4_odb2_type *odb2_data;

	    odb2_data = atom_data->odb2._2nd;
	    if (odb2_data) {
		while (odb2_data) {
		    if (odb2_data == odb2_seek) {
			*atom = atom_data;
			false = 0;
			break;
		    } else {
			if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
			    break;
			} else {
			    odb2_data = odb2_data->odb2_data;
			}
		    }
		}
	    }
	}
    }

    return false;
}


static int
find_ci_3(struct e4_atom_type *atom_data, unsigned atom_advance,
	  const struct e4_ndbl_type *ndbl_data, struct e4_odb2_type *odb2_seek,
	  struct e4_atom_type **atom)
{
    int false = 1;

    atom_advance--;
    while (atom_advance) {
	int type_1;

	atom_data++;
	type_1 = atom_data->type;
	if ((1 << type_1) & CONSTANT) {
	    struct e4_odb2_type *odb2_data;

	    odb2_data = atom_data->odb2._2nd;
	    if (odb2_data) {
	    } else {
		unsigned post_advance;

		_x1f4_e4_find_ce_0(atom_data, &post_advance, &odb2_data);
		if (atom_advance < post_advance) {
		} else {
		    while (odb2_data) {
			if (odb2_data == odb2_seek) {
			    *atom = atom_data;
			    false = 0;
			    break;
			} else {
			    if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
				break;
			    } else {
				odb2_data = odb2_data->odb2_data;
			    }
			}
		    }
		    if (false) {
		    } else {
			break;
		    }
		}
		if (odb2_data) {
		} else {
		    unsigned count = ~0, limit;

		    atom_data += post_advance;
		    limit = atom_advance - post_advance;
		    while (limit) {
			struct e4_odb2_type *odb2_data;

			limit--;
			count++;
			atom_data++;
			odb2_data = atom_data->odb2._2nd;
			if (odb2_data) {
			    while (odb2_data) {
				if (count) {
				    count--;
				    odb2_data = odb2_data->odb2_data;
				} else {
				    break;
				}
			    }
			    if (odb2_data) {
				while (odb2_data) {
				    if (odb2_data == odb2_seek) {
					*atom =
					    atom_data - (atom_advance - limit);
					false = 0;
					break;
				    } else {
					if (_x1f4_e4_find_ce_8
					    (ndbl_data, odb2_data)) {
					    break;
					} else {
					    odb2_data = odb2_data->odb2_data;
					}
				    }
				}
				if (odb2_data) {
				    break;
				}
				count = ~0;
			    }
			}
		    }
		    if (limit) {
		    }
		    if (false) {
			atom_data -= atom_advance - limit;
		    } else {
			break;
		    }
		}
	    }
	}

	atom_advance--;
    }

    return false;
}


static int
find_cl_1(struct e4_atom_type *atom_data, unsigned atom_advance,
	  const struct e4_ndbl_type *ndbl_data,
	  const struct e4_odbx_type *odbx_seek, struct e4_odb2_type *odb2_seek,
	  struct e4_odb1_type **odb0, struct e4_odb1_type **odb1,
	  struct e4_atom_type **atom)
{
    int false = 1;

    atom_advance--;
    while (atom_advance) {
	int type_1;

	atom_data++;
	type_1 = atom_data->type;
	if ((1 << type_1) & CONSTANT) {
	} else {
	    struct e4_odb2_type *odb2_data;

	    odb2_data = atom_data->odb2._2nd;
	    if (odb2_data) {
		if (atom_data->odb1) {
		    struct e4_odb1_type *odb1_pick, *odb1_slip;

		    pick_lock(atom_data, &odb1_slip, &odb1_pick);
		    if (odb1_pick->odbx_data == odbx_seek) {
			*odb0 = odb1_slip;
			*odb1 = odb1_pick;
		    } else {
			odb2_data = NULL;
		    }
		} else {
		    odb2_data = NULL;
		}
	    }
	    if (odb2_data) {
		while (odb2_data) {
		    if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
			break;
		    } else {
			odb2_data = odb2_data->odb2_data;
		    }
		}
		if (odb2_data) {
		} else {
		    unsigned count = ~0, limit;

		    limit = atom_advance;
		    while (limit) {
			struct e4_odb2_type *odb2_data;

			limit--;
			count++;
			atom_data++;
			odb2_data = atom_data->odb2._2nd;
			if (odb2_data) {
			    while (odb2_data) {
				if (count) {
				    count--;
				    odb2_data = odb2_data->odb2_data;
				} else {
				    break;
				}
			    }
			    if (odb2_data) {
				while (odb2_data) {
				    if (odb2_data == odb2_seek) {
					*atom =
					    atom_data - (atom_advance - limit);
					false = 0;
					break;
				    } else {
					if (_x1f4_e4_find_ce_8
					    (ndbl_data, odb2_data)) {
					    break;
					} else {
					    odb2_data = odb2_data->odb2_data;
					}
				    }
				}
				if (odb2_data) {
				    break;
				}
				count = ~0;
			    }
			}
		    }
		    if (limit) {
		    }
		    if (false) {
			atom_data -= atom_advance - limit;
		    } else {
			break;
		    }
		}
	    }
	}

	atom_advance--;
    }
    if (!false) {
    } else if (!atom_advance) {
	int type_1;

	atom_data++;
	type_1 = atom_data->type;
	if ((1 << type_1) & CONSTANT) {
	} else {
	    struct e4_odb2_type *odb2_data;

	    odb2_data = atom_data->odb2._2nd;
	    if (1) {
		if (atom_data->odb1) {
		    struct e4_odb1_type *odb1_pick, *odb1_slip;

		    pick_lock(atom_data, &odb1_slip, &odb1_pick);
		    if (odb1_pick->odbx_data == odbx_seek) {
			*odb0 = odb1_slip;
			*odb1 = odb1_pick;
		    } else {
			odb2_data = NULL;
		    }
		} else {
		    odb2_data = NULL;
		}
	    }
	    if (odb2_data) {
		while (odb2_data) {
		    if (odb2_data == odb2_seek) {
			*atom = atom_data;
			false = 0;
			break;
		    } else {
			if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
			    break;
			} else {
			    odb2_data = odb2_data->odb2_data;
			}
		    }
		}
	    }
	}
    }

    return false;
}


static int
find_cl_3(struct e4_atom_type *atom_data, unsigned atom_advance,
	  const struct e4_ndbl_type *ndbl_data,
	  const struct e4_odbx_type *odbx_seek, struct e4_odb2_type *odb2_seek,
	  struct e4_odb1_type **odb0, struct e4_odb1_type **odb1,
	  struct e4_atom_type **atom)
{
    int false = 1;

    atom_advance--;
    while (atom_advance) {
	int type_1;

	atom_data++;
	type_1 = atom_data->type;
	if ((1 << type_1) & CONSTANT) {
	} else {
	    struct e4_odb2_type *odb2_data;

	    odb2_data = atom_data->odb2._2nd;
	    if (odb2_data) {
	    } else {
		if (atom_data->odb1) {
		    struct e4_odb1_type *odb1_pick, *odb1_slip;

		    pick_lock(atom_data, &odb1_slip, &odb1_pick);
		    if (odb1_pick->odbx_data == odbx_seek) {
			*odb0 = odb1_slip;
			*odb1 = odb1_pick;
		    } else {
			odb2_data = (void *) 1;
		    }
		} else {
		    odb2_data = (void *) 1;
		}
	    }
	    if (odb2_data) {
	    } else {
		unsigned post_advance;

		_x1f4_e4_find_ce_0(atom_data, &post_advance, &odb2_data);
		if (atom_advance < post_advance) {
		} else {
		    while (odb2_data) {
			if (odb2_data == odb2_seek) {
			    *atom = atom_data;
			    false = 0;
			    break;
			} else {
			    if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
				break;
			    } else {
				odb2_data = odb2_data->odb2_data;
			    }
			}
		    }
		    if (false) {
		    } else {
			break;
		    }
		}
		if (odb2_data) {
		} else {
		    unsigned count = ~0, limit;

		    atom_data += post_advance;
		    limit = atom_advance - post_advance;
		    while (limit) {
			struct e4_odb2_type *odb2_data;

			limit--;
			count++;
			atom_data++;
			odb2_data = atom_data->odb2._2nd;
			if (odb2_data) {
			    while (odb2_data) {
				if (count) {
				    count--;
				    odb2_data = odb2_data->odb2_data;
				} else {
				    break;
				}
			    }
			    if (odb2_data) {
				while (odb2_data) {
				    if (odb2_data == odb2_seek) {
					*atom =
					    atom_data - (atom_advance - limit);
					false = 0;
					break;
				    } else {
					if (_x1f4_e4_find_ce_8
					    (ndbl_data, odb2_data)) {
					    break;
					} else {
					    odb2_data = odb2_data->odb2_data;
					}
				    }
				}
				if (odb2_data) {
				    break;
				}
				count = ~0;
			    }
			}
		    }
		    if (limit) {
		    }
		    if (false) {
			atom_data -= atom_advance - limit;
		    } else {
			break;
		    }
		}
	    }
	}

	atom_advance--;
    }

    return false;
}


static int
line_ce_0(struct e4_atom_type *atom_data, void *aile, void *type_l,
	  unsigned *progress)
{
    int false;
    struct e4_hack_type *this_hack;

    this_hack = atom_data->data.hack.data;
    if (this_hack->count != 1) {
	false = 1;
    } else {
	int type_1, *type_I;
	struct e4_atom_type *this_atom;

	this_atom = this_hack->atoms;
	atom_data->data = this_atom->data;
	atom_data->load = this_atom->load;
	type_1 = this_atom->type;
	type_I = type_l;
	*type_I = type_1;
	atom_data->type = type_1;
	if (this_atom->odb1) {
	    struct e4_odb1_type *odb1_data, *link_odb1, *this_odb1;

	    odb1_data = atom_data->odb1;
	    this_odb1 = this_atom->odb1;
	    atom_data->odb1 = this_odb1;
	    link_odb1 = this_odb1->odb1_data;
	    while (link_odb1) {
		this_odb1 = link_odb1;
		link_odb1 = this_odb1->odb1_data;
	    }
	    this_odb1->odb1_data = odb1_data;
	}

	E_FREE(aile, this_atom);
	E_FREE(aile, this_hack);

	false = 0;

	*progress |= STAGE_0;
    }

    return false;
}


static int
line_ce_1(struct e4_atom_type *atom_data, void *type_l,
	  struct e4_expression_type *expression_data, unsigned *progress)
{
    int false;
    struct e4_hack_type *hack_data;
    const struct e4_last_type *this_last;

    hack_data = atom_data->data.last.base;
    this_last = hack_base(hack_data)->last_data;
    if (this_last->flags & KEEP_CALL) {
	false = 1;
#if !__OPTIMIZE_USER_FUNCTIONS__
    } else if (!(this_last->type < USER)) {
	false = 1;
#endif				/* !__OPTIMIZE_USER_FUNCTIONS__*/
    } else {
	struct e4_post_type *post_data;
	unsigned j, count;
	void **list;

	post_data = expression_data->post_data;
	list = expression_data->list;
	count = this_last->count;
	for (j = count; j; j--) {
	    if (hack_data->count != 1) {
		break;
	    } else {
		int type_1;
		struct e4_atom_type *atom_data;

		atom_data = hack_data->atoms;
		type_1 = atom_data->type;
		if ((1 << type_1) & CONSTANT) {
		    if (atom_data->odb1) {
			break;
		    } else {
			int status;

			*list++ = &post_data->data;
			status = atom_data->load(atom_data, post_data, NULL);
			if (status) {
			    break;
			} else {
			}
		    }
		} else {
		    break;
		}
	    }

	    hack_data++;
	    post_data++;
	}
	if (j) {
	    false = 1;
	} else {
	    int status;
	    void *transfer;

	    list -= count;
	    transfer = &post_data->data;
	    if (this_last->flags & TEXT_LINK) {
		status = this_last->last
		    (hack_base(hack_data - count)->text, transfer, list);
	    } else {
		status = this_last->last(NULL, transfer, list);
	    }
	    if (status) {
		false = 1;
	    } else {
		int type_1, *type_I;

		type_1 = this_last->type;
		type_I = type_l;
		*type_I = type_1;
#if !__OPTIMIZE_USER_FUNCTIONS__
		SET_ATOM(atom_data, type_1, transfer);
#else
		Set_atom(atom_data, type_1, transfer);
#endif				/* !__OPTIMIZE_USER_FUNCTIONS__*/

		for (j = count; j; j--) {
		    struct e4_atom_type *atom_data;

		    --hack_data;
		    atom_data = hack_data->atoms;
		    if (atom_data->type == TEXT) {
			FIX_TEXT(expression_data, atom_data);
		    }
		    E_FREE(expression_data, atom_data);
		}

		E_FREE(expression_data, hack_base(hack_data));

		false = 0;

		*progress |= STAGE_0;
	    }
	}
    }

    return false;
}


static int
line_cf_0(LINE______ARGS_1)
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned count, flow = 0, i;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    atom_data++;
    i = count - 1;
    while (i) {
	int type_1;
	unsigned deck = 1, next = 1;

	type_1 = atom_data->type;
	if (type_1 == LAST) {
	    if (line_ce_1(atom_data, &type_1, aile, progress)) {
	    } else {
		deck = 0;
		next = 0;
	    }
#if 0
	} else if (type_1 == LOCK) {
	} else if (type_1 == PICK) {
#endif				/* 0 */
	} else if (type_1 == THIS) {
	    if (line_ce_0(atom_data, aile, &type_1, progress)) {
	    } else {
		deck = 0;
		next = 0;
	    }
	} else if ((1 << type_1) & CONSTANT) {
	    struct e4_odb1_type *odb1_data;
	    struct e4_odb2_type *odb2_data;

	    odb1_data = atom_data->odb1;
	    while (odb1_data) {
		const struct e4_odbx_type *odbx_data;

		odbx_data = odb1_data->odbx_data;
		if (odbx_data->flags & KEEP_CALL) {
		    break;
		} else {
		    int type_2;

		    type_2 = odbx_data->type;
		    if (type_2 == TEXT) {
			break;
		    } else {
			struct e4_post_type data[1];

			status = atom_data->load(atom_data, data + 0, NULL);
			if (status) {
			    break;
			} else {
			    struct e4_post_type post;
			    void *bias[1], *transfer;

			    bias[0] = &data[0].data;
			    transfer = &post.data;
			    status = odbx_data->odbx(transfer, bias);
			    if (status) {
				break;
			    } else {
				struct e4_odb1_type *free_odb1;

				if (type_1 == TEXT) {
				    FIX_TEXT(aile, atom_data);
				}
				free_odb1 = odb1_data;
				odb1_data = odb1_data->odb1_data;
				atom_data->odb1 = odb1_data;
				E_FREE(aile, free_odb1);
				SET_ATOM(atom_data, type_2, transfer);

				*progress |= STAGE_0;
			    }
			}
		    }
		}
	    }

	    odb2_data = atom_data->odb2._2nd;
	    if (!odb1_data && odb2_data && !atom_data[-1].odb1
		&& !atom_data[-1].odb2._2nd
		&& (1 << atom_data[-1].type) & CONSTANT) {
		const struct e4_odbx_type *odbx_data;

		odbx_data = odb2_data->odbx_data;
		if (odbx_data->flags & (KEEP_CALL | LEFT_XSET)) {
		} else {
		    int type_2;

		    type_2 = odbx_data->type;
		    if (type_2 == TEXT) {
			break;
		    } else {
			struct e4_post_type data[2];

			status = atom_data->load(atom_data, data + 1, NULL);
			if (status) {
			    break;
			} else {
			    atom_data--;
			    status = atom_data->load
				(atom_data, data + 0, NULL);
			    if (status) {
				break;
			    } else {
				struct e4_post_type post;
				void *bias[2], *transfer;

				bias[0] = &data[0].data;
				bias[1] = &data[1].data;
				transfer = &post.data;
				status = odbx_data->odbx(transfer, bias);
				if (status) {
				    break;
				} else {
				    if (atom_data->type == TEXT) {
					FIX_TEXT(aile, atom_data);
				    }
				    SET_ATOM(atom_data, type_2, transfer);
				    atom_data->odb2._2nd =
					odb2_data->odb2_data;
				    E_FREE(aile, odb2_data);
				    deck = 0;
				    flow++;
				    atom_data++;
				    if (type_1 == TEXT) {
					FIX_TEXT(aile, atom_data);
				    }
				    if (i != 1) {
					memmove
					    (atom_data, atom_data + 1,
					     i * sizeof(struct e4_atom_type));
				    }

				    *progress |= STAGE_0;
				}
			    }
			}
		    }
		}
	    }
	}

	i -= next;
	atom_data += deck;
    }

    if (flow) {
	count -= flow;
	E_MODE(aile, &hack_data->atoms, count * sizeof(struct e4_atom_type));
	hack_data->count = count;
    }

    return status;
}


static int
line_cf_1(LINE______ARGS_1)
{
    int status = 0, type_1;
    struct e4_atom_type *atom_data;

    atom_data = hack_data->atoms;
    type_1 = atom_data->type;
    while (1) {
	if (type_1 == LAST) {
	    if (line_ce_1(atom_data, &type_1, aile, progress)) {
		break;
	    }
	} else {
	    if (type_1 == LOCK) {
		if (1) {
		    break;
		}
	    } else {
		if (type_1 == PICK) {
		    if (1) {
			break;
		    }
		} else {
		    if (type_1 == THIS) {
			if (line_ce_0(atom_data, aile, &type_1, progress)) {
			    break;
			}
		    } else {
			break;
		    }
		}
	    }
	}
    }
    if ((1 << type_1) & CONSTANT) {
	struct e4_odb1_type *odb1_data;

	odb1_data = atom_data->odb1;
	while (odb1_data) {
	    const struct e4_odbx_type *odbx_data;

	    odbx_data = odb1_data->odbx_data;
	    if (odbx_data->flags & KEEP_CALL) {
		break;
	    } else {
		int type_2;

		type_2 = odbx_data->type;
		if (type_2 == TEXT) {
		    break;
		} else {
		    struct e4_post_type data[1];

		    status = atom_data->load(atom_data, data + 0, NULL);
		    if (status) {
			break;
		    } else {
			struct e4_post_type post;
			void *bias[1], *transfer;

			bias[0] = &data[0].data;
			transfer = &post.data;
			status = odbx_data->odbx(transfer, bias);
			if (status) {
			    break;
			} else {
			    struct e4_odb1_type *free_odb1;

			    if (type_1 == TEXT) {
				FIX_TEXT(aile, atom_data);
			    }
			    free_odb1 = odb1_data;
			    odb1_data = odb1_data->odb1_data;
			    atom_data->odb1 = odb1_data;
			    E_FREE(aile, free_odb1);
			    SET_ATOM(atom_data, type_2, transfer);

			    *progress |= STAGE_0;
			}
		    }
		}
	    }
	}
    }

    if (status) {
    } else {
	status = line_cf_0(hack_data, aile, progress);
    }

    return status;
}


static int
line_cf_2(LINE______ARGS_1)
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned count, flow = 0, i;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    i = count;
    while (i != 1) {
	int type_1;
	unsigned deck = 1;

	type_1 = atom_data->type;
	if (!((1 << type_1) & CONSTANT)) {
	} else if (atom_data->odb1) {
	} else {
	    struct e4_odb2_type *odb2_swap;

	    odb2_swap = atom_data->odb2._2nd;
	    if (!odb2_swap) {
		struct e4_odb2_type *odb2_data;
		const struct e4_odbf_type *odbf_data;
		const struct e4_odbx_type *odbx_data;
		unsigned flags, swap_advance;

		_x1f4_e4_find_ce_0(atom_data, &swap_advance, &odb2_swap);
		odb2_data = odb2_swap;
		odbx_data = odb2_data->odbx_data;
		flags = odbx_data->flags;
		odbf_data = odbx_data->extension1;
		if (flags & E1ST_LINK) {
		    flags = odbf_data->bits1;
		} else {
		    flags = 0;
		}
		if (flags & MXCA_LIST) {
		    int success;
		    struct e4_atom_type *miss_atom;
		    const struct e4_odbA_type *odbA_data;
		    const struct e4_odbl_type *miss_odbl, *odbl_data;
		    const struct e4_odbt_type *odbt_data = NULL;
		    unsigned atom_advance, sign_transform;

		    odbA_data = odbf_data->odbA_data;
		    odbl_data = odbA_data->odbl_data;

		    sign_transform = odbA_data->flags & SIGN_TRANSFORM;
		    if (sign_transform) {
			const struct e4_odbz_type *odbz_data;

			odbz_data = odbA_data->odbz_data;
			odbt_data = odbz_data->odbt_data;
		    }

		    atom_advance = swap_advance;

		    while (1) {
			success = _x1f4_e4_find_ce_1
			    (atom_data, atom_advance, odbl_data, odb2_data,
			     &miss_atom, &miss_odbl);
			if (success) {
			    unsigned this_transform = 0;

			    odb2_data = odb2_data->odb2_data;
			    if (odb2_data) {
				this_transform = sign_transform;
			    } else {
				if (atom_advance + 1 == i) {
				    break;
				} else {
				    unsigned post_advance;

				    _x1f4_e4_find_ce_0
					(atom_data + atom_advance,
					 &post_advance, &odb2_data);
				    atom_advance += post_advance;
				}
			    }
			    if (_x1f4_e4_find_ce_2
				(odbl_data, odb2_data, NULL)) {
				break;
			    } else {
				if (this_transform) {
				    const struct e4_odbv_type *odbv_data;
				    const struct e4_odbx_type *odbx_data;

				    odbv_data = odbt_data->odbv_data;
				    odbx_data = odb2_data->odbx_data;
				    while (odbx_data != odbv_data->odbx_data) {
					odbv_data++;
				    }
				    odbt_data += odbv_data->shift;
				}
			    }
			} else {
			    break;
			}
		    }
		    if (success) {
		    } else {
			if (sign_transform) {
			    sign_cf_2
				(miss_atom, odb2_data, odbt_data, &miss_odbl);
			} else {
			    if (miss_odbl) {
			    } else {
				/*
				 * never reached?
				 */
				miss_odbl = odbA_data->odbl_miss;
			    }
			}
			status = miss_cf_2
			    (atom_data, miss_atom, miss_odbl, aile);
			if (status) {
			    break;
			} else {
			    struct e4_odb2_type *free_odb2, *link_odb2;
			    unsigned shift;

			    free_odb2 = miss_atom->odb2._2nd;
			    deck = 0;
			    flow++;
			    shift = i - (miss_atom - atom_data) - 1;
			    if (shift) {
				memmove(miss_atom, miss_atom + 1,
					shift * sizeof(struct e4_atom_type));
			    }
			    miss_atom--;
			    odb2_data = miss_atom->odb2._2nd;
			    if (odb2_data) {
				link_odb2 = odb2_data->odb2_data;
				while (link_odb2) {
				    odb2_data = link_odb2;
				    link_odb2 = odb2_data->odb2_data;
				}
				odb2_data->odb2_data = free_odb2->odb2_data;
			    } else {
				miss_atom->odb2._2nd = free_odb2->odb2_data;
			    }
			    if (miss_odbl->flags & TRANSFORM_PRIMARY) {
				miss_cf_0
				    (odb2_swap, miss_odbl, odbA_data->oddp);
			    }
			    if (miss_odbl->flags & TRANSFORM_LINKAGE) {
				miss_cf_1(free_odb2, miss_atom, miss_odbl);
			    }
			    E_FREE(aile, free_odb2);

			    flags = 0;

			    *progress |= STAGE_0;
			}
		    }
		}
		odb2_data = odb2_swap;
		if (flags & MXCC_LIST) {
		    int success;
		    struct e4_atom_type *miss_atom;
		    const struct e4_odbC_type *odbC_data;
		    const struct e4_odbl_type *miss_odbl, *odbl_data;
		    const struct e4_odbt_type *odbt_data = NULL;
		    unsigned atom_advance, sign_transform;

		    odbC_data = odbf_data->odbC_data;
		    odbl_data = odbC_data->odbl_data;

		    sign_transform = odbC_data->flags & SIGN_TRANSFORM;
		    if (sign_transform) {
			const struct e4_odbz_type *odbz_data;

			odbz_data = odbC_data->odbz_data;
			odbt_data = odbz_data->odbt_data;
		    }

		    atom_advance = swap_advance;

		    while (1) {
			success = _x1f4_e4_find_ce_3
			    (atom_data, atom_advance, odbl_data, odb2_data,
			     &miss_atom, &miss_odbl);
			if (success) {
			    unsigned this_transform = 0;

			    odb2_data = odb2_data->odb2_data;
			    if (odb2_data) {
				this_transform = sign_transform;
			    } else {
				if (atom_advance + 1 == i) {
				    break;
				} else {
				    unsigned post_advance;

				    _x1f4_e4_find_ce_0
					(atom_data + atom_advance,
					 &post_advance, &odb2_data);
				    atom_advance += post_advance;
				}
			    }
			    if (_x1f4_e4_find_ce_2
				(odbl_data, odb2_data, NULL)) {
				break;
			    } else {
				if (this_transform) {
				    const struct e4_odbv_type *odbv_data;
				    const struct e4_odbx_type *odbx_data;

				    odbv_data = odbt_data->odbv_data;
				    odbx_data = odb2_data->odbx_data;
				    while (odbx_data != odbv_data->odbx_data) {
					odbv_data++;
				    }
				    odbt_data += odbv_data->shift;
				}
			    }
			} else {
			    break;
			}
		    }
		    if (success) {
		    } else {
			const struct e4_odbl_type *miss_odbi;

			if (sign_transform) {
			    sign_cf_1
				(miss_atom, odb2_data, odbt_data,
				 odbC_data->odbz_data, &miss_odbl, &miss_odbi);
			} else {
			    if (miss_odbl) {
			    } else {
				/*
				 * never reached?
				 */
				miss_odbl = odbC_data->odbl_miss;
			    }
			}
			status = miss_cf_2
			    (atom_data, miss_atom, miss_odbl, aile);
			if (status) {
			    break;
			} else {
			    struct e4_odb2_type *free_odb2, *link_odb2,
				*next_odb2;
			    unsigned shift;

			    _x1f4_e4_find_ce_0
				(miss_atom, &swap_advance, &next_odb2);

			    deck = 0;
			    flow++;
			    shift = i - (miss_atom - atom_data) - 1;
			    if (shift) {
				memmove(miss_atom, miss_atom + 1,
					shift * sizeof(struct e4_atom_type));
			    }
			    miss_atom--;
			    miss_atom += swap_advance;
			    odb2_data = miss_atom->odb2._2nd;
			    link_odb2 = odb2_data->odb2_data;
			    if (next_odb2 == odb2_data) {
				free_odb2 = odb2_data;
				miss_atom->odb2._2nd = link_odb2;
			    } else {
				while (link_odb2 != next_odb2) {
				    odb2_data = link_odb2;
				    link_odb2 = odb2_data->odb2_data;
				}
				free_odb2 = link_odb2;
				odb2_data->odb2_data = free_odb2->odb2_data;
			    }
			    if (miss_odbl->flags & TRANSFORM_PRIMARY) {
				miss_cf_0
				    (odb2_swap, miss_odbl, odbC_data->oddp);
			    }
			    if (miss_odbl->flags & TRANSFORM_LINKAGE) {
				if (sign_transform) {
				    miss_cf_1(free_odb2, miss_atom, miss_odbi);
				} else {
				    miss_cf_1(free_odb2, miss_atom, miss_odbl);
				}
			    }
			    E_FREE(aile, free_odb2);

			    flags = 0;

			    *progress |= STAGE_0;
			}
		    }
		}
	    } else {
		struct e4_odb2_type *odb2_data;
		const struct e4_odbf_type *odbf_data;
		const struct e4_odbx_type *odbx_data;
		unsigned flags;

		odb2_data = odb2_swap;
		odbx_data = odb2_data->odbx_data;
		flags = odbx_data->flags;
		odbf_data = odbx_data->extension1;
		if (flags & E1ST_LINK) {
		    flags = odbf_data->bits1;
		} else {
		    flags = 0;
		}
		if (flags & MXAC_LIST) {
		    int success = 1;
		    struct e4_atom_type *miss_atom;
		    const struct e4_odbc_type *odbc_data;
		    const struct e4_odbl_type *miss_odbl, *odbl_data;
		    const struct e4_odbt_type *odbt_data = NULL;
		    unsigned atom_advance, sign_transform;

		    odbc_data = odbf_data->odbc_data;
		    odbl_data = odbc_data->odbl_data;

		    sign_transform = odbc_data->flags & SIGN_TRANSFORM;
		    if (sign_transform) {
			const struct e4_odbz_type *odbz_data;

			odbz_data = odbc_data->odbz_data;
			odbt_data = odbz_data->odbt_data;
		    }

		    atom_advance = 0;

		    while (1) {
			{
			    int skip = 0;
			    unsigned this_transform = 0;

			    odb2_data = odb2_data->odb2_data;
			    if (odb2_data) {
				this_transform = sign_transform;
				if (atom_advance) {
				} else {
				    if (i == 1) {
					break;
				    } else {
					skip = 1;
				    }
				}
			    } else {
				if (atom_advance + 1 == i) {
				    break;
				} else {
				    unsigned post_advance;

				    _x1f4_e4_find_ce_0
					(atom_data + atom_advance,
					 &post_advance, &odb2_data);
				    atom_advance += post_advance;
				}
			    }
			    if (_x1f4_e4_find_ce_2
				(odbl_data, odb2_data, NULL)) {
				break;
			    } else {
				if (this_transform) {
				    const struct e4_odbv_type *odbv_data;
				    const struct e4_odbx_type *odbx_data;

				    odbv_data = odbt_data->odbv_data;
				    odbx_data = odb2_data->odbx_data;
				    while (odbx_data != odbv_data->odbx_data) {
					odbv_data++;
				    }
				    odbt_data += odbv_data->shift;
				}
				if (skip) {
				    continue;
				}
			    }
			}
			success = _x1f4_e4_find_ce_3
			    (atom_data, atom_advance, odbl_data, odb2_data,
			     &miss_atom, &miss_odbl);
			if (success) {
			} else {
			    break;
			}
		    }
		    if (success) {
		    } else {
			const struct e4_odbl_type *miss_odbi;

			if (sign_transform) {
			    sign_cf_1
				(miss_atom, odb2_data, odbt_data,
				 odbc_data->odbz_data, &miss_odbl, &miss_odbi);
			} else {
			    if (miss_odbl) {
			    } else {
				/*
				 * never reached?
				 */
				miss_odbl = odbc_data->odbl_miss;
			    }
			}
			status = miss_cf_2
			    (atom_data, miss_atom, miss_odbl, aile);
			if (status) {
			    break;
			} else {
			    struct e4_odb2_type *free_odb2, *link_odb2,
				*next_odb2;
			    unsigned shift, swap_advance;

			    _x1f4_e4_find_ce_0
				(miss_atom, &swap_advance, &next_odb2);

			    deck = 0;
			    flow++;
			    shift = i - (miss_atom - atom_data) - 1;
			    if (shift) {
				memmove(miss_atom, miss_atom + 1,
					shift * sizeof(struct e4_atom_type));
			    }
			    miss_atom--;
			    miss_atom += swap_advance;
			    odb2_data = miss_atom->odb2._2nd;
			    link_odb2 = odb2_data->odb2_data;
			    if (next_odb2 == odb2_data) {
				free_odb2 = odb2_data;
				miss_atom->odb2._2nd = link_odb2;
			    } else {
				while (link_odb2 != next_odb2) {
				    odb2_data = link_odb2;
				    link_odb2 = odb2_data->odb2_data;
				}
				free_odb2 = link_odb2;
				odb2_data->odb2_data = free_odb2->odb2_data;
			    }
			    if (miss_odbl->flags & TRANSFORM_PRIMARY) {
				miss_cf_0
				    (odb2_swap, miss_odbl, odbc_data->oddp);
			    }
			    if (miss_odbl->flags & TRANSFORM_LINKAGE) {
				if (sign_transform) {
				    miss_cf_1(free_odb2, miss_atom, miss_odbi);
				} else {
				    miss_cf_1(free_odb2, miss_atom, miss_odbl);
				}
			    }
			    E_FREE(aile, free_odb2);

			    flags = 0;

			    *progress |= STAGE_0;
			}
		    }
		}
		odb2_data = odb2_swap;
		if (flags & MXAA_LIST) {
		    int success = 1;
		    struct e4_atom_type *miss_atom;
		    const struct e4_odba_type *odba_data;
		    const struct e4_odbl_type *miss_odbl, *odbl_data;
		    const struct e4_odbt_type *odbt_data = NULL;
		    unsigned atom_advance, sign_transform;

		    odba_data = odbf_data->odba_data;
		    odbl_data = odba_data->odbl_data;

		    sign_transform = odba_data->flags & SIGN_TRANSFORM;
		    if (sign_transform) {
			const struct e4_odbz_type *odbz_data;

			odbz_data = odba_data->odbz_data;
			odbt_data = odbz_data->odbt_data;
		    }

		    atom_advance = 0;

		    while (1) {
			{
			    int skip = 0;
			    unsigned this_transform = 0;

			    odb2_data = odb2_data->odb2_data;
			    if (odb2_data) {
				this_transform = sign_transform;
				if (atom_advance) {
				} else {
				    if (i == 1) {
					break;
				    } else {
					skip = 1;
				    }
				}
			    } else {
				if (atom_advance + 1 == i) {
				    break;
				} else {
				    unsigned post_advance;

				    _x1f4_e4_find_ce_0
					(atom_data + atom_advance,
					 &post_advance, &odb2_data);
				    atom_advance += post_advance;
				}
			    }
			    if (_x1f4_e4_find_ce_2
				(odbl_data, odb2_data, NULL)) {
				break;
			    } else {
				if (this_transform) {
				    const struct e4_odbv_type *odbv_data;
				    const struct e4_odbx_type *odbx_data;

				    odbv_data = odbt_data->odbv_data;
				    odbx_data = odb2_data->odbx_data;
				    while (odbx_data != odbv_data->odbx_data) {
					odbv_data++;
				    }
				    odbt_data += odbv_data->shift;
				}
				if (skip) {
				    continue;
				}
			    }
			}
			success = _x1f4_e4_find_ce_1
			    (atom_data, atom_advance, odbl_data, odb2_data,
			     &miss_atom, &miss_odbl);
			if (success) {
			} else {
			    break;
			}
		    }
		    if (success) {
		    } else {
			if (sign_transform) {
			    sign_cf_2
				(miss_atom, odb2_data, odbt_data, &miss_odbl);
			} else {
			    if (miss_odbl) {
			    } else {
				/*
				 * never reached?
				 */
				miss_odbl = odba_data->odbl_miss;
			    }
			}
			status = miss_cf_2
			    (atom_data, miss_atom, miss_odbl, aile);
			if (status) {
			    break;
			} else {
			    struct e4_odb2_type *free_odb2, *link_odb2;
			    unsigned shift;

			    free_odb2 = miss_atom->odb2._2nd;
			    deck = 0;
			    flow++;
			    shift = i - (miss_atom - atom_data) - 1;
			    if (shift) {
				memmove(miss_atom, miss_atom + 1,
					shift * sizeof(struct e4_atom_type));
			    }
			    miss_atom--;
			    odb2_data = miss_atom->odb2._2nd;
			    if (odb2_data) {
				link_odb2 = odb2_data->odb2_data;
				while (link_odb2) {
				    odb2_data = link_odb2;
				    link_odb2 = odb2_data->odb2_data;
				}
				odb2_data->odb2_data = free_odb2->odb2_data;
			    } else {
				miss_atom->odb2._2nd = free_odb2->odb2_data;
			    }
			    if (miss_odbl->flags & TRANSFORM_PRIMARY) {
				miss_cf_0
				    (odb2_swap, miss_odbl, odba_data->oddp);
			    }
			    if (miss_odbl->flags & TRANSFORM_LINKAGE) {
				miss_cf_1(free_odb2, miss_atom, miss_odbl);
			    }
			    E_FREE(aile, free_odb2);

			    flags = 0;

			    *progress |= STAGE_0;
			}
		    }
		}
	    }
	}

	i--;
	atom_data += deck;
	if (flow + 1 == count) {
	    break;
	}
    }

    if (flow) {
	count -= flow;
	E_MODE(aile, &hack_data->atoms, count * sizeof(struct e4_atom_type));
	hack_data->count = count;
    }

    return status;
}


static int
line_cf_3(LINE______ARGS_1)
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned count, flow = 0, i;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    i = count;
    while (i != 1) {
	int type_1;
	unsigned deck = 1;

	type_1 = atom_data->type;
	if (!((1 << type_1) & CONSTANT)) {
	} else if (atom_data->odb1) {
	} else {
	    struct e4_odb2_type *odb2_swap;

	    odb2_swap = atom_data->odb2._2nd;
	    if (!odb2_swap) {
		struct e4_odb2_type *odb2_data;
		const struct e4_odbf_type *odbf_data;
		const struct e4_odbx_type *odbx_data;
		unsigned flags, swap_advance;

		_x1f4_e4_find_ce_0(atom_data, &swap_advance, &odb2_swap);
		odb2_data = odb2_swap;
		odbx_data = odb2_data->odbx_data;
		flags = odbx_data->flags;
		odbf_data = odbx_data->extension1;
		if (flags & E1ST_LINK) {
		    flags = odbf_data->bits1;
		} else {
		    flags = 0;
		}
		if (flags & MXCS_LIST) {
		    int success = 1;
		    struct e4_atom_type *miss_atom;
		    const struct e4_odbS_type *odbS_data;
		    const struct e4_odbl_type *miss_odbl = NULL, *odbl_data;
		    unsigned atom_advance;

		    odbS_data = odbf_data->odbS_data;
		    odbl_data = odbS_data->odbl_data;

		    atom_advance = swap_advance;

		    while (1) {
			miss_atom = atom_data + atom_advance;
			if ((1 << miss_atom->type) & CONSTANT) {
			    if (miss_atom->odb1) {
			    } else {
				if (miss_atom->odb2._2nd == odb2_data) {
				    success = 0;
				}
			    }
			}
			if (success) {
			    odb2_data = odb2_data->odb2_data;
			    if (odb2_data) {
			    } else {
				if (atom_advance + 1 == i) {
				    break;
				} else {
				    unsigned post_advance;

				    _x1f4_e4_find_ce_0
					(atom_data + atom_advance,
					 &post_advance, &odb2_data);
				    atom_advance += post_advance;
				}
			    }
			    if (_x1f4_e4_find_ce_2
				(odbl_data, odb2_data, &miss_odbl)) {
				break;
			    }
			} else {
			    break;
			}
		    }
		    if (success) {
		    } else {
			if (miss_odbl) {
			} else {
			    miss_odbl = odbS_data->odbl_miss;
			}
			status = miss_cf_2
			    (atom_data, miss_atom, miss_odbl, aile);
			if (status) {
			    break;
			} else {
			    struct e4_odb2_type *free_odb2, *link_odb2;
			    unsigned shift;

			    free_odb2 = miss_atom->odb2._2nd;
			    deck = 0;
			    flow++;
			    shift = i - (miss_atom - atom_data) - 1;
			    if (shift) {
				memmove(miss_atom, miss_atom + 1,
					shift * sizeof(struct e4_atom_type));
			    }
			    miss_atom--;
			    odb2_data = miss_atom->odb2._2nd;
			    if (odb2_data) {
				link_odb2 = odb2_data->odb2_data;
				while (link_odb2) {
				    odb2_data = link_odb2;
				    link_odb2 = odb2_data->odb2_data;
				}
				odb2_data->odb2_data = free_odb2->odb2_data;
			    } else {
				miss_atom->odb2._2nd = free_odb2->odb2_data;
			    }
			    if (miss_odbl->flags & TRANSFORM_PRIMARY) {
				miss_cf_0(odb2_swap, miss_odbl, NULL);
			    }
			    if (miss_odbl->flags & TRANSFORM_LINKAGE) {
				miss_cf_1(free_odb2, miss_atom, miss_odbl);
			    }
			    E_FREE(aile, free_odb2);

			    *progress |= STAGE_0;
			}
		    }
		}
	    } else {
		struct e4_odb2_type *odb2_data;
		const struct e4_odbf_type *odbf_data;
		const struct e4_odbx_type *odbx_data;
		unsigned flags;

		odb2_data = odb2_swap;
		odbx_data = odb2_data->odbx_data;
		flags = odbx_data->flags;
		odbf_data = odbx_data->extension1;
		if (flags & E1ST_LINK) {
		    flags = odbf_data->bits1;
		} else {
		    flags = 0;
		}
		if (flags & MXAS_LIST) {
		    int success = 1;
		    struct e4_atom_type *miss_atom = NULL;
		    const struct e4_odbl_type *miss_odbl = NULL, *odbl_data;
		    const struct e4_odbs_type *odbs_data;
		    unsigned atom_advance;

		    odbs_data = odbf_data->odbs_data;
		    odbl_data = odbs_data->odbl_data;

		    atom_advance = 0;

		    while (1) {
			{
			    odb2_data = odb2_data->odb2_data;
			    if (odb2_data) {
				if (atom_advance) {
				} else {
				    if (i == 1) {
					break;
				    } else {
					continue;
				    }
				}
			    } else {
				if (atom_advance + 1 == i) {
				    break;
				} else {
				    unsigned post_advance;

				    _x1f4_e4_find_ce_0
					(atom_data + atom_advance,
					 &post_advance, &odb2_data);
				    atom_advance += post_advance;
				}
			    }
			    if (_x1f4_e4_find_ce_2
				(odbl_data, odb2_data, &miss_odbl)) {
				break;
			    }
			}
			miss_atom = atom_data + atom_advance;
			if ((1 << miss_atom->type) & CONSTANT) {
			    if (miss_atom->odb1) {
			    } else {
				if (miss_atom->odb2._2nd == odb2_data) {
				    success = 0;
				}
			    }
			}
			if (success) {
			} else {
			    break;
			}
		    }
		    if (success) {
		    } else {
			if (miss_odbl) {
			} else {
			    miss_odbl = odbs_data->odbl_miss;
			}
			status = miss_cf_2
			    (atom_data, miss_atom, miss_odbl, aile);
			if (status) {
			    break;
			} else {
			    struct e4_odb2_type *free_odb2, *link_odb2;
			    unsigned shift;

			    free_odb2 = miss_atom->odb2._2nd;
			    deck = 0;
			    flow++;
			    shift = i - (miss_atom - atom_data) - 1;
			    if (shift) {
				memmove(miss_atom, miss_atom + 1,
					shift * sizeof(struct e4_atom_type));
			    }
			    miss_atom--;
			    odb2_data = miss_atom->odb2._2nd;
			    if (odb2_data) {
				link_odb2 = odb2_data->odb2_data;
				while (link_odb2) {
				    odb2_data = link_odb2;
				    link_odb2 = odb2_data->odb2_data;
				}
				odb2_data->odb2_data = free_odb2->odb2_data;
			    } else {
				miss_atom->odb2._2nd = free_odb2->odb2_data;
			    }
			    if (miss_odbl->flags & TRANSFORM_PRIMARY) {
				miss_cf_0(odb2_swap, miss_odbl, NULL);
			    }
			    if (miss_odbl->flags & TRANSFORM_LINKAGE) {
				miss_cf_1(free_odb2, miss_atom, miss_odbl);
			    }
			    E_FREE(aile, free_odb2);

			    *progress |= STAGE_0;
			}
		    }
		}
	    }
	}

	i--;
	atom_data += deck;
	if (flow + 1 == count) {
	    break;
	}
    }

    if (flow) {
	count -= flow;
	E_MODE(aile, &hack_data->atoms, count * sizeof(struct e4_atom_type));
	hack_data->count = count;
    }

    return status;
}


static int
line_cf_4(LINE______ARGS_1)
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned count, flow = 0, i;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    i = count;
    if (i == 1) {
	i = 0;
    }
    while (i) {
	unsigned deck = 1;

	if (atom_data->odb1) {
	} else {
	    int type_1;

	    type_1 = atom_data->type;
	    if ((1 << type_1) & CONSTANT) {
		struct e4_odb2_type *odb2_swap;

		odb2_swap = atom_data->odb2._2nd;
		if (!odb2_swap) {
		    struct e4_odb2_type *odb2_data;
		    const struct e4_odbf_type *odbf_data;
		    const struct e4_odbx_type *odbx_data;
		    unsigned flags, swap_advance;

		    _x1f4_e4_find_ce_0(atom_data, &swap_advance, &odb2_swap);
		    odb2_data = odb2_swap;
		    odbx_data = odb2_data->odbx_data;
		    flags = odbx_data->flags;
		    odbf_data = odbx_data->extension1;
		    if (flags & E1ST_LINK) {
			flags = odbf_data->bits1;
		    } else {
			flags = 0;
		    }
		    if (flags & LEFT_SKIP) {
			int success;
			struct e4_odb2_type *odb2_head = NULL;
			const struct e4_sdbl_type *sdbl_data;
			unsigned flags;

			sdbl_data = odbf_data->sdbl_data;

			flags = sdbl_data->flags;

			success = test_atom(atom_data, 0, sdbl_data->data);
			if (success) {
			} else {
			    if (flags & SDBL_TRANSFORM_LINKAGE) {
				success = test_head
				    (atom_data, sdbl_data->edbx, odb2_data, i,
				     &odb2_head);
			    }
			}
			if (success) {
			} else {
			    {
				struct e4_atom_type *miss_atom;
				struct e4_odb2_type *free_odb2, *link_odb2;
				unsigned shift;

				free_odb2 = odb2_swap;
				deck = 0;
				flow++;
				shift = i - 1;
				if (type_1 == TEXT) {
				    FIX_TEXT(aile, atom_data);
				}
				if (shift) {
				    memmove(atom_data, atom_data + 1,
					    shift
					    * sizeof(struct e4_atom_type));
				}
				miss_atom = atom_data + swap_advance;
				miss_atom--;
				odb2_data = miss_atom->odb2._2nd;
				link_odb2 = odb2_data->odb2_data;
				if (free_odb2 == odb2_data) {
				    miss_atom->odb2._2nd = link_odb2;
				} else {
				    while (link_odb2 != free_odb2) {
					odb2_data = link_odb2;
					link_odb2 = odb2_data->odb2_data;
				    }
				    odb2_data->odb2_data =
					free_odb2->odb2_data;
				}
				if (flags & SDBL_TRANSFORM_LINKAGE) {
				    sign_head(free_odb2, miss_atom,
					      sdbl_data->edbx, odb2_head);
				}
				E_FREE(aile, free_odb2);

				*progress |= STAGE_0;
				if (flow + 1 == count) {
				    *progress |= STAGE_1;
				}
			    }
			}
		    }
		} else {
		    struct e4_odb2_type *odb2_data;
		    const struct e4_odbf_type *odbf_data;
		    const struct e4_odbx_type *odbx_data;
		    unsigned flags;

		    odb2_data = odb2_swap;
		    odbx_data = odb2_data->odbx_data;
		    flags = odbx_data->flags;
		    odbf_data = odbx_data->extension1;
		    if (flags & E1ST_LINK) {
			flags = odbf_data->bits1;
		    } else {
			flags = 0;
		    }
		    if (flags & POST_SKIP) {
			int success;
			const struct e4_sdbo_type *sdbo_data;

			sdbo_data = odbf_data->sdbo_data;

			success = test_atom(atom_data, 0, sdbo_data->data);
			if (success) {
			} else {
			    {
				struct e4_odb2_type *free_odb2, *link_odb2;
				unsigned shift;

				free_odb2 = odb2_swap;
				deck = 0;
				flow++;
				shift = i - 1;
				if (type_1 == TEXT) {
				    FIX_TEXT(aile, atom_data);
				}
				if (shift) {
				    memmove(atom_data, atom_data + 1,
					    shift
					    * sizeof(struct e4_atom_type));
				}
				atom_data--;
				odb2_data = atom_data->odb2._2nd;
				if (odb2_data) {
				    link_odb2 = odb2_data->odb2_data;
				    while (link_odb2) {
					odb2_data = link_odb2;
					link_odb2 = odb2_data->odb2_data;
				    }
				    odb2_data->odb2_data =
					free_odb2->odb2_data;
				} else {
				    atom_data->odb2._2nd =
					free_odb2->odb2_data;
				}
				atom_data++;
				E_FREE(aile, free_odb2);

				*progress |= STAGE_0;
				if (flow + 1 == count) {
				    *progress |= STAGE_1;
				}
			    }
			}
		    }
		}
	    }
	}

	i--;
	atom_data += deck;
	if (flow + 1 == count) {
	    break;
	}
    }

    if (flow) {
	count -= flow;
	E_MODE(aile, &hack_data->atoms, count * sizeof(struct e4_atom_type));
	hack_data->count = count;
    }

    return status;
}


static int
line_cf_5(LINE______ARGS_1)
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned count, flow = 0, i;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    i = count;
    if (i == 1) {
	i = 0;
    }
    while (i) {
	unsigned deck = 1, less = 1;

	if (atom_data->odb1) {
	} else {
	    int type_1;

	    type_1 = atom_data->type;
	    if ((1 << type_1) & CONSTANT) {
		struct e4_odb2_type *odb2_swap;

		odb2_swap = atom_data->odb2._2nd;
		if (!odb2_swap) {
		    struct e4_odb2_type *odb2_data;
		    const struct e4_odbf_type *odbf_data;
		    const struct e4_odbx_type *odbx_data;
		    unsigned flags, swap_advance;

		    _x1f4_e4_find_ce_0(atom_data, &swap_advance, &odb2_swap);
		    odb2_data = odb2_swap;
		    odbx_data = odb2_data->odbx_data;
		    flags = odbx_data->flags;
		    odbf_data = odbx_data->extension1;
		    if (flags & E1ST_LINK) {
			flags = odbf_data->bits1;
		    } else {
			flags = 0;
		    }
		    if (flags & LEFT_KILL) {
			int success;
			const struct e4_rdbl_type *rdbl_data;

			rdbl_data = odbf_data->rdbl_data;

			success = test_atom
			    (atom_data, rdbl_data->flags & RDBX_LESS_NONE,
			     rdbl_data->data);
			if (success) {
			} else {
			    success = _x1f4_e4_find_ce_5
				(atom_data + 1, swap_advance);
			    if (success) {
			    } else {
				if (rdbl_data->flags & RDBX_MISS_TYPE) {
				    type_atom(atom_data, odbx_data->type,
					      rdbl_data->miss);
				}
				{
				    struct e4_atom_type *miss_atom;
				    struct e4_odb2_type *free_odb2;
				    unsigned shift;

				    miss_atom = atom_data + swap_advance;
				    atom_data->odb2._2nd =
					odb2_data->odb2_data;
				    free_odb2 = odb2_data;
				    odb2_data = miss_atom->odb2._2nd;
				    miss_atom->odb2._2nd = NULL;
				    deck = 0;
				    shift = i - 1 - swap_advance;
				    i -= swap_advance - 1;
				    flow += swap_advance;
				    {
					unsigned i;

					i = swap_advance;
					for (; i; i--) {
					    atom_data++;
					    _x1f4_e4_free_odbx
						(atom_data, aile);
					    _x1f4_e4_free_atom
						(atom_data, aile);
					}
					atom_data -= swap_advance;
				    }
				    if (shift) {
					atom_data++;
					memmove
					    (atom_data,
					     atom_data + swap_advance,
					     shift
					     * sizeof(struct e4_atom_type));
					atom_data--;
				    }
				    while (odb2_data != free_odb2) {
					struct e4_odb2_type *link_odb2;

					link_odb2 = odb2_data;
					odb2_data = odb2_data->odb2_data;
					E_FREE(aile, link_odb2);
				    }
				    E_FREE(aile, free_odb2);

				    *progress |= STAGE_1;
				}
			    }
			}
		    }
		} else {
		    struct e4_odb2_type *odb2_data;
		    const struct e4_odbf_type *odbf_data;
		    const struct e4_odbx_type *odbx_data;
		    unsigned flags;

		    odb2_data = odb2_swap;
		    odbx_data = odb2_data->odbx_data;
		    flags = odbx_data->flags;
		    odbf_data = odbx_data->extension1;
		    if (flags & E1ST_LINK) {
			flags = odbf_data->bits1;
		    } else {
			flags = 0;
		    }
		    if (flags & POST_KILL) {
			int success;
			const struct e4_rdbo_type *rdbo_data;

			rdbo_data = odbf_data->rdbo_data;

			success = test_atom
			    (atom_data, rdbo_data->flags & RDBX_LESS_NONE,
			     rdbo_data->data);
			if (success) {
			} else {
			    unsigned swap_advance;

			    _x1f4_e4_find_ce_4(atom_data, &swap_advance);
			    success = _x1f4_e4_find_ce_5
				(atom_data - swap_advance, swap_advance);
			    if (success) {
			    } else {
				if (rdbo_data->flags & RDBX_MISS_TYPE) {
				    type_atom(atom_data, odbx_data->type,
					      rdbo_data->miss);
				}
				{
				    {
					unsigned i;

					i = swap_advance;
					for (; i; i--) {
					    atom_data--;
					    _x1f4_e4_free_odbx
						(atom_data, aile);
					    _x1f4_e4_free_atom
						(atom_data, aile);
					    }
					}
				    deck = 0;
				    less = 0;
				    flow += swap_advance;
				    if (1) {
					memmove
					    (atom_data,
					     atom_data + swap_advance,
					     i * sizeof(struct e4_atom_type));
				    }
				    atom_data->odb2._2nd =
					odb2_data->odb2_data;
				    E_FREE(aile, odb2_data);

				    *progress |= STAGE_1;
				}
			    }
			}
		    }
		}
	    }
	}

	i -= less;
	atom_data += deck;
	if (flow + 1 == count) {
	    break;
	}
    }

    if (flow) {
	count -= flow;
	E_MODE(aile, &hack_data->atoms, count * sizeof(struct e4_atom_type));
	hack_data->count = count;
    }

    return status;
}


static int
line_cf_6(LINE______ARGS_1)
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned count, i;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    i = count;
    while (i) {
	struct e4_odb1_type *odb1_data;

	odb1_data = atom_data->odb1;
	if (odb1_data) {
	    struct e4_odb1_type *last_odb1 = NULL;

	    do {
		int advance = 1;
		const struct e4_odbx_type *odbx_data;
		unsigned flags;

		odbx_data = odb1_data->odbx_data;
		flags = odbx_data->flags;
		if (flags & LOSE_DATA) {
		    struct e4_odb1_type *link_odb1;

		    link_odb1 = odb1_data->odb1_data;
		    E_FREE(aile, odb1_data);
		    odb1_data = link_odb1;
		    advance = 0;
		    if (last_odb1) {
			last_odb1->odb1_data = link_odb1;
		    } else {
			atom_data->odb1 = link_odb1;
		    }

		    flags = 0;

		    *progress |= STAGE_1;
		} else if (flags & KILL_PAIR) {
		    struct e4_odb1_type *link_odb1;

		    link_odb1 = odb1_data->odb1_data;
		    if (link_odb1) {
			if (link_odb1->odbx_data == odbx_data) {
			    struct e4_odb1_type *next_odb1;

			    next_odb1 = link_odb1->odb1_data;
			    E_FREE(aile, link_odb1);
			    E_FREE(aile, odb1_data);
			    odb1_data = next_odb1;
			    advance = 0;
			    if (last_odb1) {
				last_odb1->odb1_data = next_odb1;
			    } else {
				atom_data->odb1 = next_odb1;
			    }

			    flags = 0;

			    *progress |= STAGE_1;
			}
		    }
		} else if (flags & MISS_PAIR) {
		    struct e4_odb1_type *link_odb1;

		    link_odb1 = odb1_data->odb1_data;
		    if (link_odb1) {
			if (link_odb1->odbx_data == odbx_data) {
			    struct e4_odb1_type *next_odb1;

			    next_odb1 = link_odb1->odb1_data;
			    if (next_odb1) {
				if (next_odb1->odbx_data == odbx_data) {
				    E_FREE(aile, link_odb1);
				    E_FREE(aile, odb1_data);
				    odb1_data = next_odb1;
				    advance = 0;
				    if (last_odb1) {
					last_odb1->odb1_data = next_odb1;
				    } else {
					atom_data->odb1 = next_odb1;
				    }

				    flags = 0;

				    *progress |= STAGE_1;
				}
			    }
			}
		    }
		}

		if (advance) {
		    last_odb1 = odb1_data;
		    odb1_data = odb1_data->odb1_data;
		}
	    } while (odb1_data);
	}

	i--;
	atom_data++;
    }

    return status;
}


static int
line_cf_7(LINE______ARGS_1)
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned count, i;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    atom_data++;
    i = count - 1;
    while (i) {
	struct e4_odb2_type *odb2_data;
	unsigned deck = 1;

	odb2_data = atom_data->odb2._2nd;
	if (odb2_data) {
	    const struct e4_odbf_type *odbf_data;
	    const struct e4_odbx_type *odbx_data;
	    unsigned flags;

	    odbx_data = odb2_data->odbx_data;
	    flags = odbx_data->flags;
	    odbf_data = odbx_data->extension1;
	    if (flags & E1ST_LINK) {
		flags = odbf_data->bits1;
	    } else {
		flags = 0;
	    }
	    if (flags & POST_FLOW) {
		struct e4_odb1_type *odb1_data;

		odb1_data = atom_data->odb1;
		if (odb1_data) {
		    struct e4_odb1_type *odb1_link;
		    const struct e4_tdbe_type *tdbe_data;
		    const struct e4_tdbo_type *tdbo_data;

		    tdbo_data = odbf_data->tdbo_data;
		    tdbe_data = tdbo_data->tdbe_data;

		    odb1_link = odb1_data->odb1_data;
		    if (odb1_link) {
			struct e4_odb1_type *odb1_miss;
			const struct e4_odbx_type *odbx_link, *odbx_miss;

			odb1_miss = odb1_link->odb1_data;
			while (odb1_miss) {
			    odb1_data = odb1_link;
			    odb1_link = odb1_miss;
			    odb1_miss = odb1_link->odb1_data;
			}

			odbx_link = odb1_link->odbx_data;
			odbx_miss = tdbe_data->odbx_data;
			while (odbx_miss) {
			    if (odbx_link == odbx_miss) {
				E_FREE(aile, odb1_link);

				odb1_data->odb1_data = NULL;
				odb2_data->odbx_data = tdbe_data->odbx_miss;

				*progress |= STAGE_1;

				deck = 0;

				break;
			    } else {
				tdbe_data++;
				odbx_miss = tdbe_data->odbx_data;
			    }
			}
		    } else {
			const struct e4_odbx_type *odbx_link, *odbx_miss;

			odbx_link = odb1_data->odbx_data;
			odbx_miss = tdbe_data->odbx_data;
			while (odbx_miss) {
			    if (odbx_link == odbx_miss) {
				E_FREE(aile, odb1_data);

				atom_data->odb1 = NULL;
				odb2_data->odbx_data = tdbe_data->odbx_miss;

				*progress |= STAGE_1;

				deck = 0;

				break;
			    } else {
				tdbe_data++;
				odbx_miss = tdbe_data->odbx_data;
			    }
			}
		    }
		}
	    }
	}

	i -= deck;
	atom_data += deck;
    }

    return status;
}


static int
line_cf_8(LINE______ARGS_1)
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned count, i;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    i = count;
    while (i != 1) {
	int type_1;

	type_1 = atom_data->type;
	if ((1 << type_1) & CONSTANT) {
	} else if (atom_data->odb1) {
	    struct e4_odb1_type *odb1_pick, *odb1_slip;
	    struct e4_odb2_type *odb2_swap;

	    pick_lock(atom_data, &odb1_slip, &odb1_pick);

	    odb2_swap = atom_data->odb2._2nd;
	    if (!odb2_swap) {
		struct e4_odb2_type *odb2_data;
		const struct e4_odbf_type *odbf_data;
		const struct e4_odbx_type *odbx_data;
		unsigned flags, swap_advance;

		_x1f4_e4_find_ce_0(atom_data, &swap_advance, &odb2_swap);
		odb2_data = odb2_swap;
		odbx_data = odb2_data->odbx_data;
		flags = odbx_data->flags;
		odbf_data = odbx_data->extension1;
		if (flags & E1ST_LINK) {
		    flags = odbf_data->bits1;
		} else {
		    flags = 0;
		}
		if (flags & NXCA_LIST) {
		    const struct e4_ndbA_type *ndbA_data;
		    const struct e4_ndbl_type *ndbl_data;

		    ndbA_data = odbf_data->ndbA_data;

		    if (_x1f4_e4_find_ce_6
			(ndbA_data->ndbv_data, odb1_pick->odbx_data,
			 &ndbl_data)) {
			int success;
			struct e4_atom_type *miss_atom = NULL;
			unsigned atom_advance;

			atom_advance = swap_advance;

			while (1) {
			    success = find_ci_1
				(atom_data, atom_advance, ndbl_data, odb2_data,
				 &miss_atom);
			    if (success) {
				odb2_data = odb2_data->odb2_data;
				if (odb2_data) {
				} else {
				    if (atom_advance + 1 == i) {
					break;
				    } else {
					unsigned post_advance;

					_x1f4_e4_find_ce_0
					    (atom_data + atom_advance,
					     &post_advance, &odb2_data);
					atom_advance += post_advance;
				    }
				}
				if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
				    break;
				} else {
				}
			    } else {
				break;
			    }
			}
			if (success) {
			} else {
			    miss_lock
				(atom_data, odb1_slip, odb1_pick, miss_atom);

			    flags = 0;

			    *progress |= STAGE_0;
			}
		    }
		}
		odb2_data = odb2_swap;
		if (flags & NXCC_LIST) {
		    const struct e4_ndbC_type *ndbC_data;
		    const struct e4_ndbl_type *ndbl_data;

		    ndbC_data = odbf_data->ndbC_data;

		    if (_x1f4_e4_find_ce_6
			(ndbC_data->ndbv_data, odb1_pick->odbx_data,
			 &ndbl_data)) {
			int success;
			struct e4_atom_type *miss_atom = NULL;
			unsigned atom_advance;

			atom_advance = swap_advance;

			while (1) {
			    success = find_ci_3
				(atom_data, atom_advance, ndbl_data, odb2_data,
				 &miss_atom);
			    if (success) {
				odb2_data = odb2_data->odb2_data;
				if (odb2_data) {
				} else {
				    if (atom_advance + 1 == i) {
					break;
				    } else {
					unsigned post_advance;

					_x1f4_e4_find_ce_0
					    (atom_data + atom_advance,
					     &post_advance, &odb2_data);
					atom_advance += post_advance;
				    }
				}
				if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
				    break;
				} else {
				}
			    } else {
				break;
			    }
			}
			if (success) {
			} else {
			    miss_lock
				(atom_data, odb1_slip, odb1_pick, miss_atom);

			    flags = 0;

			    *progress |= STAGE_0;
			}
		    }
		}
	    } else {
		struct e4_odb2_type *odb2_data;
		const struct e4_odbf_type *odbf_data;
		const struct e4_odbx_type *odbx_data;
		unsigned flags;

		odb2_data = odb2_swap;
		odbx_data = odb2_data->odbx_data;
		flags = odbx_data->flags;
		odbf_data = odbx_data->extension1;
		if (flags & E1ST_LINK) {
		    flags = odbf_data->bits1;
		} else {
		    flags = 0;
		}
		if (flags & NXAC_LIST) {
		    const struct e4_ndbc_type *ndbc_data;
		    const struct e4_ndbl_type *ndbl_data;

		    ndbc_data = odbf_data->ndbc_data;

		    if (_x1f4_e4_find_ce_6
			(ndbc_data->ndbv_data, odb1_pick->odbx_data,
			 &ndbl_data)) {
			int success = 1;
			struct e4_atom_type *miss_atom;
			unsigned atom_advance;

			atom_advance = 0;

			while (1) {
			    {
				int skip = 0;

				odb2_data = odb2_data->odb2_data;
				if (odb2_data) {
				    if (atom_advance) {
				    } else {
					if (i == 1) {
					    break;
					} else {
					    skip = 1;
					}
				    }
				} else {
				    if (atom_advance + 1 == i) {
					break;
				    } else {
					unsigned post_advance;

					_x1f4_e4_find_ce_0
					    (atom_data + atom_advance,
					     &post_advance, &odb2_data);
					atom_advance += post_advance;
				    }
				}
				if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
				    break;
				} else {
				    if (skip) {
					continue;
				    }
				}
			    }
			    success = find_ci_3
				(atom_data, atom_advance, ndbl_data, odb2_data,
				 &miss_atom);
			    if (success) {
			    } else {
				break;
			    }
			}
			if (success) {
			} else {
			    miss_lock
				(atom_data, odb1_slip, odb1_pick, miss_atom);

			    flags = 0;

			    *progress |= STAGE_0;
			}
		    }
		}
		odb2_data = odb2_swap;
		if (flags & NXAA_LIST) {
		    const struct e4_ndba_type *ndba_data;
		    const struct e4_ndbl_type *ndbl_data;

		    ndba_data = odbf_data->ndba_data;

		    if (_x1f4_e4_find_ce_6
			(ndba_data->ndbv_data, odb1_pick->odbx_data,
			 &ndbl_data)) {
			int success = 1;
			struct e4_atom_type *miss_atom;
			unsigned atom_advance;

			atom_advance = 0;

			while (1) {
			    {
				int skip = 0;

				odb2_data = odb2_data->odb2_data;
				if (odb2_data) {
				    if (atom_advance) {
				    } else {
					if (i == 1) {
					    break;
					} else {
					    skip = 1;
					}
				    }
				} else {
				    if (atom_advance + 1 == i) {
					break;
				    } else {
					unsigned post_advance;

					_x1f4_e4_find_ce_0
					    (atom_data + atom_advance,
					     &post_advance, &odb2_data);
					atom_advance += post_advance;
				    }
				}
				if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
				    break;
				} else {
				    if (skip) {
					continue;
				    }
				}
			    }
			    success = find_ci_1
				(atom_data, atom_advance, ndbl_data, odb2_data,
				 &miss_atom);
			    if (success) {
			    } else {
				break;
			    }
			}
			if (success) {
			} else {
			    miss_lock
				(atom_data, odb1_slip, odb1_pick, miss_atom);

			    flags = 0;

			    *progress |= STAGE_0;
			}
		    }
		}
	    }
	}

	i--;
	atom_data++;
    }

    return status;
}


static int
line_cf_9(LINE______ARGS_1)
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned count, i;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    i = count;
    while (i != 1) {
	int type_1;

	type_1 = atom_data->type;
	if ((1 << type_1) & CONSTANT) {
	    struct e4_odb2_type *odb2_swap;

	    odb2_swap = atom_data->odb2._2nd;
	    if (!odb2_swap) {
		struct e4_odb2_type *odb2_data;
		const struct e4_odbf_type *odbf_data;
		const struct e4_odbx_type *odbx_data;
		unsigned flags, swap_advance;

		_x1f4_e4_find_ce_0(atom_data, &swap_advance, &odb2_swap);
		odb2_data = odb2_swap;
		odbx_data = odb2_data->odbx_data;
		flags = odbx_data->flags;
		odbf_data = odbx_data->extension1;
		if (flags & E1ST_LINK) {
		    flags = odbf_data->bits1;
		} else {
		    flags = 0;
		}
		if (flags & NXCA_LIST) {
		    const struct e4_ndbA_type *ndbA_data;
		    const struct e4_ndbv_type *ndbv_data;
		    const struct e4_odbx_type *odbx_seek;

		    ndbA_data = odbf_data->ndbA_data;
		    ndbv_data = ndbA_data->ndbv_data;

		    odbx_seek = ndbv_data->odbx_data;
		    while (odbx_seek) {
			int success;
			struct e4_atom_type *miss_atom = NULL;
			const struct e4_ndbl_type *ndbl_data;
			struct e4_odb1_type *odb1_pick, *odb1_slip;
			unsigned atom_advance;

			ndbl_data = ndbv_data->ndbl_data;

			atom_advance = swap_advance;

			odb2_data = odb2_swap;

			while (1) {
			    success = find_cl_1
				(atom_data, atom_advance, ndbl_data, odbx_seek,
				 odb2_data, &odb1_slip, &odb1_pick,
				 &miss_atom);
			    if (success) {
				odb2_data = odb2_data->odb2_data;
				if (odb2_data) {
				} else {
				    if (atom_advance + 1 == i) {
					break;
				    } else {
					unsigned post_advance;

					_x1f4_e4_find_ce_0
					    (atom_data + atom_advance,
					     &post_advance, &odb2_data);
					atom_advance += post_advance;
				    }
				}
				if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
				    break;
				} else {
				}
			    } else {
				break;
			    }
			}
			if (success) {
			} else {
			    miss_lock
				(miss_atom, odb1_slip, odb1_pick, atom_data);

			    flags = 0;

			    *progress |= STAGE_0;

			    break;
			}

			ndbv_data++;

			odbx_seek = ndbv_data->odbx_data;
		    }
		}
		odb2_data = odb2_swap;
		if (flags & NXCC_LIST) {
		    const struct e4_ndbC_type *ndbC_data;
		    const struct e4_ndbv_type *ndbv_data;
		    const struct e4_odbf_type *odbf_data;
		    const struct e4_odbx_type *odbx_seek;

		    odbf_data = odbx_data->extension1;
		    ndbC_data = odbf_data->ndbC_data;
		    ndbv_data = ndbC_data->ndbv_data;

		    odbx_seek = ndbv_data->odbx_data;
		    while (odbx_seek) {
			int success;
			struct e4_atom_type *miss_atom = NULL;
			const struct e4_ndbl_type *ndbl_data;
			struct e4_odb1_type *odb1_pick, *odb1_slip;
			unsigned atom_advance;

			ndbl_data = ndbv_data->ndbl_data;

			atom_advance = swap_advance;

			odb2_data = odb2_swap;

			while (1) {
			    success = find_cl_3
				(atom_data, atom_advance, ndbl_data, odbx_seek,
				 odb2_data, &odb1_slip, &odb1_pick,
				 &miss_atom);
			    if (success) {
				odb2_data = odb2_data->odb2_data;
				if (odb2_data) {
				} else {
				    if (atom_advance + 1 == i) {
					break;
				    } else {
					unsigned post_advance;

					_x1f4_e4_find_ce_0
					    (atom_data + atom_advance,
					     &post_advance, &odb2_data);
					atom_advance += post_advance;
				    }
				}
				if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
				    break;
				} else {
				}
			    } else {
				break;
			    }
			}
			if (success) {
			} else {
			    miss_lock
				(miss_atom, odb1_slip, odb1_pick, atom_data);

			    flags = 0;

			    *progress |= STAGE_0;

			    break;
			}

			ndbv_data++;

			odbx_seek = ndbv_data->odbx_data;
		    }
		}
	    } else {
		struct e4_odb2_type *odb2_data;
		const struct e4_odbf_type *odbf_data;
		const struct e4_odbx_type *odbx_data;
		unsigned flags;

		odb2_data = odb2_swap;
		odbx_data = odb2_data->odbx_data;
		flags = odbx_data->flags;
		odbf_data = odbx_data->extension1;
		if (flags & E1ST_LINK) {
		    flags = odbf_data->bits1;
		} else {
		    flags = 0;
		}
		if (flags & NXAC_LIST) {
		    const struct e4_ndbc_type *ndbc_data;
		    const struct e4_ndbv_type *ndbv_data;
		    const struct e4_odbx_type *odbx_seek;

		    ndbc_data = odbf_data->ndbc_data;
		    ndbv_data = ndbc_data->ndbv_data;

		    odbx_seek = ndbv_data->odbx_data;
		    while (odbx_seek) {
			int success = 1;
			struct e4_atom_type *miss_atom;
			const struct e4_ndbl_type *ndbl_data;
			struct e4_odb1_type *odb1_pick, *odb1_slip;
			unsigned atom_advance;

			ndbl_data = ndbv_data->ndbl_data;

			atom_advance = 0;

			odb2_data = odb2_swap;

			while (1) {
			    {
				int skip = 0;

				odb2_data = odb2_data->odb2_data;
				if (odb2_data) {
				    if (atom_advance) {
				    } else {
					if (i == 1) {
					    break;
					} else {
					    skip = 1;
					}
				    }
				} else {
				    if (atom_advance + 1 == i) {
					break;
				    } else {
					unsigned post_advance;

					_x1f4_e4_find_ce_0
					    (atom_data + atom_advance,
					     &post_advance, &odb2_data);
					atom_advance += post_advance;
				    }
				}
				if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
				    break;
				} else {
				    if (skip) {
					continue;
				    }
				}
			    }
			    success = find_cl_3
				(atom_data, atom_advance, ndbl_data, odbx_seek,
				 odb2_data, &odb1_slip, &odb1_pick,
				 &miss_atom);
			    if (success) {
			    } else {
				break;
			    }
			}
			if (success) {
			} else {
			    miss_lock
				(miss_atom, odb1_slip, odb1_pick, atom_data);

			    flags = 0;

			    *progress |= STAGE_0;

			    break;
			}

			ndbv_data++;

			odbx_seek = ndbv_data->odbx_data;
		    }
		}
		odb2_data = odb2_swap;
		if (flags & NXAA_LIST) {
		    const struct e4_ndba_type *ndba_data;
		    const struct e4_ndbv_type *ndbv_data;
		    const struct e4_odbf_type *odbf_data;
		    const struct e4_odbx_type *odbx_seek;

		    odbf_data = odbx_data->extension1;
		    ndba_data = odbf_data->ndba_data;
		    ndbv_data = ndba_data->ndbv_data;

		    odbx_seek = ndbv_data->odbx_data;
		    while (odbx_seek) {
			int success = 1;
			struct e4_atom_type *miss_atom;
			const struct e4_ndbl_type *ndbl_data;
			struct e4_odb1_type *odb1_pick, *odb1_slip;
			unsigned atom_advance;

			ndbl_data = ndbv_data->ndbl_data;

			atom_advance = 0;

			odb2_data = odb2_swap;

			while (1) {
			    {
				int skip = 0;

				odb2_data = odb2_data->odb2_data;
				if (odb2_data) {
				    if (atom_advance) {
				    } else {
					if (i == 1) {
					    break;
					} else {
					    skip = 1;
					}
				    }
				} else {
				    if (atom_advance + 1 == i) {
					break;
				    } else {
					unsigned post_advance;

					_x1f4_e4_find_ce_0
					    (atom_data + atom_advance,
					     &post_advance, &odb2_data);
					atom_advance += post_advance;
				    }
				}
				if (_x1f4_e4_find_ce_8(ndbl_data, odb2_data)) {
				    break;
				} else {
				    if (skip) {
					continue;
				    }
				}
			    }
			    success = find_cl_1
				(atom_data, atom_advance, ndbl_data, odbx_seek,
				 odb2_data, &odb1_slip, &odb1_pick,
				 &miss_atom);
			    if (success) {
			    } else {
				break;
			    }
			}
			if (success) {
			} else {
			    miss_lock
				(miss_atom, odb1_slip, odb1_pick, atom_data);

			    flags = 0;

			    *progress |= STAGE_0;

			    break;
			}

			ndbv_data++;

			odbx_seek = ndbv_data->odbx_data;
		    }
		}
	    }
	}

	i--;
	atom_data++;
    }

    return status;
}


static int
line_list(struct e4_hack_type *hack_data, unsigned count,
	  void *aile, unsigned *progress,
	  int (*const *line_f) (LINE______ARGS_0))
{
    int status;

    if (count) {
	do {
	    status = line_this(hack_data, aile, progress, line_f);
	    if (status) {
		break;
	    }

	    count--;

	    hack_data++;
	} while (count);
    } else {
	status = 0;
    }

    return status;
}


static int
line_this(struct e4_hack_type *hack_data, void *aile,
	  unsigned *progress, int (*const *line_f) (LINE______ARGS_0))
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned count, i;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    i = count;
    for (; i; i--) {
	int type_1;

	type_1 = atom_data->type;
	if (1 << type_1 & LOGIC_BITS) {
	    struct e4_hack_type *hack_data;

	    hack_data = atom_data->data.last.base;
	    status = line_list
		(hack_data, hack_base(hack_data)->last_data->count,
		 aile, progress, line_f);
	} else if (type_1 == THIS) {
	    status = line_this
		(atom_data->data.hack.data, aile, progress, line_f);
	}
	if (status) {
	    break;
	}

	atom_data++;
    }
    if (status) {
    } else {
	int (*line_l) (LINE______ARGS_0);

	line_l = *line_f;
	while (line_l) {
	    status = line_l(hack_data, aile, progress);
	    if (status) {
		break;
	    } else {
		line_f++;
		line_l = *line_f;
	    }
	}
    }

    return status;
}


static int
make_this(struct e4_hack_type *hack_data, void *aile, unsigned *post_count,
	  unsigned *progress)
{
    int status = 0;
    struct e4_atom_type *atom_data;
    unsigned count, i;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    *post_count += count;
    i = count;
    for (; i; i--) {
	int type_1;

	type_1 = atom_data->type;
	if (1 << type_1 & LOGIC_BITS) {
	    struct e4_hack_type *hack_data;

	    hack_data = atom_data->data.last.base;
	    status = sign_list
		(hack_data, hack_base(hack_data)->last_data->count, aile,
		 progress);
	} else if (type_1 == THIS) {
	    if (atom_data->odb1) {
		status = sign_this(atom_data->data.hack.data, aile, progress);
	    } else {
		(*post_count)--;
		status = make_this
		    (atom_data->data.hack.data, aile, post_count, progress);
	    }
	}
	if (status) {
	    break;
	}

	atom_data++;
    }

    return status;
}


static int
miss_cf_0(struct e4_odb2_type *odb2_data, const struct e4_odbl_type *odbl_data,
	  const struct e4_cdbx_type *cdbx_fail)
{
    const struct e4_cdbx_type *cdbx_data;

    cdbx_data = odbl_data->oddp;
    if (cdbx_data) {
    } else {
	cdbx_data = cdbx_fail;
    }
    if (cdbx_data->type == DATA_TRANSFORM) {
	odb2_data->odbx_data = cdbx_data->transform;
    }

    return 0;
}


static int
miss_cf_1(struct e4_odb2_type *odb2_data, struct e4_atom_type *atom_data,
	  const struct e4_odbl_type *odbl_data)
{
    const struct e4_cdbx_type *cdbx_data;

    cdbx_data = odbl_data->oddl;
    if (cdbx_data->type == DATA_TRANSFORM) {
	const struct e4_cdbl_type *cdbl_data;
	const struct e4_cdbp_type *cdbp_data;
	const struct e4_odbx_type *odbx_data, *odbx_miss;

	cdbp_data = cdbx_data->transform;
	odb2_data = odb2_data->odb2_data;
	if (odb2_data) {
	    cdbl_data = cdbp_data->cdbs_data;
	} else {
	    unsigned atom_advance;

	    cdbl_data = cdbp_data->cdbp_data;
	    _x1f4_e4_find_ce_0(atom_data, &atom_advance, &odb2_data);
	}
	odbx_data = odb2_data->odbx_data;
	odbx_miss = cdbl_data->odbx_data;
	while (odbx_data != odbx_miss) {
	    cdbl_data++;
	    odbx_miss = cdbl_data->odbx_data;
	}
	odb2_data->odbx_data = cdbl_data->odbx_miss;
    } else {
	if (cdbx_data->type == PAIR_TRANSFORM) {
	    while (1) {
		int do_break = 0;
		const struct e4_cdbl_type *cdbl_data;
		const struct e4_cdbp_type *cdbp_data;
		const struct e4_odbx_type *odbx_data, *odbx_miss;

		cdbp_data = cdbx_data->transform;
		odb2_data = odb2_data->odb2_data;
		if (odb2_data) {
		    do_break = 1;
		    cdbl_data = cdbp_data->cdbs_data;
		} else {
		    unsigned atom_advance;

		    cdbl_data = cdbp_data->cdbp_data;
		    _x1f4_e4_find_ce_0(atom_data, &atom_advance, &odb2_data);
		    atom_data += atom_advance;
		}
		odbx_data = odb2_data->odbx_data;
		odbx_miss = cdbl_data->odbx_data;
		while (odbx_data != odbx_miss) {
		    cdbl_data++;
		    odbx_miss = cdbl_data->odbx_data;
		}
		odb2_data->odbx_data = cdbl_data->odbx_miss;
		if (do_break) {
		    break;
		}
	    }
	}
    }

    return 0;
}


static int
miss_cf_2(struct e4_atom_type *atom_data, struct e4_atom_type *atom_link,
	  const struct e4_odbl_type *odbl_data, void *aile)
{
    int status;
    struct e4_post_type data[2];

    status = atom_data->load(atom_data, data + 0, NULL);
    if (status) {
    } else {
	status = atom_link->load(atom_link, data + 1, NULL);
	if (status) {
	} else {
	    const struct e4_odbx_type *odbx_data;
	    struct e4_post_type post;
	    void *bias[2], *transfer;

	    bias[0] = &data[0].data;
	    bias[1] = &data[1].data;
	    transfer = &post.data;
	    odbx_data = odbl_data->odbx_miss;
	    status = odbx_data->odbx(transfer, bias);
	    if (status) {
	    } else {
		int type_1;

		type_1 = atom_data->type;
		if (type_1 == TEXT) {
		    FIX_TEXT(aile, atom_data);
		}
		type_1 = odbx_data->type;
		SET_ATOM(atom_data, type_1, transfer);
		type_1 = atom_link->type;
		if (type_1 == TEXT) {
		    FIX_TEXT(aile, atom_data);
		}
	    }
	}
    }

    return status;
}


static int
miss_lock(struct e4_atom_type *atom_data, struct e4_odb1_type *odb1_slip,
	  struct e4_odb1_type *odb1_lock, struct e4_atom_type *miss_atom)
{
    struct e4_odb1_type *odb1_data;

    if (odb1_slip) {
	odb1_slip->odb1_data = NULL;
    } else {
	atom_data->odb1 = NULL;
    }

    odb1_data = miss_atom->odb1;
    if (odb1_data) {
	while (1) {
	    struct e4_odb1_type *odb1_text;

	    odb1_text = odb1_data->odb1_data;
	    if (odb1_text) {
		odb1_data = odb1_text->odb1_data;
		if (odb1_data) {
		} else {
		    odb1_text->odb1_data = odb1_lock;
		    if (1) {
			break;
		    }
		}
	    } else {
		odb1_data->odb1_data = odb1_lock;
		if (1) {
		    break;
		}
	    }
	}
    } else {
	miss_atom->odb1 = odb1_lock;
    }

    return 0;
}


static int
pick_lock(struct e4_atom_type *atom_data, struct e4_odb1_type **odb0,
	  struct e4_odb1_type **odb1)
{
    struct e4_odb1_type *odb1_data, *odb1_slip, *odb1_text = NULL;

    odb1_data = atom_data->odb1;
    while (1) {
	odb1_slip = odb1_data->odb1_data;
	if (odb1_slip) {
	    odb1_text = odb1_slip->odb1_data;
	    if (odb1_text) {
		odb1_data = odb1_text->odb1_data;
		if (odb1_data) {
		} else {
		    *odb0 = odb1_slip;
		    *odb1 = odb1_text;
		    if (1) {
			break;
		    }
		}
	    } else {
		*odb0 = odb1_data;
		*odb1 = odb1_slip;
		if (1) {
		    break;
		}
	    }
	} else {
	    *odb0 = odb1_text;
	    *odb1 = odb1_data;
	    if (1) {
		break;
	    }
	}
    }

    return 0;
}


static int
post_this(struct e4_hack_type *hack_data, void *aile,
	  struct e4_atom_type **atoms)
{
    struct e4_atom_type *atom_data, *post_atom;
    unsigned count, i;

    post_atom = *atoms;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    i = count;
    for (; i; i--) {
	int type_1;

	type_1 = atom_data->type;
	if (type_1 != THIS) {
	    *post_atom++ = *atom_data;
	} else {
	    if (atom_data->odb1) {
		*post_atom++ = *atom_data;
	    } else {
		struct e4_hack_type *this_hack;

		this_hack = atom_data->data.hack.data;
		post_this(this_hack, aile, &post_atom);

		post_atom--;

		{
		    struct e4_odb2_type *this_odb2;

		    this_odb2 = post_atom->odb2._2nd;
		    if (this_odb2) {
			struct e4_odb2_type *odb2_data;

			odb2_data = atom_data->odb2._2nd;
			if (odb2_data) {
			    struct e4_odb2_type *link_odb2;

			    odb2_data = atom_data->odb2._2nd;
			    link_odb2 = this_odb2->odb2_data;
			    while (link_odb2) {
				this_odb2 = link_odb2;
				link_odb2 = this_odb2->odb2_data;
			    }
			    this_odb2->odb2_data = odb2_data;
			}
		    } else {
			post_atom->odb2._2nd = atom_data->odb2._2nd;
		    }
		}

		E_FREE(aile, this_hack->atoms);
		E_FREE(aile, this_hack);

		post_atom++;
	    }
	}

	atom_data++;
    }

    *atoms = post_atom;

    return 0;
}


static int
sign_cf_1(struct e4_atom_type *atom_data, struct e4_odb2_type *odb2_seek,
	  const struct e4_odbt_type *odbt_data,
	  const struct e4_odbz_type *odbz_data,
	  const struct e4_odbl_type **odbl, const struct e4_odbl_type **odbi)
{
    const struct e4_odbl_type *odbi_data = NULL;
    const struct e4_odbt_type *odbt_miss;
    unsigned count = 0;

    odbt_miss = odbz_data->odbt_data;

    while (1) {
	struct e4_odb2_type *odb2_data;

	odb2_data = atom_data->odb2._2nd;
	if (odb2_data) {
	    while (odb2_data) {
		if (odb2_data == odb2_seek) {
		    break;
		} else {
		    if (count) {
			if (odbi_data) {
			} else {
			    const struct e4_odbv_type *odbv_data;
			    const struct e4_odbx_type *odbx_data;

			    odbv_data = odbt_miss->odbv_data;
			    odbx_data = odb2_data->odbx_data;
			    while (odbx_data != odbv_data->odbx_data) {
				odbv_data++;
			    }
			    odbi_data =
				(odbt_miss + odbv_data->shift)->odbl_data;
			}
			count--;
		    } else {
			const struct e4_odbv_type *odbv_data;
			const struct e4_odbx_type *odbx_data;

			odbv_data = odbt_miss->odbv_data;
			odbx_data = odb2_data->odbx_data;
			while (odbx_data != odbv_data->odbx_data) {
			    odbv_data++;
			}
			odbt_miss += odbv_data->shift;
		    }
		}
		odb2_data = odb2_data->odb2_data;
	    }
	    if (odb2_data == odb2_seek) {
		break;
	    }
	}

	count++;

	atom_data++;
    }

    {
	const struct e4_odbv_type *odbv_data;
	const struct e4_odbx_type *odbx_data;

	odbv_data = odbt_miss->odbv_data;
	odbx_data = odb2_seek->odbx_data;
	while (odbx_data != odbv_data->odbx_data) {
	    odbv_data++;
	}
	odbt_miss += odbv_data->shift;
	odbv_data = odbt_miss->odbv_data;
	odbx_data = odbt_data->odbx_data;
	while (odbx_data != odbv_data->odbx_data) {
	    odbv_data++;
	}
	odbt_miss += odbv_data->shift;
    }

    *odbi = odbi_data;
    *odbl = odbt_miss->odbl_data;

    return 0;
}


static int
sign_cf_2(struct e4_atom_type *atom_data, struct e4_odb2_type *odb2_seek,
	  const struct e4_odbt_type *odbt_data,
	  const struct e4_odbl_type **odbl)
{
    const struct e4_odbt_type *odbt_miss;
    unsigned count = 0;

    odbt_miss = odbt_data;

    while (1) {
	struct e4_odb2_type *odb2_data;

	odb2_data = atom_data->odb2._2nd;
	if (odb2_data) {
	    while (odb2_data) {
		{
		    if (0 < count) {
			count--;
		    } else {
			const struct e4_odbv_type *odbv_data;
			const struct e4_odbx_type *odbx_data;

			odbv_data = odbt_miss->odbv_data;
			odbx_data = odb2_data->odbx_data;
			while (odbx_data != odbv_data->odbx_data) {
			    odbv_data++;
			}
			odbt_miss += odbv_data->shift;
		    }
		}
		if (odb2_data == odb2_seek) {
		    break;
		}
		odb2_data = odb2_data->odb2_data;
	    }
	    if (odb2_data == odb2_seek) {
		break;
	    }
	}

	count++;

	atom_data++;
    }

    *odbl = odbt_miss->odbl_data;

    return 0;
}


static int
sign_head(struct e4_odb2_type *odb2_data, struct e4_atom_type *atom_data,
	  const struct e4_edbx_type *edbx_data,
	  struct e4_odb2_type *odb2_seek)
{
    while (1) {
	const struct e4_edbl_type *edbl_data;
	const struct e4_edbp_type *edbp_data;
	const struct e4_odbx_type *odbx_data, *odbx_miss;

	edbp_data = edbx_data->transform;
	odb2_data = odb2_data->odb2_data;
	if (odb2_data) {
	} else {
	    unsigned atom_advance;

	    _x1f4_e4_find_ce_0(atom_data, &atom_advance, &odb2_data);
	    atom_data += atom_advance;
	}
	edbl_data = edbp_data->edbl_data;
	odbx_data = odb2_data->odbx_data;
	odbx_miss = edbl_data->odbx_data;
	while (odbx_data != odbx_miss) {
	    edbl_data++;
	    odbx_miss = edbl_data->odbx_data;
	}
	odb2_data->odbx_data = edbl_data->odbx_miss;
	if (odb2_data == odb2_seek) {
	    break;
	}
    }

    return 0;
}


static int
sign_list(struct e4_hack_type *hack_data, unsigned count, void *aile,
	  unsigned *progress)
{
    int status;

    if (count) {
	do {
	    status = sign_this(hack_data, aile, progress);
	    if (status) {
		break;
	    }

	    count--;

	    hack_data++;
	} while (count);
    } else {
	status = 0;
    }

    return status;
}


static int
sign_this(struct e4_hack_type *hack_data, void *aile, unsigned *progress)
{
    int status = 0, straight = 0;
    struct e4_atom_type *atom_data;
    unsigned count, i, post_count = 0;

    count = hack_data->count;
    atom_data = hack_data->atoms;
    post_count += count;
    i = count;
    for (; i; i--) {
	int type_1;

	type_1 = atom_data->type;
	if (1 << type_1 & LOGIC_BITS) {
	    struct e4_hack_type *hack_data;

	    hack_data = atom_data->data.last.base;
	    status = sign_list
		(hack_data, hack_base(hack_data)->last_data->count, aile,
		 progress);
	} else if (type_1 == THIS) {
	    if (atom_data->odb1) {
		status = sign_this(atom_data->data.hack.data, aile, progress);
	    } else {
		straight = 1;
		post_count--;
		status = make_this
		    (atom_data->data.hack.data, aile, &post_count, progress);
	    }
	}
	if (status) {
	    break;
	}

	atom_data++;
    }
    if (status) {
    } else {
	if (straight) {
	    struct e4_atom_type *post_atom;

	    status = E_LINK(aile, &post_atom,
			    post_count * sizeof(struct e4_atom_type));
	    if (status) {
		status = 1;
	    } else {
		struct e4_atom_type *make_atom;

		make_atom = post_atom;
		post_this(hack_data, aile, &make_atom);

		hack_data->atoms = post_atom;
		hack_data->count = post_count;

		E_FREE(aile, atom_data - count);

		*progress |= STAGE_0;
	    }
	}
    }

    return status;
}


static int
test_atom(struct e4_atom_type *atom_data, int less, const void *test)
{
    int false = 1, type_1;

    type_1 = atom_data->type;
    if (type_1 == BILL) {
	const C_BILL *bill;

	bill = test;
	if (less) {
	    if (*(C_BILL *) &atom_data->data.lead.data != *bill) {
		false = 0;
	    }
	} else {
	    if (*(C_BILL *) &atom_data->data.lead.data == *bill) {
		false = 0;
	    }
	}
    } else if (type_1 == MODE) {
	const C_MODE *mode;

	mode = test;
	if (less) {
	    if (*(C_MODE *) &atom_data->data.lead.data != *mode) {
		false = 0;
	    }
	} else {
	    if (*(C_MODE *) &atom_data->data.lead.data == *mode) {
		false = 0;
	    }
	}
    } else if (type_1 == REAL) {
	const C_REAL *real;

	real = test;
	if (less) {
	    if (*(C_REAL *) &atom_data->data.lead.data != *real) {
		false = 0;
	    }
	} else {
	    if (*(C_REAL *) &atom_data->data.lead.data == *real) {
		false = 0;
	    }
	}
    }

    return false;
}


static int
test_head(struct e4_atom_type *atom_data, const void *test,
	  struct e4_odb2_type *odb2_seek, unsigned count,
	  struct e4_odb2_type **odb2)
{
    int false = 1;
    const struct e4_edbx_type *edbx_data;

    edbx_data = test;
    if (edbx_data->type == SDBL_HEAD_TRANSFORM) {
	const struct e4_edbp_type *edbp_data;
	struct e4_odb2_type *odb2_data;

	edbp_data = edbx_data->transform;

	odb2_data = odb2_seek;
	odb2_data = odb2_data->odb2_data;
	if (odb2_data) {
	    const struct e4_edbl_type *edbl_data;
	    const struct e4_odbx_type *odbx_data, *odbx_miss;

	    edbl_data = edbp_data->edbl_data;

	    odbx_data = odb2_data->odbx_data;
	    odbx_miss = edbl_data->odbx_data;
	    while (odbx_miss) {
		if (odbx_data == odbx_miss) {
		    break;
		} else {
		    edbl_data++;
		    odbx_miss = edbl_data->odbx_data;
		}
	    }

	    if (odbx_miss) {
		false = 0;
		*odb2 = odb2_data;
	    }
	} else {
	    int minus = 0;

	    atom_data += 2;
	    count -= 2;
	    while (1) {
		minus--;
		if (odb2_data) {
		    odb2_data = odb2_data->odb2_data;
		}
		if (odb2_data) {
		} else {
		    if (count) {
			unsigned atom_advance;

			_x1f4_e4_find_ce_0
			    (atom_data - 1, &atom_advance, &odb2_data);
			atom_data += atom_advance;
			count -= atom_advance;
			minus = 0;
		    } else {
			break;
		    }
		}
		{
		    const struct e4_edbl_type *edbl_data;
		    const struct e4_odbx_type *odbx_data, *odbx_miss;

		    edbl_data = edbp_data->edbl_data;

		    odbx_data = odb2_data->odbx_data;
		    odbx_miss = edbl_data->odbx_data;
		    while (odbx_miss) {
			if (odbx_data == odbx_miss) {
			    break;
			} else {
			    edbl_data++;
			    odbx_miss = edbl_data->odbx_data;
			}
		    }
		    if (odbx_miss) {
			if (minus < 0) {
			    false = 0;
			    *odb2 = odb2_data;
			    break;
			}
		    } else {
			break;
		    }
		}
	    }
	}
    }

    return false;
}


static int
type_atom(struct e4_atom_type *atom_data, int type, const void *test)
{
    if (type == BILL) {
	C_BILL *slip;
	const C_BILL *bill;

	bill = test;
	slip = (C_BILL *) &atom_data->data.lead.data;
	*slip = *bill;
    } else if (type == MODE) {
	C_MODE *slip;
	const C_MODE *mode;

	mode = test;
	slip = (C_MODE *) &atom_data->data.lead.data;
	*slip = *mode;
    } else if (type == REAL) {
	C_REAL *slip;
	const C_REAL *real;

	real = test;
	slip = (C_REAL *) &atom_data->data.lead.data;
	*slip = *real;
    }

    atom_data->type = type;

    return 0;
}


int
_x1f4_e4_beta_expression(struct e4_expression_type *expression_data)
{
    int status;
    struct e4_hack_type *hack_data;
    unsigned progress;

    hack_data = &expression_data->hack_data;
    do {
	progress = 0;
	status = line_this(hack_data, expression_data, &progress, line_0);
	if (status) {
	} else {
	    status = sign_this(hack_data, expression_data, &progress);
	    if (status) {
	    } else {
		status = line_this
		    (hack_data, expression_data, &progress, line_1);
	    }
	}
	if (status) {
	    break;
	}
    } while (progress);

    return status;
}
