/*
 * e4-e.1-f.e.5.c
 * Copyright (C) 2006-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-defs.h>
#include <e4-inter.h>
#include <e4-types.h>

int
_x1f4_e4_find_ce_5(struct e4_atom_type *atom_data, unsigned atom_advance)
{
    int false = 0;

    while (atom_advance) {
	{
	    struct e4_odb1_type *odb1_data;

	    odb1_data = atom_data->odb1;
	    while (odb1_data) {
		if (odb1_data->odbx_data->flags & KEEP_CALL) {
		    false = 1;
		    break;
		}

		odb1_data = odb1_data->odb1_data;
	    }
	}
	if (false) {
	    break;
	} else {
	    struct e4_odb2_type *odb2_data;

	    odb2_data = atom_data->odb2._2nd;
	    while (odb2_data) {
		if (odb2_data->odbx_data->flags & (KEEP_CALL | LEFT_XSET)) {
		    false = 1;
		    break;
		}

		odb2_data = odb2_data->odb2_data;
	    }
	}
	if (false) {
	    break;
	} else {
	    if (atom_data->type == LAST) {
		struct e4_hack_type *hack_data;
		const struct e4_last_type *last_data;

		hack_data = atom_data->data.last.base;
		last_data = hack_base(hack_data)->last_data;
		if (last_data->flags & KEEP_CALL) {
		    false = 1;
		    break;
		} else {
		    if (last_data->flags & POST_TYPE) {
			const int *args;
			unsigned j, count;

			count = last_data->count;
			args = last_data->args + count;
			for (j = count; j; j--) {
			    if (*args & HERE_XSET) {
				false = 1;
				break;
			    } else {
				false = _x1f4_e4_find_ce_5
				    (hack_data->atoms, hack_data->count);
				if (false) {
				    break;
				}
			    }

			    args++;
			    hack_data++;
			}
		    } else {
			unsigned j, count;

			count = last_data->count;
			for (j = count; j; j--) {
			    false = _x1f4_e4_find_ce_5
				(hack_data->atoms, hack_data->count);
			    if (false) {
				break;
			    }

			    hack_data++;
			}
		    }
		    if (false) {
			break;
		    }
		}
	    } else {
		if (atom_data->type == LOCK) {
		    false = 1;
		    break;
		} else {
		    if (atom_data->type == PICK) {
			false = 1;
			break;
		    } else {
			if (1) {
			    if (atom_data->type == THIS) {
				struct e4_hack_type *hack_data;

				hack_data = atom_data->data.hack.data;
				false = _x1f4_e4_find_ce_5
				    (hack_data->atoms, hack_data->count);
				if (false) {
				    break;
				}
			    }
			}
		    }
		}
	    }
	}

	atom_data++;
	atom_advance--;
    }

    return false;
}
