/*
 * e4-defaults.c
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2012, Ciprian Niculescu
 * Copyright (C) 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4-config.h>

#include <config.h>

#if __TEST_FOR_MATH_ERRNO__
# include <errno.h>
#endif				/* __TEST_FOR_MATH_ERRNO__ */
#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <math.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#if defined HAVE_GETTIMEOFDAY
# include <sys/time.h>
#endif				/* HAVE_GETTIMEOFDAY */

#if !defined HAVE_LIBx1f4i0
# include <cards3.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4-bits.h>
#include <e4-bits2.h>
#include <e4-bits3.h>
#include <e4-defs.h>
#include <e4-fls.h>
#include <e4-inter.h>
#include <e4-types.h>
#include <e4-xfs.h>
#include <e4-xls.h>
#include <exerrors.h>
#if !defined HAVE_LIBx1f4i0
# include <icards3.h>
# include <icompare.h>
#endif				/* !HAVE_LIBx1f4i0 */

#undef M_PI_2
/*
 * asin(1) says this:
 */
#define M_PI_2 \
    1.5707963267948965579989817342720925807952880859375
#undef M_PI_2
/*
 * but gnu math.h says:
 */
#define M_PI_2				1.5707963267948966192313216916397514

#define I_BILL(i)			(*((C_BILL *) (i)))
#define I_MODE(i)			(*((C_MODE *) (i)))
#define I_REAL(r)			(*((C_REAL *) (r)))
#define I_TEXT(t)			(*((C_TEXT *) (t)))

#define b_MODE(e, output, intrinsic) \
    {									      \
	C_MODE *l;							      \
									      \
	l = (output);							      \
	intrinsic(*l, (e));						      \
    }

#define l_BILL(e, output) \
    {									      \
	C_BILL *l;							      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }
#define l_MODE(e, output) \
    {									      \
	C_MODE *l;							      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }
#define l_REAL(e, output) \
    {									      \
	C_REAL *l;							      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }
#define l_TEXT(e, output) \
    {									      \
	C_TEXT *l;							      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#if defined HAVE_GETTIMEOFDAY
# define SRAND_INIT() \
    {									      \
	struct timeval time;						      \
									      \
	gettimeofday(&time, NULL);					      \
	srand(time.tv_usec);						      \
    }
#else
# define SRAND_INIT() \
    {									      \
	srand(time(NULL));						      \
    }
#endif				/* HAVE_GETTIMEOFDAY */

static int bits_base(x1f4_e4_LINK_ARGS_0);
static int bits_deck(x1f4_e4_LINK_ARGS_0);
static int bits_mffs(x1f4_e4_LINK_ARGS_0);
static int bits_mfls(x1f4_e4_LINK_ARGS_0);
static int bits_mxfs(x1f4_e4_LINK_ARGS_0);
static int bits_mxls(x1f4_e4_LINK_ARGS_0);
static int math_afix(x1f4_e4_LINK_ARGS_0);
static int math_aiff(x1f4_e4_LINK_ARGS_0);
static int math_bill(x1f4_e4_LINK_ARGS_0);
static int math_ceil(x1f4_e4_LINK_ARGS_0);
static int math_cfix(x1f4_e4_LINK_ARGS_0);
static int math_clip(x1f4_e4_LINK_ARGS_0);
static int math_copy(x1f4_e4_LINK_ARGS_0);
static int math_efix(x1f4_e4_LINK_ARGS_0);
static int math_eiff(x1f4_e4_LINK_ARGS_0);
static int math_exp2(x1f4_e4_LINK_ARGS_0);
static int math_fabs(x1f4_e4_LINK_ARGS_0);
static int math_fcos(x1f4_e4_LINK_ARGS_0);
static int math_ffsq(x1f4_e4_LINK_ARGS_0);
static int math_flog(x1f4_e4_LINK_ARGS_0);
static int math_flow(x1f4_e4_LINK_ARGS_0);
static int math_fmax(x1f4_e4_LINK_ARGS_0);
static int math_fmin(x1f4_e4_LINK_ARGS_0);
static int math_fmod(x1f4_e4_LINK_ARGS_0);
static int math_fsin(x1f4_e4_LINK_ARGS_0);
static int math_ftan(x1f4_e4_LINK_ARGS_0);
static int math_gcos(x1f4_e4_LINK_ARGS_0);
static int math_gsin(x1f4_e4_LINK_ARGS_0);
static int math_gtan(x1f4_e4_LINK_ARGS_0);
static int math_hcos(x1f4_e4_LINK_ARGS_0);
static int math_hgt2(x1f4_e4_LINK_ARGS_0);
static int math_hgtp(x1f4_e4_LINK_ARGS_0);
static int math_hsin(x1f4_e4_LINK_ARGS_0);
static int math_htan(x1f4_e4_LINK_ARGS_0);
static int math_htg2(x1f4_e4_LINK_ARGS_0);
static int math_htgp(x1f4_e4_LINK_ARGS_0);
static int math_icos(x1f4_e4_LINK_ARGS_0);
static int math_igt2(x1f4_e4_LINK_ARGS_0);
static int math_igtp(x1f4_e4_LINK_ARGS_0);
static int math_isin(x1f4_e4_LINK_ARGS_0);
static int math_itan(x1f4_e4_LINK_ARGS_0);
static int math_itg2(x1f4_e4_LINK_ARGS_0);
static int math_itgp(x1f4_e4_LINK_ARGS_0);
static int math_log0(x1f4_e4_LINK_ARGS_0);
static int math_log2(x1f4_e4_LINK_ARGS_0);
static int math_mabs(x1f4_e4_LINK_ARGS_0);
static int math_mexp(x1f4_e4_LINK_ARGS_0);
static int math_mmax(x1f4_e4_LINK_ARGS_0);
static int math_mmin(x1f4_e4_LINK_ARGS_0);
static int math_mode(x1f4_e4_LINK_ARGS_0);
static int math_modf(x1f4_e4_LINK_ARGS_0);
static int math_modg(x1f4_e4_LINK_ARGS_0);
static int math_modh(x1f4_e4_LINK_ARGS_0);
static int math_mpow(x1f4_e4_LINK_ARGS_0);
static int math_rand(x1f4_e4_LINK_ARGS_0);
static int math_rate(x1f4_e4_LINK_ARGS_0);
static int math_real(x1f4_e4_LINK_ARGS_0);
static int math_sign(x1f4_e4_LINK_ARGS_0);
static int math_sqrt(x1f4_e4_LINK_ARGS_0);
static int mode_bits(x1f4_e4_LINK_ARGS_0);
static int mode_clip(x1f4_e4_LINK_ARGS_0);
static int mode_dgcd(x1f4_e4_LINK_ARGS_0);
static int mode_rand(x1f4_e4_LINK_ARGS_0);
static int real_land(x1f4_e4_LINK_ARGS_0);
static int real_rand(x1f4_e4_LINK_ARGS_0);
static int real_sign(x1f4_e4_LINK_ARGS_0);
static int text_blue(x1f4_e4_LINK_ARGS_0);
static int text_card(x1f4_e4_LINK_ARGS_0);
static int text_echo(x1f4_e4_LINK_ARGS_0);
static int text_diff(x1f4_e4_LINK_ARGS_0);
static int text_head(x1f4_e4_LINK_ARGS_0);
static int text_last(x1f4_e4_LINK_ARGS_0);
static int text_riff(x1f4_e4_LINK_ARGS_0);
static int text_sard(x1f4_e4_LINK_ARGS_0);
static int text_slip(x1f4_e4_LINK_ARGS_0);
static int text_tail(x1f4_e4_LINK_ARGS_0);
static int text_this(x1f4_e4_LINK_ARGS_0);

static int do_srand = 1;
static const int c_____b__[] = {
/* *INDENT-OFF* */
    BILL
/* *INDENT-ON* */
}, c_____m_3[] = {
/* *INDENT-OFF* */
    MODE,
    MODE,
    MODE
/* *INDENT-ON* */
}, c_____m__[] = {
/* *INDENT-OFF* */
    MODE
/* *INDENT-ON* */
}, c_____m_m[] = {
/* *INDENT-OFF* */
    MODE,
    MODE
/* *INDENT-ON* */
}, c_____r_3[] = {
/* *INDENT-OFF* */
    REAL,
    REAL,
    REAL
/* *INDENT-ON* */
}, c_____r__[] = {
/* *INDENT-OFF* */
    REAL
/* *INDENT-ON* */
}, c_____r_R[] = {
/* *INDENT-OFF* */
    REAL,
    REAL,
    0,
    HERE_XSET
/* *INDENT-ON* */
}, c_____r_r[] = {
/* *INDENT-OFF* */
    REAL,
    REAL
/* *INDENT-ON* */
}, c_____t__[] = {
/* *INDENT-OFF* */
    TEXT
/* *INDENT-ON* */
}, c_____t_m[] = {
/* *INDENT-OFF* */
    TEXT,
    MODE
/* *INDENT-ON* */
}, c_____t_t[] = {
/* *INDENT-OFF* */
    TEXT,
    TEXT
/* *INDENT-ON* */
};

const struct e4_last_type x1f4_e4_defaults[] = {
/* *INDENT-OFF* */
    {	"Gacos",		math_hcos,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"Garccos",		math_hcos,
	REAL,			c_____r__,	1,
	0,					7		},
    {	"Garcsin",		math_hsin,
	REAL,			c_____r__,	1,
	0,					7		},
    {	"Gasin",		math_hsin,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"acos",			math_icos,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"arccos",		math_icos,
	REAL,			c_____r__,	1,
	0,					6		},
    {	"arcsin",		math_isin,
	REAL,			c_____r__,	1,
	0,					6		},
    {	"asin",			math_isin,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"fclip",		math_clip,
	REAL,			c_____r_3,	3,
	0,					5		},
    {	"fmod",			math_fmod,
	REAL,			c_____r_r,	2,
	0,					4		},
    {	"gcd",			mode_dgcd,
	MODE,			c_____m_m,	2,
	0,					3		},
    {	"iclip",		mode_clip,
	MODE,			c_____m_3,	3,
	0,					5		},
    {	"ln",			math_flog,
	REAL,			c_____r__,	1,
	0,					2		},
    {	"log",			math_flog,
	REAL,			c_____r__,	1,
	0,					3		},
    {	"log10",		math_log0,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"log2",			math_log2,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"pow",			math_mpow,
	REAL,			c_____r_r,	2,
	0,					3		},
    {	"sqrt",			math_sqrt,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"Gadiff",		math_eiff,
	REAL,			c_____r_r,	2,
	0,					6		},
    {	"Garcctg2",		math_hgt2,
	REAL,			c_____r_r,	2,
	0,					8		},
    {	"Garcdiff",		math_eiff,
	REAL,			c_____r_r,	2,
	0,					8		},
    {	"Garctg",		math_htan,
	REAL,			c_____r__,	1,
	0,					6		},
    {	"Garctg2",		math_htg2,
	REAL,			c_____r_r,	2,
	0,					7		},
    {	"Gatan",		math_htan,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"Gatan2",		math_htg2,
	REAL,			c_____r_r,	2,
	0,					6		},
    {	"Gcos",			math_gcos,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"Gparcctg2",		math_hgtp,
	REAL,			c_____r_r,	2,
	0,					9		},
    {	"Gparctg2",		math_htgp,
	REAL,			c_____r_r,	2,
	0,					8		},
    {	"Gpatan2",		math_htgp,
	REAL,			c_____r_r,	2,
	0,					7		},
    {	"Gsin",			math_gsin,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"Gtan",			math_gtan,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"Gtg",			math_gtan,
	REAL,			c_____r__,	1,
	0,					3		},
    {	"abs",			math_mabs,
	MODE,			c_____m__,	1,
	0,					3		},
    {	"adiff",		math_aiff,
	REAL,			c_____r_r,	2,
	0,					5		},
    {	"arcctg2",		math_igt2,
	REAL,			c_____r_r,	2,
	0,					7		},
    {	"arcdiff",		math_aiff,
	REAL,			c_____r_r,	2,
	0,					7		},
    {	"arctg",		math_itan,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"arctg2",		math_itg2,
	REAL,			c_____r_r,	2,
	0,					6		},
    {	"atan",			math_itan,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"atan2",		math_itg2,
	REAL,			c_____r_r,	2,
	0,					5		},
    {	"base2",		bits_base,
	MODE,			c_____m__,	1,
	0,					5		},
    {	"bcount",		mode_bits,
	MODE,			c_____m__,	1,
	0,					6		},
    {	"ceil",			math_ceil,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"cardinal",		math_bill,
	BILL,			c_____b__,	1,
	0,					8		},
    {	"character",		text_this,
	MODE,			c_____t_m,	2,
	0,					9		},
    {	"compare",		text_diff,
	MODE,			c_____t_t,	2,
	0,					7		},
    {	"cos",			math_fcos,
	REAL,			c_____r__,	1,
	0,					3		},
    {	"deck2",		bits_deck,
	MODE,			c_____m__,	1,
	0,					5		},
    {	"drand",		math_rand,
	MODE,			c_____m__,	1,
	0,					5		},
    {	"echo",			text_echo,
	TEXT,			c_____t__,	1,
	KEEP_CALL,				4		},
    {	"exp",			math_mexp,
	REAL,			c_____r__,	1,
	0,					3		},
    {	"exp2",			math_exp2,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"fabs",			math_fabs,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"ffs",			bits_mffs,
	MODE,			c_____m__,	1,
	0,					3		},
    {	"floor",		math_flow,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"fls",			bits_mfls,
	MODE,			c_____m__,	1,
	0,					3		},
    {	"fmax",			math_fmax,
	REAL,			c_____r_r,	2,
	0,					4		},
    {	"fmin",			math_fmin,
	REAL,			c_____r_r,	2,
	0,					4		},
    {	"fmodf",		math_modf,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"frame",		text_tail,
	MODE,			c_____t_m,	2,
	0,					5		},
    {	"frand",		real_rand,
	REAL,			NULL,		0,
	KEEP_CALL,				5		},
    {	"fsign",		real_sign,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"icompare",		text_riff,
	MODE,			c_____t_t,	2,
	0,					8		},
    {	"imatch",		text_sard,
	MODE,			c_____t_t,	2,
	0,					6		},
    {	"imodf",		math_modg,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"index",		text_head,
	MODE,			c_____t_m,	2,
	0,					5		},
    {	"initial",		text_blue,
	MODE,			c_____t__,	1,
	0,					7		},
    {	"integer",		math_mode,
	MODE,			c_____m__,	1,
	0,					7		},
    {	"irand",		mode_rand,
	MODE,			c_____m_m,	2,
	0,					5		},
    {	"length",		text_last,
	MODE,			c_____t__,	1,
	0,					6		},
    {	"limit",		math_efix,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"lrand",		real_land,
	REAL,			NULL,		0,
	KEEP_CALL,				5		},
    {	"lz",			bits_mxls,
	MODE,			c_____m__,	1,
	0,					2		},
    {	"match",		text_card,
	MODE,			c_____t_t,	2,
	0,					5		},
    {	"max",			math_mmax,
	MODE,			c_____m_m,	2,
	0,					3		},
    {	"min",			math_mmin,
	MODE,			c_____m_m,	2,
	0,					3		},
    {	"modf",			math_modh,
	REAL,			c_____r_R,	2,
	POST_TYPE,				4		},
    {	"parcctg2",		math_igtp,
	REAL,			c_____r_r,	2,
	0,					8		},
    {	"parctg2",		math_itgp,
	REAL,			c_____r_r,	2,
	0,					7		},
    {	"patan2",		math_itgp,
	REAL,			c_____r_r,	2,
	0,					6		},
    {	"project",		text_slip,
	TEXT,			c_____t_m,	2,
	KEEP_CALL,				7		},
    {	"real",			math_real,
	REAL,			c_____r__,	1,
	0,					4		},
    {	"round",		math_afix,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"sign",			math_sign,
	MODE,			c_____m__,	1,
	0,					4		},
    {	"signed",		math_copy,
	MODE,			c_____b__,	1,
	0,					6		},
    {	"sin",			math_fsin,
	REAL,			c_____r__,	1,
	0,					3		},
    {	"sq",			math_ffsq,
	REAL,			c_____r__,	1,
	0,					2		},
    {	"tan",			math_ftan,
	REAL,			c_____r__,	1,
	0,					3		},
    {	"tg",			math_ftan,
	REAL,			c_____r__,	1,
	0,					2		},
    {	"track",		math_cfix,
	REAL,			c_____r__,	1,
	0,					5		},
    {	"tz",			bits_mxfs,
	MODE,			c_____m__,	1,
	0,					2		},
    {	"unsigned",		math_rate,
	BILL,			c_____m__,	1,
	0,					8		},
    {	"xfs",			bits_mxfs,
	MODE,			c_____m__,	1,
	0,					3		},
    {	"xls",			bits_mxls,
	MODE,			c_____m__,	1,
	0,					3		},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1		}
/* *INDENT-ON* */
}, *const x1f4_e4_computables = x1f4_e4_defaults + 18;

static int
bits_base(x1f4_e4_LINK_ARGS_1)
{
    b_MODE(I_MODE(input[0]), output, e4_base2);

    return 0;
}


static int
bits_deck(x1f4_e4_LINK_ARGS_1)
{
    b_MODE(I_MODE(input[0]), output, e4_deck2);

    return 0;
}


static int
bits_mffs(x1f4_e4_LINK_ARGS_1)
{
    b_MODE(I_MODE(input[0]), output, e4_ffs);

    return 0;
}


static int
bits_mfls(x1f4_e4_LINK_ARGS_1)
{
    b_MODE(I_MODE(input[0]), output, e4_fls);

    return 0;
}


static int
bits_mxfs(x1f4_e4_LINK_ARGS_1)
{
    b_MODE(I_MODE(input[0]), output, e4_xfs);

    return 0;
}


static int
bits_mxls(x1f4_e4_LINK_ARGS_1)
{
    b_MODE(I_MODE(input[0]), output, e4_xls);

    return 0;
}


static int
math_afix(x1f4_e4_LINK_ARGS_1)
{
#if !defined HAVE_ROUND
    double a, f, i;
#endif				/* !HAVE_ROUND */

#if defined HAVE_ROUND
    l_REAL(round(I_REAL(input[0])), output);
#else
    a = I_REAL(input[0]);
    f = modf(a, &i);
    if (i < 0) {
	if (-.5 < f) {
	} else {
	    i = floor(a);
	}
    } else {
	if (f < .5) {
	} else {
	    i = ceil(a);
	}
    }
#endif				/* HAVE_ROUND */

#if !defined HAVE_ROUND
    l_REAL(i, output);
#endif				/* !HAVE_ROUND */

    return 0;
}


static int
math_aiff(x1f4_e4_LINK_ARGS_1)
{
    C_REAL diff;

    diff = fmod(I_REAL(input[0]) - I_REAL(input[1]), M_PI_2 * 4);
    if (diff < 0) {
	diff = -diff;
    }
    if (M_PI_2 * 2 < diff) {
	diff -= M_PI_2 * 4;
	if (0 < diff) {
	    diff = 0;
	} else {
	    diff = -diff;
	}
    }

    l_REAL(diff, output);

    return 0;
}


static int
math_bill(x1f4_e4_LINK_ARGS_1)
{
    l_BILL(I_BILL(input[0]), output);

    return 0;
}


static int
math_ceil(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(ceil(I_REAL(input[0])), output);

    return 0;
}


static int
math_cfix(x1f4_e4_LINK_ARGS_1)
{
#if !defined HAVE_TRUNC
    double a;
#endif				/* !HAVE_TRUNC */

#if defined HAVE_TRUNC
    l_REAL(trunc(I_REAL(input[0])), output);
#else
    a = I_REAL(input[0]);
    if (a < 0) {
	a = ceil(a);
    } else {
	a = floor(a);
    }
#endif				/* HAVE_TRUNC */

#if !defined HAVE_TRUNC
    l_REAL(a, output);
#endif				/* !HAVE_TRUNC */

    return 0;
}


static int
math_clip(x1f4_e4_LINK_ARGS_1)
{
    C_REAL a, c, e;
    int status;

    a = I_REAL(input[0]);
    e = I_REAL(input[2]);
    if (e < a) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;

	c = I_REAL(input[1]);
	if (c < a) {
	    c = a;
	} else {
	    if (e < c) {
		c = e;
	    }
	}

	l_REAL(c, output);
    }

    return status;
}


static int
math_copy(x1f4_e4_LINK_ARGS_1)
{
    l_MODE(I_BILL(input[0]), output);

    return 0;
}


static int
math_efix(x1f4_e4_LINK_ARGS_1)
{
    double a;

    a = I_REAL(input[0]);
    if (0 < a) {
	a = ceil(a);
    } else {
	a = floor(a);
    }

    l_REAL(a, output);

    return 0;
}


static int
math_eiff(x1f4_e4_LINK_ARGS_1)
{
    C_REAL diff;

    diff = fmod(I_REAL(input[0]) - I_REAL(input[1]), 360);
    if (diff < 0) {
	diff = -diff;
    }
    if (180 < diff) {
	diff -= 360;
	if (0 < diff) {
	    diff = 0;
	} else {
	    diff = -diff;
	}
    }
    l_REAL(diff, output);

    return 0;
}


static int
math_exp2(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(exp2(I_REAL(input[0])), output);

    return 0;
}


static int
math_fabs(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(fabs(I_REAL(input[0])), output);

    return 0;
}


static int
math_fcos(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(cos(I_REAL(input[0])), output);

    return 0;
}


static int
math_ffsq(x1f4_e4_LINK_ARGS_1)
{
    double f;

    f = I_REAL(input[0]);
    l_REAL(f * f, output);

    return 0;
}


static int
math_flog(x1f4_e4_LINK_ARGS_1)
{
#if __TEST_FOR_MATH_ERRNO__
#else
    double slip;
#endif				/* __TEST_FOR_MATH_ERRNO__ */
#if __TEST_FOR_MATH_ERRNO__
    int save_errno, status = 0;
#else
    int status;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    save_errno = errno;
    errno = 0;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    l_REAL(log(I_REAL(input[0])), output);
#else
    slip = log(I_REAL(input[0]));
    if (isinf(slip) | isnan(slip)) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;
	l_REAL(slip, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    if (errno) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	errno = save_errno;
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    return status;
}


static int
math_flow(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(floor(I_REAL(input[0])), output);

    return 0;
}


static int
math_fmax(x1f4_e4_LINK_ARGS_1)
{
    C_REAL major, minor;

    major = I_REAL(input[0]);
    minor = I_REAL(input[1]);
    l_REAL(major < minor ? minor : major, output);

    return 0;
}


static int
math_fmin(x1f4_e4_LINK_ARGS_1)
{
    C_REAL major, minor;

    major = I_REAL(input[0]);
    minor = I_REAL(input[1]);
    l_REAL(major < minor ? major : minor, output);

    return 0;
}


static int
math_fmod(x1f4_e4_LINK_ARGS_1)
{
#if __TEST_FOR_MATH_ERRNO__
#else
    double slip;
#endif				/* __TEST_FOR_MATH_ERRNO__ */
#if __TEST_FOR_MATH_ERRNO__
    int save_errno, status = 0;
#else
    int status;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    save_errno = errno;
    errno = 0;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    l_REAL(fmod(I_REAL(input[0]), I_REAL(input[1])), output);
#else
    slip = fmod(I_REAL(input[0]), I_REAL(input[1]));
    if (isnan(slip)) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;
	l_REAL(slip, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    if (errno) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	errno = save_errno;
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    return status;
}


static int
math_fsin(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(sin(I_REAL(input[0])), output);

    return 0;
}


static int
math_ftan(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(tan(I_REAL(input[0])), output);

    return 0;
}


static int
math_gcos(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(cos(I_REAL(input[0]) * M_PI_2 / 90), output);

    return 0;
}


static int
math_gsin(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(sin(I_REAL(input[0]) * M_PI_2 / 90), output);

    return 0;
}


static int
math_gtan(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(tan(I_REAL(input[0]) * M_PI_2 / 90), output);

    return 0;
}


static int
math_hcos(x1f4_e4_LINK_ARGS_1)
{
    double slip;
#if __TEST_FOR_MATH_ERRNO__
    int save_errno, status = 0;
#else
    int status;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    save_errno = errno;
    errno = 0;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    slip = acos(I_REAL(input[0]));
#if __TEST_FOR_MATH_ERRNO__
#else
    if (isnan(slip)) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;
	l_REAL(slip * 90 / M_PI_2, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    if (errno) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	errno = save_errno;
	l_REAL(slip * 90 / M_PI_2, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    return status;
}


static int
math_hgt2(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(atan2(I_REAL(input[1]), I_REAL(input[0])) * 90 / M_PI_2, output);

    return 0;
}


static int
math_hgtp(x1f4_e4_LINK_ARGS_1)
{
    double arc;

    arc = atan2(I_REAL(input[1]), I_REAL(input[0]));
    if (arc < 0) {
	arc += M_PI_2 * 4;
	if (arc < 0) {
	    arc = 0;
	}
    }
    l_REAL(arc * 90 / M_PI_2, output);

    return 0;
}


static int
math_hsin(x1f4_e4_LINK_ARGS_1)
{
    double slip;
#if __TEST_FOR_MATH_ERRNO__
    int save_errno, status = 0;
#else
    int status;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    save_errno = errno;
    errno = 0;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    slip = asin(I_REAL(input[0]));
#if __TEST_FOR_MATH_ERRNO__
#else
    if (isnan(slip)) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;
	l_REAL(slip * 90 / M_PI_2, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    if (errno) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	errno = save_errno;
	l_REAL(slip * 90 / M_PI_2, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    return status;
}


static int
math_htan(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(atan(I_REAL(input[0])) * 90 / M_PI_2, output);

    return 0;
}


static int
math_htg2(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(atan2(I_REAL(input[0]), I_REAL(input[1])) * 90 / M_PI_2, output);

    return 0;
}


static int
math_htgp(x1f4_e4_LINK_ARGS_1)
{
    double arc;

    arc = atan2(I_REAL(input[0]), I_REAL(input[1]));
    if (arc < 0) {
	arc += M_PI_2 * 4;
	if (arc < 0) {
	    arc = 0;
	}
    }
    l_REAL(arc * 90 / M_PI_2, output);

    return 0;
}


static int
math_icos(x1f4_e4_LINK_ARGS_1)
{
#if __TEST_FOR_MATH_ERRNO__
#else
    double slip;
#endif				/* __TEST_FOR_MATH_ERRNO__ */
#if __TEST_FOR_MATH_ERRNO__
    int save_errno, status = 0;
#else
    int status;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    save_errno = errno;
    errno = 0;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    l_REAL(acos(I_REAL(input[0])), output);
#else
    slip = acos(I_REAL(input[0]));
    if (isnan(slip)) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;
	l_REAL(slip, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    if (errno) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	errno = save_errno;
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    return status;
}


static int
math_igt2(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(atan2(I_REAL(input[1]), I_REAL(input[0])), output);

    return 0;
}


static int
math_igtp(x1f4_e4_LINK_ARGS_1)
{
    double arc;

    arc = atan2(I_REAL(input[1]), I_REAL(input[0]));
    if (arc < 0) {
	arc += M_PI_2 * 4;
	if (arc < 0) {
	    arc = 0;
	}
    }
    l_REAL(arc, output);

    return 0;
}


static int
math_isin(x1f4_e4_LINK_ARGS_1)
{
#if __TEST_FOR_MATH_ERRNO__
#else
    double slip;
#endif				/* __TEST_FOR_MATH_ERRNO__ */
#if __TEST_FOR_MATH_ERRNO__
    int save_errno, status = 0;
#else
    int status;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    save_errno = errno;
    errno = 0;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    l_REAL(asin(I_REAL(input[0])), output);
#else
    slip = asin(I_REAL(input[0]));
    if (isnan(slip)) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;
	l_REAL(slip, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    if (errno) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	errno = save_errno;
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    return status;
}


static int
math_itan(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(atan(I_REAL(input[0])), output);

    return 0;
}


static int
math_itg2(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(atan2(I_REAL(input[0]), I_REAL(input[1])), output);

    return 0;
}


static int
math_itgp(x1f4_e4_LINK_ARGS_1)
{
    double arc;

    arc = atan2(I_REAL(input[0]), I_REAL(input[1]));
    if (arc < 0) {
	arc += M_PI_2 * 4;
	if (arc < 0) {
	    arc = 0;
	}
    }
    l_REAL(arc, output);

    return 0;
}


static int
math_log0(x1f4_e4_LINK_ARGS_1)
{
#if __TEST_FOR_MATH_ERRNO__
#else
    double slip;
#endif				/* __TEST_FOR_MATH_ERRNO__ */
#if __TEST_FOR_MATH_ERRNO__
    int save_errno, status = 0;
#else
    int status;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    save_errno = errno;
    errno = 0;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    l_REAL(log10(I_REAL(input[0])), output);
#else
    slip = log10(I_REAL(input[0]));
    if (isinf(slip) | isnan(slip)) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;
	l_REAL(slip, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    if (errno) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	errno = save_errno;
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    return status;
}


static int
math_log2(x1f4_e4_LINK_ARGS_1)
{
#if __TEST_FOR_MATH_ERRNO__
#else
    double slip;
#endif				/* __TEST_FOR_MATH_ERRNO__ */
#if __TEST_FOR_MATH_ERRNO__
    int save_errno, status = 0;
#else
    int status;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    save_errno = errno;
    errno = 0;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    l_REAL(log2(I_REAL(input[0])), output);
#else
    slip = log2(I_REAL(input[0]));
    if (isinf(slip) | isnan(slip)) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;
	l_REAL(slip, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    if (errno) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	errno = save_errno;
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    return status;
}


static int
math_mabs(x1f4_e4_LINK_ARGS_1)
{
    l_MODE(abs(I_MODE(input[0])), output);

    return 0;
}


static int
math_mexp(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(exp(I_REAL(input[0])), output);

    return 0;
}


static int
math_mmax(x1f4_e4_LINK_ARGS_1)
{
    C_MODE major, minor;

    major = I_MODE(input[0]);
    minor = I_MODE(input[1]);
    l_MODE(major < minor ? minor : major, output);

    return 0;
}


static int
math_mmin(x1f4_e4_LINK_ARGS_1)
{
    C_MODE major, minor;

    major = I_MODE(input[0]);
    minor = I_MODE(input[1]);
    l_MODE(major < minor ? major : minor, output);

    return 0;
}


static int
math_mode(x1f4_e4_LINK_ARGS_1)
{
    l_MODE(I_MODE(input[0]), output);

    return 0;
}


static int
math_modf(x1f4_e4_LINK_ARGS_1)
{
    double f, i;

    f = modf(I_REAL(input[0]), &i);
    l_REAL(f, output);

    return 0;
}


static int
math_modg(x1f4_e4_LINK_ARGS_1)
{
    double f, i;

    f = modf(I_REAL(input[0]), &i);
    l_REAL(i, output);

    return 0;
}


static int
math_modh(x1f4_e4_LINK_ARGS_1)
{
    double f, i;

    f = modf(I_REAL(input[0]), &i);
    l_REAL(f, output);
    l_REAL(i, input[1]);

    return 0;
}


static int
math_mpow(x1f4_e4_LINK_ARGS_1)
{
#if __TEST_FOR_MATH_ERRNO__
#else
    double slip;
#endif				/* __TEST_FOR_MATH_ERRNO__ */
#if __TEST_FOR_MATH_ERRNO__
    int save_errno, status = 0;
#else
    int status;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    save_errno = errno;
    errno = 0;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    l_REAL(pow(I_REAL(input[0]), I_REAL(input[1])), output);
#else
    slip = pow(I_REAL(input[0]), I_REAL(input[1]));
    if (isinf(slip) | isnan(slip)) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;
	l_REAL(slip, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    if (errno) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	errno = save_errno;
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    return status;
}


static int
math_rand(x1f4_e4_LINK_ARGS_1)
{
    C_MODE max;

    max = I_MODE(input[0]);
    if (max < 1) {
	l_MODE(0, output);
    } else {
	if (do_srand) {
	    do_srand = 0;
	    SRAND_INIT();
	}

	if (RAND_MAX < max) {
	    C_DECK fix;
	    unsigned deck, i, miss;

	    e4_xls(i, (C_DECK) RAND_MAX + 1);
	    deck = (sizeof(C_MODE) << 3) - (i + 1);

	    e4_xls(i, max);
	    miss = (sizeof(C_MODE) << 3) - (i + 0);

	    i = (miss - 1) / deck;

	    fix = rand();
	    while (i) {
		i--;
		fix <<= deck;
		fix |= rand();
	    }

	    l_MODE(fix % (max + 1), output);
	} else {
	    l_MODE((C_DECK) rand() % ((C_DECK) max + 1), output);
	}
    }

    return 0;
}


static int
math_rate(x1f4_e4_LINK_ARGS_1)
{
    l_BILL(I_MODE(input[0]), output);

    return 0;
}


static int
math_real(x1f4_e4_LINK_ARGS_1)
{
    l_REAL(I_REAL(input[0]), output);

    return 0;
}


static int
math_sign(x1f4_e4_LINK_ARGS_1)
{
    C_MODE input_0_;

    input_0_ = I_MODE(input[0]);
    if (input_0_ < 0) {
	input_0_ = -1;
    } else {
	if (input_0_) {
	    input_0_ = 1;
	}
    }
    l_MODE(input_0_, output);

    return 0;
}


static int
math_sqrt(x1f4_e4_LINK_ARGS_1)
{
#if __TEST_FOR_MATH_ERRNO__
#else
    double slip;
#endif				/* __TEST_FOR_MATH_ERRNO__ */
#if __TEST_FOR_MATH_ERRNO__
    int save_errno, status = 0;
#else
    int status;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    save_errno = errno;
    errno = 0;
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    l_REAL(sqrt(I_REAL(input[0])), output);
#else
    slip = sqrt(I_REAL(input[0]));
    if (isnan(slip)) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;
	l_REAL(slip, output);
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

#if __TEST_FOR_MATH_ERRNO__
    if (errno) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	errno = save_errno;
    }
#endif				/* __TEST_FOR_MATH_ERRNO__ */

    return status;
}


static int
mode_bits(x1f4_e4_LINK_ARGS_1)
{
    b_MODE(I_MODE(input[0]), output, e4_bitcount);

    return 0;
}


static int
mode_clip(x1f4_e4_LINK_ARGS_1)
{
    C_MODE a, c, e;
    int status;

    a = I_MODE(input[0]);
    e = I_MODE(input[2]);
    if (e < a) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	status = 0;

	c = I_MODE(input[1]);
	if (c < a) {
	    c = a;
	} else {
	    if (e < c) {
		c = e;
	    }
	}

	l_MODE(c, output);
    }

    return status;
}


static int
mode_dgcd(x1f4_e4_LINK_ARGS_1)
{
    C_MODE a, b;
    int status = 0;

    a = I_MODE(input[0]);
    b = I_MODE(input[1]);

    if (!a) {
	status = X1f4_EX_CAN_CONTINUE;
    } else {
	if (!b) {
	    status = X1f4_EX_CAN_CONTINUE;
	} else {
	    C_MODE v;

#if 0
	    while (1) {
		a = a % b;
		if (!a) {
		    v = b;
		    break;
		} else {
		    b = b % a;
		    if (!b) {
			v = a;
			break;
		    }
		}
	    }
#else
	    if (a < 0) {
		a = -a;
	    }
	    if (b < 0) {
		b = -b;
	    }
	    if (a < b) {
	    } else {
		v = a;
		a = b;
		b = v;
	    }
	    {
		unsigned e = 0;

		v = a | b;
		while (!(v & 1)) {
		    e++;
		    v >>= 1;
		}

		a >>= e;
		b >>= e;

		if (b & 1) {
		    v = -a;
		} else {
		    v = b;
		}
		while (v) {
		    while (!(v & 1)) {
			v >>= 1;
		    }
		    if (0 < v) {
			b = v;
		    } else {
			a = -v;
		    }

		    v = b - a;
		}

		v = b << e;
	    }
#endif				/* 0 */

	    l_MODE(v, output);
	}
    }

    return status;
}


static int
mode_rand(x1f4_e4_LINK_ARGS_1)
{
    C_MODE max, min;

    max = I_MODE(input[0]);
    min = I_MODE(input[1]);
    if (max < min) {
	C_MODE fix;

	fix = max;
	max = min;
	min = fix;
    }
    if (!(max ^ min)) {
	l_MODE(max, output);
    } else {
	C_DECK set;

	set = max - min;

	if (do_srand) {
	    do_srand = 0;
	    SRAND_INIT();
	}

	if (RAND_MAX < set) {
	    C_DECK fix;
	    unsigned deck, i, miss;

	    e4_xls(i, (C_DECK) RAND_MAX + 1);
	    deck = (sizeof(C_MODE) << 3) - (i + 1);

	    e4_xls(i, set);
	    miss = (sizeof(C_MODE) << 3) - (i + 0);

	    i = (miss - 1) / deck;

	    fix = rand();
	    while (i) {
		i--;
		fix <<= deck;
		fix |= rand();
	    }

	    l_MODE(min + fix % (set + 1), output);
	} else {
	    l_MODE(min + (C_DECK) rand() % (set + 1), output);
	}
    }

    return 0;
}


static int
real_land(x1f4_e4_LINK_ARGS_1)
{
    if (do_srand) {
	do_srand = 0;
	SRAND_INIT();
    }

    l_REAL((C_REAL) rand() * 2 / RAND_MAX - 1, output);

    return 0;
}


static int
real_rand(x1f4_e4_LINK_ARGS_1)
{
    if (do_srand) {
	do_srand = 0;
	SRAND_INIT();
    }

    l_REAL((C_REAL) rand() / RAND_MAX, output);

    return 0;
}


static int
real_sign(x1f4_e4_LINK_ARGS_1)
{
    C_REAL input_0_;

    input_0_ = I_REAL(input[0]);
    if (input_0_ < 0) {
	input_0_ = -1;
    } else {
	if (input_0_) {
	    input_0_ = 1;
	}
    }

    l_REAL(input_0_, output);

    return 0;
}


static int
text_blue(x1f4_e4_LINK_ARGS_1)
{
    l_MODE(*(unsigned char *) I_TEXT(input[0]), output);

    return 0;
}


static int
text_card(x1f4_e4_LINK_ARGS_1)
{
    char *major, *minor;

    major = I_TEXT(input[0]);
    minor = I_TEXT(input[1]);
    l_MODE(x1f4_match_cards3(major, strlen(major), minor, strlen(minor)),
	   output);

    return 0;
}


static int
text_echo(x1f4_e4_LINK_ARGS_1)
{
    l_TEXT(I_TEXT(input[0]), output);

    return 0;
}


static int
text_diff(x1f4_e4_LINK_ARGS_1)
{
    l_MODE(_x1f4_e4_text_diff
	   ((unsigned char *) I_TEXT(input[0]),
	    (unsigned char *) I_TEXT(input[1])), output);

    return 0;
}


static int
text_head(x1f4_e4_LINK_ARGS_1)
{
    C_MODE miss, this;

    this = I_MODE(input[1]);
    if (this & ~255) {
	miss = -1;
    } else {
	C_TEXT text;

	text = I_TEXT(input[0]);
	while (1) {
	    int byte;

	    byte = *(unsigned char *) text;
	    if (byte) {
		if (byte ^ this) {
		    text++;
		} else {
		    miss = text - I_TEXT(input[0]);
		    break;
		}
	    } else {
		miss = -1;
		break;
	    }
	}
    }

    l_MODE(miss, output);

    return 0;
}


static int
text_last(x1f4_e4_LINK_ARGS_1)
{
    l_MODE(strlen(I_TEXT(input[0])), output);

    return 0;
}


static int
text_riff(x1f4_e4_LINK_ARGS_1)
{
    l_MODE(x1f4_icompare(I_TEXT(input[0]), I_TEXT(input[1])), output);

    return 0;
}


static int
text_sard(x1f4_e4_LINK_ARGS_1)
{
    char *major, *minor;

    major = I_TEXT(input[0]);
    minor = I_TEXT(input[1]);
    l_MODE(x1f4_match_icards3(major, strlen(major), minor, strlen(minor)),
	   output);

    return 0;
}


static int
text_slip(x1f4_e4_LINK_ARGS_1)
{
    C_MODE this;
    C_TEXT text;

    text = I_TEXT(input[0]);

    this = I_MODE(input[1]);
    if (this < 0) {
	this++;
	this += strlen(text);
	if (this < 0) {
	} else {
	    text += this;
	}
    } else {
	while (1) {
	    int c;

	    c = *(unsigned char *) text;
	    if (c) {
		if (this) {
		    text++;
		    this--;
		} else {
		    break;
		}
	    } else {
		break;
	    }
	}
    }

    l_TEXT(text, output);

    return 0;
}


static int
text_tail(x1f4_e4_LINK_ARGS_1)
{
    C_MODE miss = -1, this;

    this = I_MODE(input[1]);
    if (this & ~255) {
    } else {
	C_TEXT text;

	text = I_TEXT(input[0]);
	while (1) {
	    int byte;

	    byte = *(unsigned char *) text;
	    if (byte) {
		if (byte ^ this) {
		} else {
		    miss = text - I_TEXT(input[0]);
		}

		text++;
	    } else {
		break;
	    }
	}
    }

    l_MODE(miss, output);

    return 0;
}


static int
text_this(x1f4_e4_LINK_ARGS_1)
{
    C_MODE miss, this;
    C_TEXT text;

    text = I_TEXT(input[0]);

    this = I_MODE(input[1]);
    if (this < 0) {
	this += strlen(text);
	if (this < 0) {
	    miss = 0;
	} else {
	    miss = ((unsigned char *) text)[this];
	}
    } else {
	while (1) {
	    int c;

	    c = *(unsigned char *) text;
	    if (c) {
		if (this) {
		    text++;
		    this--;
		} else {
		    miss = c;
		    break;
		}
	    } else {
		miss = 0;
		break;
	    }
	}
    }

    l_MODE(miss, output);

    return 0;
}
