/*
 * e4-bits2.h
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_BITS2_H__
#define __LIBx1f4_e4_BITS2_H__

#include <config.h>

#if !defined BITS_MODE
# if SIZEOF_LONG == 4
#  define BITS_MODE			unsigned
# else
#  define BITS_MODE			unsigned long
# endif				/* SIZEOF_LONG == 4 */
#endif				/* !BITS_MODE */

#if SIZEOF_LONG == 4
# if defined x1f4_bitcount_32
#  define e4_bitcount(l4f1_base, l4f1_mode) \
    x1f4_bitcount_32((l4f1_base), (l4f1_mode))
# else
#  define e4_bitcount(l4f1_bitcount, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l4f1_c = (l4f1_c & 0x55555555) + ((l4f1_c >> 0x01) & 0x55555555);     \
	l4f1_c = (l4f1_c & 0x33333333) + ((l4f1_c >> 0x02) & 0x33333333);     \
	l4f1_c = (l4f1_c & 0x0f0f0f0f) + ((l4f1_c >> 0x04) & 0x0f0f0f0f);     \
	l4f1_c = (l4f1_c & 0x00ff00ff) + ((l4f1_c >> 0x08) & 0x00ff00ff);     \
	l4f1_c = (l4f1_c & 0x0000ffff) + ((l4f1_c >> 0x10) & 0x0000ffff);     \
									      \
	(l4f1_bitcount) = l4f1_c;					      \
    }
# endif				/* x1f4_bitcount_32 */
#else
# if defined x1f4_bitcount_64
#  define e4_bitcount(l4f1_base, l4f1_mode) \
    x1f4_bitcount_64((l4f1_base), (l4f1_mode))
# else
#  define e4_bitcount(l4f1_bitcount, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l4f1_c = (l4f1_c & 0x5555555555555555ul)			      \
	    + ((l4f1_c >> 0x01) & 0x5555555555555555ul);		      \
	l4f1_c = (l4f1_c & 0x3333333333333333ul)			      \
	    + ((l4f1_c >> 0x02) & 0x3333333333333333ul);		      \
	l4f1_c = (l4f1_c & 0x0f0f0f0f0f0f0f0ful)			      \
	    + ((l4f1_c >> 0x04) & 0x0f0f0f0f0f0f0f0ful);		      \
	l4f1_c = (l4f1_c & 0x00ff00ff00ff00fful)			      \
	    + ((l4f1_c >> 0x08) & 0x00ff00ff00ff00fful);		      \
	l4f1_c = (l4f1_c & 0x0000ffff0000fffful)			      \
	    + ((l4f1_c >> 0x10) & 0x0000ffff0000fffful);		      \
	l4f1_c = (l4f1_c & 0x00000000fffffffful)			      \
	    + ((l4f1_c >> 0x20) & 0x00000000fffffffful);		      \
									      \
	(l4f1_bitcount) = l4f1_c;					      \
    }
# endif				/* x1f4_bitcount_64 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_bitcount_32
# else
#  undef e4_bitcount
#  define e4_bitcount(l4f1_bitcount, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l4f1_c = l4f1_c - ((l4f1_c >> 1) & 0x55555555);			      \
	l4f1_c = (l4f1_c & 0x33333333) + ((l4f1_c >> 2) & 0x33333333);	      \
	l4f1_c = (l4f1_c + (l4f1_c >> 4)) & 0x0f0f0f0f;			      \
	l4f1_c = l4f1_c + (l4f1_c >> 8);				      \
	l4f1_c = l4f1_c + (l4f1_c >> 16);				      \
									      \
	(l4f1_bitcount) = l4f1_c & 255;					      \
    }
# endif				/* x1f4_bitcount_32 */
#else
# if defined x1f4_bitcount_64
# else
#  undef e4_bitcount
#  define e4_bitcount(l4f1_bitcount, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_c;						      \
									      \
	l4f1_c = (l4f1_mode);						      \
									      \
	l4f1_c = l4f1_c - ((l4f1_c >> 1) & 0x5555555555555555ul);	      \
	l4f1_c = (l4f1_c & 0x3333333333333333ul)			      \
	    + ((l4f1_c >> 2) & 0x3333333333333333ul);			      \
	l4f1_c = (l4f1_c + (l4f1_c >> 4)) & 0x0f0f0f0f0f0f0f0ful;	      \
	l4f1_c = l4f1_c + (l4f1_c >> 8);				      \
	l4f1_c = l4f1_c + (l4f1_c >> 16);				      \
	l4f1_c = l4f1_c + (l4f1_c >> 32);				      \
									      \
	(l4f1_bitcount) = l4f1_c & 255;					      \
    }
# endif				/* x1f4_bitcount_64 */
#endif				/* SIZEOF_LONG == 4 */

#endif				/* __LIBx1f4_e4_BITS2_H__ */
