/*
 * e4-bits.h
 * Copyright (C) 2006-2008, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e4_BITS_H__
#define __LIBx1f4_e4_BITS_H__

#include <config.h>

#if !defined BITS_MODE
# if SIZEOF_LONG == 4
#  define BITS_MODE			unsigned
# else
#  define BITS_MODE			unsigned long
# endif				/* SIZEOF_LONG == 4 */
#endif				/* !BITS_MODE */

#if SIZEOF_LONG == 4
# if defined x1f4_base2_32
#  define e4_base2(l4f1_base, l4f1_mode) \
    x1f4_base2_32((l4f1_base), (l4f1_mode))
# else
#  define e4_base2(l4f1_base, l4f1_mode) \
    {									      \
	BITS_MODE a, b;							      \
									      \
	a = (l4f1_mode);						      \
	e4_xls(b, a);							      \
	b ^= 31;							      \
	b = 1 << b;							      \
									      \
	(l4f1_base) = b;						      \
    }
# endif				/* x1f4_base2_32 */
#else
# if defined x1f4_base2_64
#  define e4_base2(l4f1_base, l4f1_mode) \
    x1f4_base2_64((l4f1_base), (l4f1_mode))
# else
#  define e4_base2(l4f1_base, l4f1_mode) \
    {									      \
	BITS_MODE a, b;							      \
									      \
	a = (l4f1_mode);						      \
	e4_xls(b, a);							      \
	b ^= 63;							      \
	b = 1ul << b;							      \
									      \
	(l4f1_base) = b;						      \
    }
# endif				/* x1f4_base2_64 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_deck2_32
#  define e4_deck2(l4f1_deck, l4f1_mode) \
    x1f4_deck2_32((l4f1_deck), (l4f1_mode))
# else
#  define e4_deck2(l4f1_deck, l4f1_mode) \
    {									      \
	BITS_MODE a, b;							      \
									      \
	a = (l4f1_mode);						      \
	e4_xls(b, a);							      \
	b ^= 31;							      \
	b = 1 << b;							      \
	if (a ^ b) {							      \
	    b <<= 1;							      \
	}								      \
									      \
	(l4f1_deck) = b;						      \
    }
# endif				/* x1f4_deck2_32 */
#else
# if defined x1f4_deck2_64
#  define e4_deck2(l4f1_deck, l4f1_mode) \
    x1f4_deck2_64((l4f1_deck), (l4f1_mode))
# else
#  define e4_deck2(l4f1_deck, l4f1_mode) \
    {									      \
	BITS_MODE a, b;							      \
									      \
	a = (l4f1_mode);						      \
	e4_xls(b, a);							      \
	b ^= 63;							      \
	b = 1ul << b;							      \
	if (a ^ b) {							      \
	    b <<= 1;							      \
	}								      \
									      \
	(l4f1_deck) = b;						      \
    }
# endif				/* x1f4_deck2_64 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_ffs_32
#  define e4_ffs(l4f1_xffs, l4f1_mode) \
    x1f4_ffs_32((l4f1_xffs), (l4f1_mode))
# else
#  define e4_ffs(l4f1_xffs, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_d, l4f1_e, l4f1_f, l4f1_h, l4f1_i;		      \
									      \
	l4f1_i = (l4f1_mode);						      \
	l4f1_d = ~l4f1_i;						      \
									      \
	l4f1_e = l4f1_d & 0x55555555;					      \
	l4f1_d = l4f1_e + ((l4f1_d >> 001) & l4f1_e);			      \
									      \
	l4f1_e = l4f1_d & 0x33333333;					      \
	l4f1_f = l4f1_d & 0x22222222;					      \
	l4f1_h = l4f1_f >> 1;						      \
	l4f1_h = l4f1_h * 0x00000003;					      \
	l4f1_d = l4f1_e + ((l4f1_d >> 002) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x0f0f0f0f;					      \
	l4f1_f = l4f1_d & 0x04040404;					      \
	l4f1_h = l4f1_f >> 2;						      \
	l4f1_h = l4f1_h * 0x0000000f;					      \
	l4f1_d = l4f1_e + ((l4f1_d >> 004) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x00ff00ff;					      \
	l4f1_f = l4f1_d & 0x00080008;					      \
	l4f1_h = l4f1_f >> 3;						      \
	l4f1_h = l4f1_h * 0x000000ff;					      \
	l4f1_d = l4f1_e + ((l4f1_d >> 010) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x0000ffff;					      \
	l4f1_f = l4f1_d & 0x00000010;					      \
	l4f1_h = l4f1_f >> 4;						      \
	l4f1_h = l4f1_h * 0x0000ffff;					      \
	l4f1_d = l4f1_e + ((l4f1_d >> 020) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d >> 5;						      \
	l4f1_d = l4f1_d & 31;						      \
	l4f1_d = l4f1_d + 1;						      \
	l4f1_d = l4f1_d ^ l4f1_e;					      \
									      \
	(l4f1_xffs) = l4f1_d;						      \
    }
# endif				/* x1f4_ffs_32 */
#else
# if defined x1f4_ffs_64
#  define e4_ffs(l4f1_xffs, l4f1_mode) \
    x1f4_ffs_64((l4f1_xffs), (l4f1_mode))
# else
#  define e4_ffs(l4f1_xffs, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_d, l4f1_e, l4f1_f, l4f1_h, l4f1_i;		      \
									      \
	l4f1_i = (l4f1_mode);						      \
	l4f1_d = ~l4f1_i;						      \
									      \
	l4f1_e = l4f1_d & 0x5555555555555555ul;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 001) & l4f1_e);			      \
									      \
	l4f1_e = l4f1_d & 0x3333333333333333ul;				      \
	l4f1_f = l4f1_d & 0x2222222222222222ul;				      \
	l4f1_h = l4f1_f >> 1;						      \
	l4f1_h = l4f1_h * 0x0000000000000003ul;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 002) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x0f0f0f0f0f0f0f0ful;				      \
	l4f1_f = l4f1_d & 0x0404040404040404ul;				      \
	l4f1_h = l4f1_f >> 2;						      \
	l4f1_h = l4f1_h * 0x000000000000000ful;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 004) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x00ff00ff00ff00fful;				      \
	l4f1_f = l4f1_d & 0x0008000800080008ul;				      \
	l4f1_h = l4f1_f >> 3;						      \
	l4f1_h = l4f1_h * 0x00000000000000fful;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 010) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x0000ffff0000fffful;				      \
	l4f1_f = l4f1_d & 0x0000001000000010ul;				      \
	l4f1_h = l4f1_f >> 4;						      \
	l4f1_h = l4f1_h * 0x000000000000fffful;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 020) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x00000000fffffffful;				      \
	l4f1_f = l4f1_d & 0x0000000000000020ul;				      \
	l4f1_h = l4f1_f >> 5;						      \
	l4f1_h = l4f1_h * 0x00000000fffffffful;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 040) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d >> 6;						      \
	l4f1_d = l4f1_d & 63;						      \
	l4f1_d = l4f1_d + 1;						      \
	l4f1_d = l4f1_d ^ l4f1_e;					      \
									      \
	(l4f1_xffs) = l4f1_d;						      \
    }
# endif				/* x1f4_ffs_64 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_fls_32
#  define e4_fls(l4f1_xfls, l4f1_mode) \
    x1f4_fls_32((l4f1_xfls), (l4f1_mode))
# else
#  define e4_fls(l4f1_xfls, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_d, l4f1_e, l4f1_f, l4f1_h, l4f1_i;		      \
									      \
	l4f1_i = (l4f1_mode);						      \
	l4f1_d = ~l4f1_i;						      \
									      \
	l4f1_e = l4f1_d & 0xaaaaaaaa;					      \
	l4f1_e = l4f1_e >> 001;						      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_e);				      \
									      \
	l4f1_e = l4f1_d & 0xcccccccc;					      \
	l4f1_e = l4f1_e >> 002;						      \
	l4f1_f = l4f1_e & 0x22222222;					      \
	l4f1_h = l4f1_f >> 1;						      \
	l4f1_h = l4f1_h * 0x00000003;					      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xf0f0f0f0;					      \
	l4f1_e = l4f1_e >> 004;						      \
	l4f1_f = l4f1_e & 0x04040404;					      \
	l4f1_h = l4f1_f >> 2;						      \
	l4f1_h = l4f1_h * 0x0000000f;					      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xff00ff00;					      \
	l4f1_e = l4f1_e >> 010;						      \
	l4f1_f = l4f1_e & 0x00080008;					      \
	l4f1_h = l4f1_f >> 3;						      \
	l4f1_h = l4f1_h * 0x000000ff;					      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xffff0000;					      \
	l4f1_e = l4f1_e >> 020;						      \
	l4f1_f = l4f1_e & 0x00000010;					      \
	l4f1_h = l4f1_f >> 4;						      \
	l4f1_h = l4f1_h * 0x0000ffff;					      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d >> 5;						      \
	l4f1_d = l4f1_d & 31;						      \
	l4f1_d = l4f1_d + 1;						      \
	l4f1_d = l4f1_d ^ l4f1_e;					      \
									      \
	(l4f1_xfls) = l4f1_d;						      \
    }
# endif				/* x1f4_fls_32 */
#else
# if defined x1f4_fls_64
#  define e4_fls(l4f1_xfls, l4f1_mode) \
    x1f4_fls_64((l4f1_xfls), (l4f1_mode))
# else
#  define e4_fls(l4f1_xfls, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_d, l4f1_e, l4f1_f, l4f1_h, l4f1_i;		      \
									      \
	l4f1_i = (l4f1_mode);						      \
	l4f1_d = ~l4f1_i;						      \
									      \
	l4f1_e = l4f1_d & 0xaaaaaaaaaaaaaaaaul;				      \
	l4f1_e = l4f1_e >> 001;						      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_e);				      \
									      \
	l4f1_e = l4f1_d & 0xccccccccccccccccul;				      \
	l4f1_e = l4f1_e >> 002;						      \
	l4f1_f = l4f1_e & 0x2222222222222222ul;				      \
	l4f1_h = l4f1_f >> 1;						      \
	l4f1_h = l4f1_h * 0x0000000000000003ul;				      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xf0f0f0f0f0f0f0f0ul;				      \
	l4f1_e = l4f1_e >> 004;						      \
	l4f1_f = l4f1_e & 0x0404040404040404ul;				      \
	l4f1_h = l4f1_f >> 2;						      \
	l4f1_h = l4f1_h * 0x000000000000000ful;				      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xff00ff00ff00ff00ul;				      \
	l4f1_e = l4f1_e >> 010;						      \
	l4f1_f = l4f1_e & 0x0008000800080008ul;				      \
	l4f1_h = l4f1_f >> 3;						      \
	l4f1_h = l4f1_h * 0x00000000000000fful;				      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xffff0000ffff0000ul;				      \
	l4f1_e = l4f1_e >> 020;						      \
	l4f1_f = l4f1_e & 0x0000001000000010ul;				      \
	l4f1_h = l4f1_f >> 4;						      \
	l4f1_h = l4f1_h * 0x000000000000fffful;				      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xffffffff00000000ul;				      \
	l4f1_e = l4f1_e >> 040;						      \
	l4f1_f = l4f1_e & 0x0000000000000020ul;				      \
	l4f1_h = l4f1_f >> 5;						      \
	l4f1_h = l4f1_h * 0x00000000fffffffful;				      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d >> 6;						      \
	l4f1_d = l4f1_d & 63;						      \
	l4f1_d = l4f1_d + 1;						      \
	l4f1_d = l4f1_d ^ l4f1_e;					      \
									      \
	(l4f1_xfls) = l4f1_d;						      \
    }
# endif				/* x1f4_fls_64 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_xfs_32
#  define e4_xfs(l4f1_xxfs, l4f1_mode) \
    x1f4_xfs_32((l4f1_xxfs), (l4f1_mode))
# else
#  define e4_xfs(l4f1_xxfs, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_d, l4f1_e, l4f1_f, l4f1_h, l4f1_i;		      \
									      \
	l4f1_i = (l4f1_mode);						      \
	l4f1_d = ~l4f1_i;						      \
									      \
	l4f1_e = l4f1_d & 0x55555555;					      \
	l4f1_d = l4f1_e + ((l4f1_d >> 001) & l4f1_e);			      \
									      \
	l4f1_e = l4f1_d & 0x33333333;					      \
	l4f1_f = l4f1_d & 0x22222222;					      \
	l4f1_h = l4f1_f >> 1;						      \
	l4f1_h = l4f1_h * 0x00000003;					      \
	l4f1_d = l4f1_e + ((l4f1_d >> 002) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x0f0f0f0f;					      \
	l4f1_f = l4f1_d & 0x04040404;					      \
	l4f1_h = l4f1_f >> 2;						      \
	l4f1_h = l4f1_h * 0x0000000f;					      \
	l4f1_d = l4f1_e + ((l4f1_d >> 004) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x00ff00ff;					      \
	l4f1_f = l4f1_d & 0x00080008;					      \
	l4f1_h = l4f1_f >> 3;						      \
	l4f1_h = l4f1_h * 0x000000ff;					      \
	l4f1_d = l4f1_e + ((l4f1_d >> 010) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x0000ffff;					      \
	l4f1_f = l4f1_d & 0x00000010;					      \
	l4f1_h = l4f1_f >> 4;						      \
	l4f1_h = l4f1_h * 0x0000ffff;					      \
	l4f1_d = l4f1_e + ((l4f1_d >> 020) & l4f1_h);			      \
									      \
	(l4f1_xxfs) = l4f1_d;						      \
    }
# endif				/* x1f4_xfs_32 */
#else
# if defined x1f4_xfs_64
#  define e4_xfs(l4f1_xxfs, l4f1_mode) \
    x1f4_xfs_64((l4f1_xxfs), (l4f1_mode))
# else
#  define e4_xfs(l4f1_xxfs, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_d, l4f1_e, l4f1_f, l4f1_h, l4f1_i;		      \
									      \
	l4f1_i = (l4f1_mode);						      \
	l4f1_d = ~l4f1_i;						      \
									      \
	l4f1_e = l4f1_d & 0x5555555555555555ul;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 001) & l4f1_e);			      \
									      \
	l4f1_e = l4f1_d & 0x3333333333333333ul;				      \
	l4f1_f = l4f1_d & 0x2222222222222222ul;				      \
	l4f1_h = l4f1_f >> 1;						      \
	l4f1_h = l4f1_h * 0x0000000000000003ul;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 002) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x0f0f0f0f0f0f0f0ful;				      \
	l4f1_f = l4f1_d & 0x0404040404040404ul;				      \
	l4f1_h = l4f1_f >> 2;						      \
	l4f1_h = l4f1_h * 0x000000000000000ful;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 004) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x00ff00ff00ff00fful;				      \
	l4f1_f = l4f1_d & 0x0008000800080008ul;				      \
	l4f1_h = l4f1_f >> 3;						      \
	l4f1_h = l4f1_h * 0x00000000000000fful;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 010) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x0000ffff0000fffful;				      \
	l4f1_f = l4f1_d & 0x0000001000000010ul;				      \
	l4f1_h = l4f1_f >> 4;						      \
	l4f1_h = l4f1_h * 0x000000000000fffful;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 020) & l4f1_h);			      \
									      \
	l4f1_e = l4f1_d & 0x00000000fffffffful;				      \
	l4f1_f = l4f1_d & 0x0000000000000020ul;				      \
	l4f1_h = l4f1_f >> 5;						      \
	l4f1_h = l4f1_h * 0x00000000fffffffful;				      \
	l4f1_d = l4f1_e + ((l4f1_d >> 040) & l4f1_h);			      \
									      \
	(l4f1_xxfs) = l4f1_d;						      \
    }
# endif				/* x1f4_xfs_64 */
#endif				/* SIZEOF_LONG == 4 */

#if SIZEOF_LONG == 4
# if defined x1f4_xls_32
#  define e4_xls(l4f1_xxls, l4f1_mode) \
    x1f4_xls_32((l4f1_xxls), (l4f1_mode))
# else
#  define e4_xls(l4f1_xxls, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_d, l4f1_e, l4f1_f, l4f1_h, l4f1_i;		      \
									      \
	l4f1_i = (l4f1_mode);						      \
	l4f1_d = ~l4f1_i;						      \
									      \
	l4f1_e = l4f1_d & 0xaaaaaaaa;					      \
	l4f1_e = l4f1_e >> 001;						      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_e);				      \
									      \
	l4f1_e = l4f1_d & 0xcccccccc;					      \
	l4f1_e = l4f1_e >> 002;						      \
	l4f1_f = l4f1_e & 0x22222222;					      \
	l4f1_h = l4f1_f >> 1;						      \
	l4f1_h = l4f1_h * 0x00000003;					      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xf0f0f0f0;					      \
	l4f1_e = l4f1_e >> 004;						      \
	l4f1_f = l4f1_e & 0x04040404;					      \
	l4f1_h = l4f1_f >> 2;						      \
	l4f1_h = l4f1_h * 0x0000000f;					      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xff00ff00;					      \
	l4f1_e = l4f1_e >> 010;						      \
	l4f1_f = l4f1_e & 0x00080008;					      \
	l4f1_h = l4f1_f >> 3;						      \
	l4f1_h = l4f1_h * 0x000000ff;					      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xffff0000;					      \
	l4f1_e = l4f1_e >> 020;						      \
	l4f1_f = l4f1_e & 0x00000010;					      \
	l4f1_h = l4f1_f >> 4;						      \
	l4f1_h = l4f1_h * 0x0000ffff;					      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	(l4f1_xxls) = l4f1_d;						      \
    }
# endif				/* x1f4_xls_32 */
#else
# if defined x1f4_xls_64
#  define e4_xls(l4f1_xxls, l4f1_mode) \
    x1f4_xls_64((l4f1_xxls), (l4f1_mode))
# else
#  define e4_xls(l4f1_xxls, l4f1_mode) \
    {									      \
	BITS_MODE l4f1_d, l4f1_e, l4f1_f, l4f1_h, l4f1_i;		      \
									      \
	l4f1_i = (l4f1_mode);						      \
	l4f1_d = ~l4f1_i;						      \
									      \
	l4f1_e = l4f1_d & 0xaaaaaaaaaaaaaaaaul;				      \
	l4f1_e = l4f1_e >> 001;						      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_e);				      \
									      \
	l4f1_e = l4f1_d & 0xccccccccccccccccul;				      \
	l4f1_e = l4f1_e >> 002;						      \
	l4f1_f = l4f1_e & 0x2222222222222222ul;				      \
	l4f1_h = l4f1_f >> 1;						      \
	l4f1_h = l4f1_h * 0x0000000000000003ul;				      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xf0f0f0f0f0f0f0f0ul;				      \
	l4f1_e = l4f1_e >> 004;						      \
	l4f1_f = l4f1_e & 0x0404040404040404ul;				      \
	l4f1_h = l4f1_f >> 2;						      \
	l4f1_h = l4f1_h * 0x000000000000000ful;				      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xff00ff00ff00ff00ul;				      \
	l4f1_e = l4f1_e >> 010;						      \
	l4f1_f = l4f1_e & 0x0008000800080008ul;				      \
	l4f1_h = l4f1_f >> 3;						      \
	l4f1_h = l4f1_h * 0x00000000000000fful;				      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xffff0000ffff0000ul;				      \
	l4f1_e = l4f1_e >> 020;						      \
	l4f1_f = l4f1_e & 0x0000001000000010ul;				      \
	l4f1_h = l4f1_f >> 4;						      \
	l4f1_h = l4f1_h * 0x000000000000fffful;				      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	l4f1_e = l4f1_d & 0xffffffff00000000ul;				      \
	l4f1_e = l4f1_e >> 040;						      \
	l4f1_f = l4f1_e & 0x0000000000000020ul;				      \
	l4f1_h = l4f1_f >> 5;						      \
	l4f1_h = l4f1_h * 0x00000000fffffffful;				      \
	l4f1_d = l4f1_e + (l4f1_d & l4f1_h);				      \
									      \
	(l4f1_xxls) = l4f1_d;						      \
    }
# endif				/* x1f4_xls_64 */
#endif				/* SIZEOF_LONG == 4 */

#endif				/* __LIBx1f4_e4_BITS_H__ */
