/*
 * e2list.8.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e2list-types.h>

#define e2list(delete) \
    ((struct e2list_type *) (delete))

int
x1f4_slip_e2list(void *e2list, void *data, void *text, int (*miss) (void *))
{
    int status;

    if (data) {
	struct e2text_type *e2text_data, *last_e2text, *next_e2text;
	unsigned deck;

	deck = sizeof(struct e2text_type);
	deck += (16 - (deck & 15)) & 15;
	e2text_data = (void *) ((char *) data - deck);

	last_e2text = e2text_data->last_e2text;
	next_e2text = e2text_data->next_e2text;

	status = e2list(e2list)->link_a.free
	    (e2list(e2list)->link_a.data, e2text_data->data);
	if (status) {
	} else {
	    if (next_e2text) {
		next_e2text->last_e2text = last_e2text;
	    }
	    if (last_e2text) {
		last_e2text->next_e2text = next_e2text;
	    } else {
		e2list(e2list)->link_c.list = next_e2text;
	    }
	}
    } else {
	struct e2text_type *e2text_data;

	status = 1;

	e2text_data = e2list(e2list)->link_c.list;
	while (e2text_data) {
	    if (e2text_data->text == text && e2text_data->miss == miss) {
		struct e2text_type *last_e2text, *next_e2text;

		last_e2text = e2text_data->last_e2text;
		next_e2text = e2text_data->next_e2text;

		status = e2list(e2list)->link_a.free
		    (e2list(e2list)->link_a.data, e2text_data);
		if (status) {
		} else {
		    if (next_e2text) {
			next_e2text->last_e2text = last_e2text;
		    }
		    if (last_e2text) {
			last_e2text->next_e2text = next_e2text;
		    } else {
			e2list(e2list)->link_c.list = next_e2text;
		    }
		}
	    } else {
		e2text_data = e2text_data->next_e2text;
	    }
	}
    }

    return status;
}
