/*
 * e2list.7.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e2list-inter.h>
#include <e2list-types.h>

#define e2list(delete) \
    ((struct e2list_type *) (delete))

int
x1f4_mode_e2list(void *e2list, void **link, unsigned size)
{
    int status;
    void *mode;

    status = x1f4_link_e2list(e2list, &mode, size);
    if (!status) {
	void *post;

	post = *link;
	if (post) {
	    struct e2node_type *e2node_data, *last_e2node;
	    unsigned deck, flow;

	    deck = sizeof(struct e2node_type);
	    deck += (16 - (deck & 15)) & 15;

	    e2node_data = (void *) ((char *) mode - deck);
	    last_e2node = (void *) ((char *) post - deck);

	    deck = e2node_data->size;
	    flow = last_e2node->size;
	    if (deck < flow) {
		flow = deck;
	    }

	    memcpy(mode, post, flow);

	    x1f4_free_e2list(e2list, post);
	}

	*link = mode;
    }

    return status;
}
