/*
 * e2list.6.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>

#include <e2list-types.h>

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#define e2list(delete) \
    ((struct e2list_type *) (delete))

int
x1f4_link_e2list(void *e2list, void **link, unsigned size)
{
    int status;
    unsigned deck, flow;
    void *data;

    deck = sizeof(struct e2node_type);
    deck += (16 - (deck & 15)) & 15;

    flow = size + deck + 15;

    status = e2list(e2list)->link_a.link
	(e2list(e2list)->link_a.data, &data, flow);
    if (status) {
    } else {
	struct e2node_type *e2node_data, *list_e2node;

	{
	    integral_q post;
	    unsigned skip;

	    post = (integral_q) data;
	    skip = post;
	    skip = (16 - (skip & 15)) & 15;
	    e2node_data = (void *) ((char *) data + skip);
	}

	list_e2node = e2list(e2list)->link_e.list;
	e2list(e2list)->link_e.list = e2node_data;

	e2node_data->last_e2node = NULL;
	e2node_data->next_e2node = list_e2node;
	if (list_e2node) {
	    list_e2node->last_e2node = e2node_data;
	}

	e2node_data->data = data;
	e2node_data->size = size;

	*link = (void *) ((char *) e2node_data + deck);

	if (1) {
	    int *class;

	    class = e2list(e2list)->link_l.class;
	    if (class) {
		*class = 1;
	    }
	}
    }

    return status;
}
