/*
 * e2list.5.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e2list-types.h>

#define e2list(delete) \
    ((struct e2list_type *) (delete))

int
x1f4_free_e2list(void *e2list, void *data)
{
    int status;
    struct e2node_type *e2node_data, *last_e2node, *next_e2node;
    unsigned deck;

    deck = sizeof(struct e2node_type);
    deck += (16 - (deck & 15)) & 15;
    e2node_data = (void *) ((char *) data - deck);

    last_e2node = e2node_data->last_e2node;
    next_e2node = e2node_data->next_e2node;

    status = e2list(e2list)->link_a.free
	(e2list(e2list)->link_a.data, e2node_data->data);
    if (status) {
    } else {
	if (next_e2node) {
	    next_e2node->last_e2node = last_e2node;
	}
	if (last_e2node) {
	    last_e2node->next_e2node = next_e2node;
	} else {
	    e2list(e2list)->link_e.list = next_e2node;
	}
    }

    return status;
}
