/*
 * e2list.3.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e2list-inter.h>
#include <e2list-types.h>
#include <exerrors.h>

int
x1f4_deck_e2list(void **e2list)
{
    int excess, status;
    struct e2list_type *e2list_data;

    e2list_data = *e2list;

    status = _libx1f4i0_side_e2list(e2list_data);
    if (0) {
    } else {
	e2list_data->link_c.list = NULL;
    }

    excess = _libx1f4i0_deck_e2list(e2list_data);
    if (0) {
    } else {
	e2list_data->link_e.list = NULL;
    }

    if (status | excess) {
	status = X1f4_EX_CANNOT_CONTINUE;
    }

    return status;
}
