/*
 * e2list-types.h
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_e2list_types_H__
#define __LIBx1f4_e2list_types_H__

typedef struct e2list_type {
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_a;
    struct {
	void *list;
    } link_c;
    struct {
	void *list;
    } link_e;
    struct {
	int *class;
    } link_l;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
} e2list_type;

typedef struct e2node_type {
    struct e2node_type *last_e2node, *next_e2node;
    unsigned size;
    void *data;
} e2node_type;

typedef struct e2text_type {
    int (*miss) (void *);
    struct e2text_type *last_e2text, *next_e2text;
    unsigned size;
    void *data, *text;
} e2text_type;

typedef struct screen_type {
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_a;
    struct {
	int *class;
    } link_l;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
} screen_type;

typedef struct e2line_type {
    struct screen_type screen;
    unsigned bits;
} e2line_type;

#endif				/* __LIBx1f4_e2list_types_H__ */
