/*
 * dlxy.5.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>

#include <dlxx-defs.h>
#include <dlxx-names.h>
#include <dlxx-types.h>
#include <mask.0.h>
#include <trans.h>

#define dllist(dllist)			((struct dllist_type *) (dllist))

int
x1f4_fast_dllist(void *dllist, unsigned flags,
		 struct screen_type *screen_data)
{
    int status;
    unsigned item;

    item = screen_data->item;
    if (item) {
	unsigned node, slip;

	slip = sizeof(struct fpnode_type) + item - 1;
	if (item & (item - 1)) {
	    slip = slip - slip % item;
	} else {
	    slip = slip & ~(item - 1);
	}

	node = screen_data->node;
	if (node < slip + item) {
	    status = TEXT_ERROR;
	} else {
	    status = 0;

	    if (1) {
		dllist(dllist)->link_a.fplist.fplink.fpnode_data[0] = NULL;
		dllist(dllist)->link_a.fplist.fplink.fpnode_data[1] = NULL;

		dllist(dllist)->link_a.fplist.link_v.size = 0;

		dllist(dllist)->link_a.fplist.link_v.item = item;
		dllist(dllist)->link_a.fplist.link_v.node = node;
		dllist(dllist)->link_a.fplist.link_v.slip = slip;
		dllist(dllist)->link_a.fplist.link_v.text =
		    (node - slip) / item;

		if (flags & TRANS_MASK) {
		    struct trans_type *trans_data;

		    trans_data = screen_data->trans_data;

		    dllist(dllist)->link_m.data = trans_data->data;
		    dllist(dllist)->link_m.free = trans_data->free;
		    dllist(dllist)->link_m.link = trans_data->link;
		    dllist(dllist)->link_m.mode = trans_data->mode;
		} else {
		    dllist(dllist)->link_m.free = _libx1f4l2_free_data;
		    dllist(dllist)->link_m.link = _libx1f4l2_link_data;
		    dllist(dllist)->link_m.mode = _libx1f4l2_mode_data;
		}
	    }
	}
    } else {
	status = TEXT_ERROR;
    }

    return status;
}
