/*
 * dlxy.4.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <dlxx-defs.h>
#include <dlxx-inter.h>
#include <dlxx-names.h>
#include <dlxx-types.h>

#define dllist(dllist)			((struct dllist_type *) (dllist))

int
x1f4_tail_dllist(void *dllist, void **push)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = dllist(dllist)->link_a.fplist.fplink.fpnode_data[0];
    if (fpnode_data) {
	unsigned pick, text;

	text = fpnode_data->text;

	pick = fpnode_data->pick + text;

	if (pick < dllist(dllist)->link_a.fplist.link_v.text) {
	    if (1) {
		fpnode_data->text = text + 1;

		status = 0;

		dllist(dllist)->link_a.fplist.link_v.size++;

		*push = (char *) fpnode_data
		    + dllist(dllist)->link_a.fplist.link_v.slip
		    + dllist(dllist)->link_a.fplist.link_v.item * pick;
	    }
	} else {
	    void *dlnode;

	    status = dllist(dllist)->link_m.link
		(dllist(dllist)->link_m.data, &dlnode,
		 dllist(dllist)->link_a.fplist.link_v.node);
	    if (status) {
		status = LINK_ERROR;
	    } else {
		struct fpnode_type *fpnode_text;

		status = 0;

		fpnode_text = dlnode;

		dllist(dllist)->link_a.fplist.link_v.size++;

		fpnode_text->fpnode_data[0] = fpnode_data;
		fpnode_text->fpnode_data[1] = NULL;

		fpnode_text->pick = 0;

		fpnode_text->text = 1;

		fpnode_data->fpnode_data[1] = fpnode_text;

		dllist(dllist)->link_a.fplist.fplink.fpnode_data[0] =
		    fpnode_text;

		*push = (char *) dlnode
		    + dllist(dllist)->link_a.fplist.link_v.slip;
	    }
	}
    } else {
	if (1) {
	    void *dlnode;

	    status = dllist(dllist)->link_m.link
		(dllist(dllist)->link_m.data, &dlnode,
		 dllist(dllist)->link_a.fplist.link_v.node);
	    if (status) {
		status = LINK_ERROR;
	    } else {
		unsigned pick;

		status = 0;

		pick = (dllist(dllist)->link_a.fplist.link_v.text - 1) >> 1;

		fpnode_data = dlnode;

		dllist(dllist)->link_a.fplist.link_v.size = 1;

		fpnode_data->fpnode_data[0] = NULL;
		fpnode_data->fpnode_data[1] = NULL;

		fpnode_data->pick = pick;

		fpnode_data->text = 1;

		dllist(dllist)->link_a.fplist.fplink.fpnode_data[0] =
		    fpnode_data;
		dllist(dllist)->link_a.fplist.fplink.fpnode_data[1] =
		    fpnode_data;

		*push = (char *) dlnode
		    + dllist(dllist)->link_a.fplist.link_v.slip
		    + dllist(dllist)->link_a.fplist.link_v.item * pick;
	    }
	}
    }

    return status;
}
