/*
 * dlxx-types.h
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#ifndef __LIBx1f4_dlxx_types_H__
#define __LIBx1f4_dlxx_types_H__

#include <trans.h>

typedef struct fpnode_type {
    struct fpnode_type *fpnode_data[2];
    unsigned pick, text;
} fpnode_type;

typedef struct fplist_type {
    struct fpnode_type fplink;
    struct {
	unsigned item, node, size, slip, text;
    } link_v;
} fplist_type;

typedef struct screen_type {
    unsigned item, node;
    struct trans_type *trans_data;
} screen_type;

typedef struct dllist_type {
    struct {
	struct fplist_type fplist;
    } link_a;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
} dllist_type;

#endif				/* __LIBx1f4_dlxx_types_H__ */
