/*
 * dlxv.d.c
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>

#include <dlxx-defs.h>
#include <dlxx-names.h>
#include <dlxx-types.h>

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#if SIZEOF_UNSIGNED == 4
# define RATE_UNSIGNED			2
#else
# define RATE_UNSIGNED			0
#endif				/* SIZEOF_UNSIGNED == 4 */

#define copy_data(dllist, source, orange, target, violet) \
    {									      \
	unsigned n, v;							      \
	unsigned char *s, *t;						      \
									      \
	v = dllist((dllist))->link_a.fplist.link_v.slip;		      \
									      \
	n = dllist((dllist))->link_a.fplist.link_v.item;		      \
									      \
	s = (unsigned char *) (source) + v + n * (orange);		      \
									      \
	t = (unsigned char *) (target) + v + n * (violet);		      \
									      \
	for (; n; n--) {						      \
	    *t++ = *s++;						      \
	}								      \
    }

#if RATE_UNSIGNED
# undef copy_data
#endif				/* RATE_UNSIGNED */

#if RATE_UNSIGNED
# define copy_data(dllist, source, orange, target, violet) \
    {									      \
	unsigned n, v;							      \
	unsigned char *s, *t;						      \
									      \
	v = dllist((dllist))->link_a.fplist.link_v.slip;		      \
									      \
	n = dllist((dllist))->link_a.fplist.link_v.item;		      \
									      \
	s = (unsigned char *) (source) + v + n * (orange);		      \
									      \
	t = (unsigned char *) (target) + v + n * (violet);		      \
									      \
	if (((integral_q) s | (integral_q) t) & (SIZEOF_UNSIGNED - 1)) {      \
	    for (; n; n--) {						      \
		*t++ = *s++;						      \
	    }								      \
	} else {							      \
	    unsigned *e, *f;						      \
									      \
	    v = n >> RATE_UNSIGNED;					      \
									      \
	    e = (unsigned *) s;						      \
									      \
	    f = (unsigned *) t;						      \
									      \
	    n = v >> 2;							      \
	    for (; n; n--) {						      \
		*f++ = *e++;						      \
		*f++ = *e++;						      \
		*f++ = *e++;						      \
		*f++ = *e++;						      \
	    }								      \
	    v &= 3;							      \
	    for (; v; v--) {						      \
		*f++ = *e++;						      \
	    }								      \
									      \
	    n &= SIZEOF_UNSIGNED - 1;					      \
	    if (n) {							      \
		t = (unsigned char *) f;				      \
									      \
		s = (unsigned char *) e;				      \
									      \
		do {							      \
		    *t++ = *s++;					      \
		    --n;						      \
		} while (n);						      \
	    }								      \
	}								      \
    }
#endif				/* RATE_UNSIGNED */

#define dllist(dllist)			((struct dllist_type *) (dllist))

int
x1f4_roll_dllist(void *dllist)
{
    int status;

    if (dllist(dllist)->link_a.fplist.link_v.size < 2) {
	status = 0;
    } else {
	struct fpnode_type *fpnode_data, *fpnode_text;
	unsigned node, rate, text;

	fpnode_data = dllist(dllist)->link_a.fplist.fplink.fpnode_data[0];

	fpnode_text = dllist(dllist)->link_a.fplist.fplink.fpnode_data[1];

	node = dllist(dllist)->link_a.fplist.link_v.text;

	rate = fpnode_text->text;

	text = fpnode_data->text;

	if (text ^ 1) {
	    unsigned club, pick;

	    club = fpnode_text->pick;

	    pick = fpnode_data->pick;

	    if (club) {
		club--;

		text--;

		pick += text;

		copy_data(dllist, fpnode_data, pick, fpnode_text, club);

		fpnode_text->pick = club;

		status = 0;

		if (fpnode_data != fpnode_text) {
		    fpnode_data->text = text;
		    fpnode_text->text = rate + 1;
		}
	    } else {
		void *dlnode;

		status = dllist(dllist)->link_m.link
		    (dllist(dllist)->link_m.data, &dlnode,
		     dllist(dllist)->link_a.fplist.link_v.node);
		if (status) {
		    status = LINK_ERROR;
		} else {
		    struct fpnode_type *fpnode_case;

		    status = 0;

		    fpnode_case = dlnode;

		    fpnode_case->fpnode_data[0] = NULL;
		    fpnode_case->fpnode_data[1] = fpnode_text;

		    node--;

		    fpnode_case->pick = node;

		    fpnode_case->text = 1;

		    text--;

		    pick += text;

		    fpnode_data->text = text;

		    fpnode_text->fpnode_data[0] = fpnode_case;

		    copy_data(dllist, fpnode_data, pick, fpnode_case, node);

		    dllist(dllist)->link_a.fplist.fplink.fpnode_data[1] =
			fpnode_case;
		}
	    }
	} else {
	    if (rate ^ node) {
		struct fpnode_type *fpnode_case;
		unsigned club;

		club = fpnode_text->pick;

		club--;

		copy_data(dllist, fpnode_data, 0, fpnode_text, club);

		fpnode_case = fpnode_data->fpnode_data[0];

		status = dllist(dllist)->link_m.free
		    (dllist(dllist)->link_m.data, fpnode_data);
		if (status) {
		    status = FREE_ERROR;
		} else {
		    status = 0;

		    fpnode_text->pick = club;

		    fpnode_text->text = rate + 1;

		    fpnode_case->fpnode_data[1] = NULL;

		    dllist(dllist)->link_a.fplist.fplink.fpnode_data[0] =
			fpnode_case;
		}
	    } else {
		struct fpnode_type *fpnode_case;

		node--;

		copy_data(dllist, fpnode_data, 0, fpnode_data, node);

		fpnode_case = fpnode_data->fpnode_data[0];

		fpnode_data->pick = node;

		status = 0;

		fpnode_case->fpnode_data[1] = NULL;

		dllist(dllist)->link_a.fplist.fplink.fpnode_data[0] =
		    fpnode_case;

		fpnode_data->fpnode_data[0] = NULL;
		fpnode_data->fpnode_data[1] = fpnode_text;

		fpnode_text->fpnode_data[0] = fpnode_data;

		dllist(dllist)->link_a.fplist.fplink.fpnode_data[1] =
		    fpnode_data;
	    }
	}
    }

    return status;
}
