/*
 * dlxv.0.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <dlxx-defs.h>
#include <dlxx-names.h>
#include <dlxx-types.h>

#define dllist(dllist)			((struct dllist_type *) (dllist))

int
x1f4_lead_dllist(void *dllist, void **peek)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = dllist(dllist)->link_a.fplist.fplink.fpnode_data[1];
    if (fpnode_data) {
	status = 0;

	*peek = (char *) fpnode_data
	    + dllist(dllist)->link_a.fplist.link_v.slip
	    + dllist(dllist)->link_a.fplist.link_v.item * fpnode_data->pick;
    } else {
	status = DECK_ERROR;
    }

    return status;
}
