/*
 * cv.1.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include <dt.h>
#include <e4.h>
#include <variable.h>

int
x1f4_push_typelist(void **context,
		   const struct x1f4_datatype_type *datatype_data)
{
    const char *name;
    int status = 0;

    name = datatype_data->name;
    while (name) {
	unsigned i, size;
	void *variable;

	size = datatype_data->size;

	status = x1f4_line_variable
	    (context, &variable, sizeof(X1f4_E4_C_MODE), size + 3);
	if (status) {
	    break;
	} else {
	    X1f4_E4_C_MODE *mode;
	    char *slip;

	    mode = (void *)
		((char *) variable + sizeof(struct x1f4_variable_type));

	    slip = (char *) (mode + 1);

	    *mode = datatype_data->type;

	    memcpy(slip, name, size);
	    memcpy(slip + size, "_ID", 4);

	    i = size;
	    for (; i; i--) {
		int c;

		c = *(unsigned char *) slip;
		if (c < 'a' || 'z' < c) {
		} else {
		    *slip = c + 'A' - 'a';
		}

		slip++;
	    }

	    slip -= size;

	    status = x1f4_link_variable
		(context, variable, slip, size + 3, X1f4_E4_MODE,
		 X1f4_E4_READ_ONLY, mode);
	    if (status) {
		break;
	    }
	}

	datatype_data++;

	name = datatype_data->name;
    }

    return status;
}
