/*
 * cv.0.c
 * Copyright (C) 2010-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <variable.h>

static X1f4_E4_C_MODE intrinsics[] = {
/* *INDENT-OFF* */
    X1f4_E4_BILL,
    X1f4_E4_MODE,
    X1f4_E4_REAL,
    X1f4_E4_TEXT,
    X1f4_E4_VOID
/* *INDENT-ON* */
};

int
x1f4_push_intrinsics(void **context)
{
    int status;

    do {
	status = x1f4_push_variable
	    (context, "CARDINAL_ID", 11, X1f4_E4_MODE, X1f4_E4_READ_ONLY,
	     intrinsics + 0);
	if (status) {
	    break;
	}

	status = x1f4_push_variable
	    (context, "INTEGER_ID", 10, X1f4_E4_MODE, X1f4_E4_READ_ONLY,
	     intrinsics + 1);
	if (status) {
	    break;
	}

	status = x1f4_push_variable
	    (context, "REAL_ID", 7, X1f4_E4_MODE, X1f4_E4_READ_ONLY,
	     intrinsics + 2);
	if (status) {
	    break;
	}

	status = x1f4_push_variable
	    (context, "TEXT_ID", 7, X1f4_E4_MODE, X1f4_E4_READ_ONLY,
	     intrinsics + 3);
	if (status) {
	    break;
	}

	status = x1f4_push_variable
	    (context, "VOID_ID", 7, X1f4_E4_MODE, X1f4_E4_READ_ONLY,
	     intrinsics + 4);
    } while (0);

    return status;
}
