/*
 * copy.h
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_COPY_H__
#define __LIBx1f4_COPY_H__

#include <c-types.h>
#include <e4.h>

#define ___copy_i_mode(i)		(*((X1f4_E4_C_MODE *) (i)))
#define ___copy_i_real(r)		(*((X1f4_E4_C_REAL *) (r)))
#define ___copy_i_text(t)		(*((X1f4_E4_C_TEXT *) (t)))
#define ___copy_i_user(t)		(*((X1f4_E4_C_USER *) (t)))

#define ___copy_l_mode(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }
#define ___copy_l_real(e, output) \
    {									      \
	X1f4_E4_C_REAL *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }
#define ___copy_l_text(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }
#define ___copy_l_user(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define copy_miss(target, type, source) \
    {									      \
	switch ((type)) {						      \
	case X1f4_E4_MODE:						      \
	    ___copy_l_mode(___copy_i_mode((source)), (target));		      \
	    break;							      \
	case X1f4_E4_REAL:						      \
	    ___copy_l_real(___copy_i_real((source)), (target));		      \
	    break;							      \
	case X1f4_E4_TEXT:						      \
	    ___copy_l_text(___copy_i_text((source)), (target));		      \
	    break;							      \
	default:							      \
	    ___copy_l_user(___copy_i_user((source)), (target));		      \
	}								      \
    }

#if C_MODE_SIZEOF == C_REAL_SIZEOF
# if C_MODE_SIZEOF == C_TEXT_SIZEOF
#  if C_MODE_SIZEOF == C_USER_SIZEOF
#   undef copy_miss
#  else
#  endif			/* C_MODE_SIZEOF == C_USER_SIZEOF */
# else
# endif				/* C_MODE_SIZEOF == C_TEXT_SIZEOF */
#else
# if C_MODE_SIZEOF == C_TEXT_SIZEOF
#  if C_MODE_SIZEOF == C_USER_SIZEOF
#   undef copy_miss
#  else
#  endif			/* C_MODE_SIZEOF == C_USER_SIZEOF */
# else
# endif				/* C_MODE_SIZEOF == C_TEXT_SIZEOF */
#endif				/* C_MODE_SIZEOF == C_REAL_SIZEOF */

#if C_MODE_SIZEOF == C_REAL_SIZEOF
# if C_MODE_SIZEOF == C_TEXT_SIZEOF
#  if C_MODE_SIZEOF == C_USER_SIZEOF
#   define copy_miss(target, type, source) \
    {									      \
	if (1) {							      \
	    ___copy_l_mode(___copy_i_mode((source)), (target));		      \
	}								      \
    }
#  else
#  endif			/* C_MODE_SIZEOF == C_USER_SIZEOF */
# else
# endif				/* C_MODE_SIZEOF == C_TEXT_SIZEOF */
#else
# if C_MODE_SIZEOF == C_TEXT_SIZEOF
#  if C_MODE_SIZEOF == C_USER_SIZEOF
#   define copy_miss(target, type, source) \
    {									      \
	if ((type) ^ X1f4_E4_REAL) {					      \
	    ___copy_l_mode(___copy_i_mode((source)), (target));		      \
	} else {							      \
	    ___copy_l_real(___copy_i_real((source)), (target));		      \
	}								      \
    }
#  else
#  endif			/* C_MODE_SIZEOF == C_USER_SIZEOF */
# else
# endif				/* C_MODE_SIZEOF == C_TEXT_SIZEOF */
#endif				/* C_MODE_SIZEOF == C_REAL_SIZEOF */

#endif				/* __LIBx1f4_COPY_H__ */
