/*
 * c1i.h
 * Copyright (C) 2006, 2007, 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_c1i_H__
#define __LIBx1f4_c1i_H__

/*
 * node state bit definitions
 */
#define X1f4_C1_LINE_COPY		((1L << 0x1c) - 1)

/*
 * node state bit definitions (continued)
 */
#define X1f4_C1_1st_STATE		(1L << 0x1f)

typedef struct x1f4_c1node_type {
    struct x1f4_c1node_type *c1node_data;
    union {
	unsigned l;
	void *data;
    } data;
    unsigned state;
} x1f4_c1node_type;

extern int x1f4_land_program
    (void *, struct x1f4_c1node_type **);
extern int x1f4_list_program
    (void *, void *, int (*) (void *, struct x1f4_c1node_type *));
extern int x1f4_node_program
    (void *, struct x1f4_c1node_type **);

#endif				/* __LIBx1f4_c1i_H__ */
