/*
 * c1.z.c
 * Copyright (C) 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <c1-types.h>
#include <dt.h>
#include <e4.h>

typedef struct upcast_type {
    struct c1_lead_type lead;
    const struct x1f4_datatype_type *datatype_data;
} upcast_type;

static int slip_object(void *);

static int
slip_object(void *upcast)
{
    int status;
    struct upcast_type *upcast_data;
    const struct x1f4_datatype_type *datatype_data;

    upcast_data = upcast;

    datatype_data = upcast_data->datatype_data;
    if (datatype_data) {
	status = datatype_data->slip
	    (datatype_data->context, (void *) &upcast_data->lead);
    } else {
	status = 0;
    }

    return status;
}


int
_x1f4_c1_post_lead(void *program, void *context, void *post)
{
    int status;
    const struct x1f4_datatype_type *datatype_data;
    void *data, **mind;

    datatype_data = ((struct c1_program_type *) program)->v.f.text;

    status = ((struct c1_program_type *) program)->v.f.pick
	(((struct c1_program_type *) program)->u.data, &mind, slip_object,
	 sizeof(struct upcast_type), &data);
    if (status) {
    } else {
	struct upcast_type *upcast_data;

	*mind = data;

	upcast_data = data;

	status = datatype_data->lead(datatype_data->context, post);
	if (status) {
	    upcast_data->datatype_data = NULL;
	} else {
	    upcast_data->datatype_data = datatype_data;
	}

	/*
	 * FEATURES
	 *
	 * _post_ is assumed pointing to a location allocated large enough
	 * to keep a _struct c1_lead_type_ value.
	 */
	upcast_data->lead = *(struct c1_lead_type *) post;
    }

    return status;
}
