/*
 * c1.w.c
 * Copyright (C) 2007-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stddef.h>

#include <c1-defs.h>
#include <c1-errors.h>
#include <c1-types.h>
#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
# include <cardinal.v-f.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4.h>

#define c1_long_type			x1f4_eelookup_type

#define dump_abcdef_error_i_ARGS_0 \
    void *, int (*) (void *, const char *, unsigned), const char *,	      \
    struct c1_back_type *, struct c1_long_type *
#define dump_abcdef_error_i_ARGS_1 \
    void *data, int (*this) (void *, const char *, unsigned),		      \
    const char *head, struct c1_back_type *back_data,			      \
    struct c1_long_type *long_data
#define dump_abcdef_error_i_ARGS_2 \
    data, this, head, back_data, long_data

#define dump_abcdef_error_l_ARGS_0 \
    void *, int (*) (void *, const char *, unsigned), const char *,	      \
    struct c1_back_type *
#define dump_abcdef_error_l_ARGS_1 \
    void *data, int (*this) (void *, const char *, unsigned),		      \
    const char *head, struct c1_back_type *back_data
#define dump_abcdef_error_l_ARGS_2 \
    data, this, head, back_data

static int dump_080707_error_0(dump_abcdef_error_i_ARGS_0);
static int dump_080707_error_1(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_2(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_3(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_4(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_5(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_6(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_7(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_8(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_9(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_a(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_b(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_c(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_d(dump_abcdef_error_l_ARGS_0);
static int dump_080707_error_e(dump_abcdef_error_i_ARGS_0);
static int dump_080707_error_f(dump_abcdef_error_l_ARGS_0);
static int dump_090828_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_090828_error_1(dump_abcdef_error_l_ARGS_0);
static int dump_091025_error_0(dump_abcdef_error_i_ARGS_0);
static int dump_110725_error_0(dump_abcdef_error_i_ARGS_0);
static int dump_111221_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_120115_error_0(dump_abcdef_error_l_ARGS_0);
static int dump_line(void *, int (*) (void *, const char *, unsigned),
		     const char *, unsigned, struct c1_back_type *);
static int dump_type(void *, int (*) (void *, const char *, unsigned), int,
		     struct c1_long_type *);

static int
dump_080707_error_0(dump_abcdef_error_i_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": expression syntax: ", 21);
	if (status) {
	} else {
	    if (long_data) {
		struct x1f4_eelookup_type eelookup;

		eelookup.type_l.context = long_data->type_l.context;
		eelookup.type_l.fix = long_data->type_l.fix;
		eelookup.type_q.e4fine = long_data->type_q.e4fine;

		status = x1f4_stat_expression
		    (data, this, &back_data->data.e_syntax.eerecord,
		     &eelookup);
	    } else {
		status = x1f4_stat_expression
		    (data, this, &back_data->data.e_syntax.eerecord, NULL);
	    }
	}
    }

    return status;
}


static int
dump_080707_error_1(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": void value not ignored as it ought to be", 42);
}


static int
dump_080707_error_2(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": syntax error", 14);
}


static int
dump_080707_error_3(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": missing prefix test statement block", 37);
}


static int
dump_080707_error_4(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": unexpected block completion syntax", 36);
}


static int
dump_080707_error_5(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": statement syntax error", 24);
}


static int
dump_080707_error_6(dump_abcdef_error_l_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": variable `", 12);
	if (status) {
	} else {
	    status = this
		(data, back_data->line, back_data->data.variable.size);
	    if (status) {
	    } else {
		status = this(data, "' redeclared", 12);
	    }
	}
    }

    return status;
}


static int
dump_080707_error_7(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": missing block completion syntax", 33);
}


static int
dump_080707_error_8(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": missing suffix test statement block", 37);
}


static int
dump_080707_error_9(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": missing block leave completion syntax", 39);
}


static int
dump_080707_error_a(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": unexpected block leave statement", 34);
}


static int
dump_080707_error_b(dump_abcdef_error_l_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": invalid variable name (`", 26);
	if (status) {
	} else {
	    status = this
		(data, back_data->line, back_data->data.reserved.size);
	    if (status) {
	    } else {
		status = this(data, "')", 2);
	    }
	}
    }

    return status;
}


static int
dump_080707_error_c(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": missing declarations completion syntax", 40);
}


static int
dump_080707_error_d(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": suffix test statement syntax error", 36);
}


static int
dump_080707_error_e(dump_abcdef_error_i_ARGS_1)
{
    int status;

    if (0) {
    } else {
	status = this
	    (data, ": mismatched type of `return' statement (expected ", 50);
	if (status) {
	} else {
	    status = dump_type
		(data, this, back_data->data.m_return.slip, long_data);
	    if (status) {
	    } else {
		status = this(data, ", found ", 8);
		if (status) {
		} else {
		    status = dump_type
			(data, this, back_data->data.m_return.type, long_data);
		    if (status) {
		    } else {
			status = this(data, ")", 1);
		    }
		}
	    }
	}
    }

    return status;
}


static int
dump_080707_error_f(dump_abcdef_error_l_ARGS_1)
{
    return this(data, "missing block completion syntax", 31);
}


static int
dump_090828_error_0(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": unexpected `return' statement", 31);
}


static int
dump_090828_error_1(dump_abcdef_error_l_ARGS_1)
{
    return this(data, ": empty `return' statement", 26);
}


static int
dump_091025_error_0(dump_abcdef_error_i_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": used ", 7);
	if (status) {
	} else {
	    status = dump_type
		(data, this, back_data->data.w_scalar.type, long_data);
	    if (status) {
	    } else {
		status = this(data, " value where scalar is required", 31);
	    }
	}
    }

    return status;
}


static int
dump_110725_error_0(dump_abcdef_error_i_ARGS_1)
{
    int status;

    if (1) {
	status = this(data, ": declared data of non declarable ", 34);
	if (status) {
	} else {
	    status = dump_type
		(data, this, back_data->data.w_scalar.type, long_data);
	    if (status) {
	    } else {
		status = this(data, " data type", 10);
	    }
	}
    }

    return status;
}


static int
dump_111221_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": ", 2);
    if (status) {
    } else {
	status = x1f4_stat_e4jack
	    (data, this, &back_data->data.higherof.ejrecord);
    }

    return status;
}


static int
dump_120115_error_0(dump_abcdef_error_l_ARGS_1)
{
    int status;

    status = this(data, ": bad `", 7);
    if (status) {
    } else {
	const char *line;

	line = back_data->line;

	status = this(data, line, 1);
	if (status) {
	} else {
	    status = this(data, "' (", 3);
	    if (status) {
	    } else {
		status = x1f4_vprint_fcardinal
		    (data, this, 0, 4, 8, *(unsigned char *) line);
		if (status) {
		} else {
		    status = this
			(data, ") character where variable name expected", 40);
		}
	    }
	}
    }

    return status;
}


static int
dump_line(void *data, int (*this) (void *, const char *, unsigned),
	  const char *head, unsigned bits, struct c1_back_type *back_data)
{
    int status;

    if (bits & HINT_MASK) {
	status = back_data->hint.rule
	    (back_data->hint.data, back_data->pick, back_data->line - head);
    } else {
	const char *dana, *line;
	unsigned byte, rank;

	line = back_data->line;

	rank = back_data->pick;

	byte = line - head;

	dana = head;
	while (byte) {
	    byte--;
	    if (*dana == 10) {
		rank++;
		head = dana;
	    }

	    dana++;
	}

	status = x1f4_vprint_dcardinal(data, this, rank);
    }

    return status;
}


static int
dump_type(void *data, int (*this) (void *, const char *, unsigned), int type,
	  struct c1_long_type *long_data)
{
    struct x1f4_eelookup_type eelookup;

    eelookup.type_l.context = long_data->type_l.context;
    eelookup.type_l.fix = long_data->type_l.fix;
    eelookup.type_q.e4fine = long_data->type_q.e4fine;

    return x1f4_dump_type(data, this, type, &eelookup);
}


int
x1f4_lame_program(void *data, int (*this) (void *, const char *, unsigned),
		  const char *head, unsigned bits,
		  struct c1_back_type *back_data,
		  struct x1f4_eelookup_type *eelookup_data)
{
    int status;

    switch (back_data->code) {
    case L_SCOPES:
	status = dump_080707_error_f(data, this, head, back_data);
	break;
    default:
	status = dump_line(data, this, head, bits, back_data);
	if (status) {
	} else {
	    switch (back_data->code) {
	    case BLOCKOUT:
		status = dump_080707_error_4(data, this, head, back_data);
		break;
	    case B_SYNTAX:
		status = dump_080707_error_2(data, this, head, back_data);
		break;
	    case COMPLETE:
		status = dump_080707_error_c(data, this, head, back_data);
		break;
	    case E_RETURN:
		status = dump_090828_error_1(data, this, head, back_data);
		break;
	    case E_SYNTAX:
		status = dump_080707_error_0
		    (data, this, head, back_data, eelookup_data);
		break;
	    case HIGHEROF:
		status = dump_111221_error_0(data, this, head, back_data);
		break;
	    case LOOPEXIT:
		status = dump_080707_error_9(data, this, head, back_data);
		break;
	    case LOOSE_DB:
		status = dump_080707_error_7(data, this, head, back_data);
		break;
	    case MISSLOOP:
		status = dump_080707_error_8(data, this, head, back_data);
		break;
	    case MISSTEST:
		status = dump_080707_error_3(data, this, head, back_data);
		break;
	    case M_RETURN:
		status = dump_080707_error_e
		    (data, this, head, back_data, eelookup_data);
		break;
	    case NAMEMISS:
		status = dump_120115_error_0(data, this, head, back_data);
		break;
	    case OUTBREAK:
		status = dump_080707_error_a(data, this, head, back_data);
		break;
	    case RESERVED:
		status = dump_080707_error_b(data, this, head, back_data);
		break;
	    case SIDEDATA:
		status = dump_110725_error_0
		    (data, this, head, back_data, eelookup_data);
		break;
	    case S_SYNTAX:
		status = dump_080707_error_d(data, this, head, back_data);
		break;
	    case T_SYNTAX:
		status = dump_080707_error_5(data, this, head, back_data);
		break;
	    case USEDVOID:
		status = dump_080707_error_1(data, this, head, back_data);
		break;
	    case VARIABLE:
		status = dump_080707_error_6(data, this, head, back_data);
		break;
	    case W_SCALAR:
		status = dump_091025_error_0
		    (data, this, head, back_data, eelookup_data);
		break;
	    case X_RETURN:
	    default:
		status = dump_090828_error_0(data, this, head, back_data);
	    }
	}
    }

    return status;
}
